-- CREATE DATABASE pgquadogeo;
--> se connecter à la base pgquadogeo

-- RAZ
DROP RULE IF EXISTS insert_vue_adresse ON vue_adresse;

DROP VIEW IF EXISTS vue_adresse;

DROP TRIGGER IF EXISTS coherence_geom_commune ON adresse;
DROP FUNCTION IF EXISTS verifier_coherence_geom_commune;

DROP TABLE IF EXISTS agent;
DROP TABLE IF EXISTS poste;
DROP TABLE IF EXISTS emploi;
DROP TABLE IF EXISTS service;
DROP TABLE IF EXISTS adresse;
DROP TABLE IF EXISTS commune;
DROP TABLE IF EXISTS departement;
DROP TABLE IF EXISTS region;

DROP TABLE IF EXISTS ref_adr_moulezan;
DROP TABLE IF EXISTS ref_adr_montagnac;
DROP TABLE IF EXISTS ref_adr_mauressargues;
DROP TABLE IF EXISTS vecteur_montagnac;
DROP TABLE IF EXISTS vecteur_mauressargues;
DROP TABLE IF EXISTS echantillon_1_1_simple_aleatoire;
DROP TABLE IF EXISTS echantillon_1_2_simple_aleatoire;
DROP TABLE IF EXISTS echantillon_2_oriente_objet;
DROP TABLE IF EXISTS echantillon_3_oriente_surface;
DROP TABLE IF EXISTS echantillon_4_aleatoire_stratifie;
DROP TABLE IF EXISTS selection_grille_rectangle;
DROP TABLE IF EXISTS echantillon_5_semi_aleatoire_rectangle;
DROP TABLE IF EXISTS selection_grille_hexagone;
DROP TABLE IF EXISTS echantillon_6_semi_aleatoire_hexagone;

DROP TABLE IF EXISTS etablissement_sirene;
DROP TABLE IF EXISTS batiment;
DROP TABLE IF EXISTS bdtopo_troncon_de_route_20211215;
DROP TABLE IF EXISTS bdtopo_troncon_de_route_20221215;
DROP TABLE IF EXISTS osm_highway_20230226;
DROP TABLE IF EXISTS erreur_superposition;
DROP TABLE IF EXISTS erreur_zone_blanche;
DROP TABLE IF EXISTS geocodate_etablissement_sirene;
DROP TABLE IF EXISTS ppv_batiment_adresse;
DROP TABLE IF EXISTS etendue_voie;
DROP TABLE IF EXISTS eloignement_adresses_successives;
DROP TABLE IF EXISTS evolution_troncon_stricte;
DROP TABLE IF EXISTS evolution_troncon_lache;
DROP TABLE IF EXISTS comparaison_ign_osm_severe;
DROP TABLE IF EXISTS comparaison_ign_osm_juste;
DROP TABLE IF EXISTS giratoire_osm_non_ferme;
DROP TABLE IF EXISTS orienter_troncon;
DROP TABLE IF EXISTS point24500;

DROP DOMAIN IF EXISTS email;

DROP CAST IF EXISTS (varchar AS type_emploi);
DROP FUNCTION IF EXISTS varchar_2_type_emploi;
DROP TYPE IF EXISTS type_emploi;

-- ****************************************************************************
-- Création du modèle.
-- ****************************************************************************

CREATE EXTENSION IF NOT EXISTS postgis;
CREATE EXTENSION IF NOT EXISTS postgis_topology;

CREATE TABLE departement (
    cog varchar(3) NOT NULL,
    nom varchar NOT NULL,
    cog_region varchar(2) NOT NULL,
    nom_region varchar NOT NULL,
    
    CONSTRAINT pk_departement PRIMARY KEY (cog)
);

CREATE TABLE commune (
    code_postal varchar(5) NOT NULL,
    nom varchar NOT NULL,
    cog varchar(5) NOT NULL,
    cog_departement varchar(3) NOT NULL,
    
    CONSTRAINT pk_commune PRIMARY KEY (code_postal, nom),
    CONSTRAINT fk_commune_departement FOREIGN KEY (cog_departement) REFERENCES departement (cog)
);

SELECT AddGeometryColumn('commune', 'geom', 2154, 'multipolygon', 2);

CREATE TABLE adresse (
    id varchar NOT NULL,
    libelle varchar NOT NULL,
    code_postal_commune varchar NOT NULL,
    nom_commune varchar NOT NULL,
    
    CONSTRAINT pk_adresse PRIMARY KEY (id),
    CONSTRAINT fk_adresse_commune FOREIGN KEY (code_postal_commune, nom_commune) REFERENCES commune (code_postal, nom)
);

SELECT AddGeometryColumn('adresse', 'geom', 2154, 'point', 2);

CREATE TABLE service (
    id integer NOT NULL,
    nom varchar NOT NULL,
    
    CONSTRAINT pk_service PRIMARY KEY (id)
);

CREATE TABLE poste (
    id integer NOT NULL,
    nom varchar NOT NULL,
    id_service integer NOT NULL,
    
    CONSTRAINT pk_poste PRIMARY KEY (id),
    CONSTRAINT fk_poste_service FOREIGN KEY (id_service) REFERENCES service (id)
);

CREATE TABLE agent (
    nom varchar NOT NULL,
    prenom varchar NOT NULL,
    genre varchar(1) NOT NULL,
    date_naissance date NOT NULL,
    email varchar NOT NULL,
    type_emploi varchar,
    id_poste integer NOT NULL,
    id_adresse varchar,
    
    CONSTRAINT fk_agent_poste FOREIGN KEY (id_poste) REFERENCES poste (id),
    CONSTRAINT fk_agent_adresse FOREIGN KEY (id_adresse) REFERENCES adresse (id)
);

-- ****************************************************************************
-- Remplissage (avec erreurs) du modèle.
-- ****************************************************************************

INSERT INTO departement VALUES ('07', 'Ardeche', '84', 'Auvergne-Rhone-Alpes');
INSERT INTO departement VALUES ('48', 'Lozere', '76', 'Occitanie');
INSERT INTO departement VALUES ('12', 'Aveyron', '76', 'Ocitanie');
INSERT INTO departement VALUES ('84', 'Vaucluse', '93', 'Provence-Alpes-Cote d''Azur');
INSERT INTO departement VALUES ('13', 'Bouches-du-Rhone', '93', 'Provence-Alpes-Cote d''Azur');
INSERT INTO departement VALUES ('34', 'Herault', '76', 'Occitanie');
INSERT INTO departement VALUES ('30', 'Gard', '76', 'Occitanie');

INSERT INTO commune VALUES ('30800', 'Saint-Gilles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
INSERT INTO commune VALUES ('30620', 'Bernis', '30036', '30', '01060000206A0800000100000001030000000100000060040000CDCCCCCCAA742841000000009E0758419A999999A8742841666666C69F07584166666666A7742841CDCCCC2CA107584100000000A774284100000040A2075841CDCCCCCCA6742841CDCCCC6CA30758419A999999C574284166666606A40758419A999999E174284166666606A407584133333333E8742841000000C0B50758419A99999912752841333333F3C1075841CDCCCCCC1C7528419A999939CC075841CDCCCCCC3A752841CDCCCC6CCC075841666666663775284133333333DB075841666666668775284100000060DC07584133333333D97528419A9999D9D9075841666666660B762841333333D3DD07584100000000C57528419A999919F807584133333333C275284133333333F907584166666666BE7528419A999999FA07584166666666B47528419A999919FD0758419A999999B07528419A9999590008584100000000AF752841333333330208584133333333A8752841333333730308584133333333A3752841CDCCCCEC0308584166666666A17528416666664604085841CDCCCCCC907528419A9999D908085841333333338F7528419A9999F9090858419A9999998D7528419A9999790B085841333333338D752841333333730D085841000000008D752841333333D30E085841CDCCCCCC8C75284100000020100858419A99999993752841CDCCCC6C140858413333333399752841CDCCCCCC17085841666666669B752841CDCCCC8C180858419A999999A37528419A9999791B08584100000000B9752841666666262008584100000000C575284100000000220858419A999999D0752841666666062308584133333333E2752841CDCCCCAC250858419A99999909762841000000602B0858410000000024762841CDCCCCAC2E0858416666666628762841333333B32F085841666666662F762841666666E631085841000000003676284166666666340858413333333348762841CDCCCCCC32085841333333336B762841000000802F0858413333333382762841333333132D085841CDCCCCCC947628419A9999B92A08584166666666A8762841000000E02708584100000000C9762841000000402208584133333333FB7628419A9999F918085841CDCCCCCC617728419A9999D92508584100000000CC772841666666863208584100000000DF772841666666063908584133333333F7772841CDCCCC4C36085841CDCCCCCC1F78284166666606320858419A999999327828419A9999593008584100000000467828419A9999192D0858413333333355782841333333932F08584100000000E578284100000020290858419A999999A9792841333333732008584166666666C1792841CDCCCC0C2508584100000000E3792841666666C62308584100000000DC792841CDCCCC6C21085841CDCCCCCC717A28416666666617085841CDCCCCCCA37A2841333333732008584166666666EC7A2841CDCCCC8C2D0858419A999999247B2841000000A02D0858419A999999447B2841666666263A08584100000000727B28410000004042085841333333337C7B2841000000204308584133333333707B2841000000604408584100000000557B28410000006048085841000000004B7B28419A9999594A085841000000004A7B28419A9999F94B08584133333333597B28419A9999194F0858419A9999996A7B28410000002051085841000000006F7B28419A99999952085841666666666E7B2841CDCCCC0C5408584133333333677B28416666666656085841666666665A7B2841333333B359085841000000004D7B2841666666065E085841CDCCCCCC437B2841CDCCCCAC61085841333333334E7B2841666666266208584100000000607B2841666666C6630858419A999999817B28419A9999D96608584100000000A17B28419A999919690858419A999999AF7B2841CDCCCC4C6A08584166666666BA7B2841333333B36B085841CDCCCCCCC57B28419A9999F96C08584166666666CD7B28419A9999B96D08584133333333D47B2841666666466E08584166666666E17B2841000000206F08584166666666007C28416666662671085841CDCCCCCC237C2841000000807308584166666666327C28419A999999740858419A999999437C2841666666E66E085841CDCCCCCC657C28419A9999997108584166666666597C2841666666A675085841000000004E7C2841000000607908584100000000587C2841000000207B08584166666666197C2841333333F382085841666666662D7C28419A99995984085841333333333B7C2841CDCCCC0C850858419A9999995E7C28419A9999B9870858419A9999997A7C28419A9999D988085841000000006C7C2841333333938E0858419A9999999D7C28410000002091085841CDCCCCCCCE7C2841000000609408584166666666F87C2841CDCCCCCC9608584100000000227D28410000004098085841CDCCCCCC4A7D2841333333139A0858419A999999677D2841333333B39B08584100000000577D2841333333F39C08584133333333447D28419A9999599E085841666666663E7D2841666666C69E08584133333333357D2841000000809F08584133333333017D2841666666C69F08584133333333A17C2841CDCCCCCC9C0858419A999999B37C2841CDCCCCCCA7085841000000005A7D2841CDCCCCECAB0858419A9999996D7D2841666666C6AA0858419A999999937D28419A999999A808584133333333A87D284166666606A708584166666666BD7D284133333333A608584166666666C17D2841CDCCCC8CAA08584100000000C87D28419A9999F9AF0858419A999999D07D2841000000C0B208584133333333EC7D2841333333D3B8085841CDCCCCCC097E284133333313BE0858419A999999967D284166666606CB085841666666664F7D284133333393D2085841CDCCCCCC787D2841666666E6D3085841333333338C7D284166666606D5085841CDCCCCCCFB7D284133333353D9085841333333335A7E2841CDCCCC8CDE085841CDCCCCCC787E284133333333E008584133333333767E284133333313E108584166666666627E2841CDCCCC2CE808584133333333627E2841CDCCCC0CED085841CDCCCCCCA47E2841000000E0EF0858419A999999E17E2841CDCCCCCCF308584166666666AC7E28419A999919010958419A999999997E2841666666860509584166666666A97E284133333393060958419A9999999A7E28419A9999390A09584100000000C57E2841CDCCCCEC14095841CDCCCCCCEA7E28419A9999F915095841CDCCCCCCE87E28413333331317095841CDCCCCCCE67E2841CDCCCC8C1809584166666666E47E2841333333131A0958419A999999E37E2841000000401B0958419A999999457F2841666666661D095841CDCCCCCC5E7F28419A9999991209584100000000387F2841333333B30E095841CDCCCCCC397F2841333333330E095841000000003B7F2841CDCCCC8C0D0958419A9999993C7F2841666666E60C095841CDCCCCCC3E7F2841CDCCCC2C0C0958419A999999437F2841CDCCCC0C0B095841CDCCCCCC497F2841000000400A0958419A9999995F7F2841CDCCCC6C06095841333333336D7F28410000006004095841CDCCCCCC717F2841CDCCCCEC0309584166666666777F28419A99999903095841333333337F7F2841CDCCCC0C0309584133333333857F28410000006002095841CDCCCCCC897F2841CDCCCC8C0109584100000000977F28419A9999F9FD08584100000000A47F284166666626FA08584166666666BB7F284166666666F5085841CDCCCCCCDE7F2841CDCCCCACEE085841CDCCCCCCF57F28419A999999EA0858419A999999F87F2841CDCCCC0CEA085841CDCCCCCCFD7F2841000000C0E9085841CDCCCCCC03802841333333B3E90858419A99999908802841CDCCCC8CE90858419A99999913802841CDCCCCECE80858416666666620802841000000C0E7085841666666662A802841333333B3E608584166666666388028419A999939E5085841333333334D802841CDCCCCCCE2085841CDCCCCCC6B80284100000080DF0858416666666679802841333333D3DD085841666666667D802841CDCCCCECDC0858419A99999981802841333333B3DB085841666666669180284166666626D708584166666666A180284166666646D308584166666666BA802841666666E6CD08584100000000CD802841333333D3CA08584100000000EE802841CDCCCC2CC608584100000000FF802841CDCCCC8CC4085841666666663081284166666626C1085841666666665581284133333353BF08584166666666608128419A9999B9BE085841333333336B812841CDCCCC2CBE085841000000007B81284166666606BD085841666666669F81284133333393B90858419A999999BD812841CDCCCC6CB608584166666666E381284133333373B308584166666666FF812841333333B3B108584100000000138228419A999979B0085841CDCCCCCC2582284100000000B1085841000000004E822841000000A0B0085841000000006B82284100000020B0085841000000008882284133333353AF0858419A99999983822841333333F398085841333333334B8228416666664695085841000000004D8228416666668690085841CDCCCCCC66822841000000408F085841000000006D822841CDCCCCAC88085841333333336E822841000000408708584133333333AA822841CDCCCC2C8708584166666666AC822841CDCCCCAC89085841CDCCCCCCFC822841333333538D085841333333331E8328419A9999B96A085841000000007B832841666666666A085841333333337983284133333353640858410000000075832841000000805C085841333333336C832841000000C05B085841CDCCCCCC8F83284166666666540858419A999999C683284100000040520858419A999999E1832841CDCCCC0C4F085841CDCCCCCCE6832841333333B34C0858419A999999FE8328410000004046085841000000000F842841000000204308584166666666548428416666660635085841333333335E8428419A99991933085841CDCCCCCC62842841CDCCCCEC31085841333333338A842841333333B32A0858410000000099842841000000402B0858419A999999F3842841666666C62E0858413333333398852841333333531E08584166666666A4852841CDCCCC0C2008584133333333CE852841000000801E085841CDCCCCCCF98528419A9999F918085841333333333886284166666626040858419A9999993B8628419A999919FF0758419A9999993D862841666666E6FB0758419A999999D18628419A999939FD07584133333333F9862841CDCCCCACF40758410000000001872841333333F3F00758419A9999990987284100000020EF075841000000001A8728419A9999F9E70758419A9999991B872841000000C0E6075841CDCCCCCC1B87284100000000E60758419A9999992087284100000040E20758419A99999923872841CDCCCCECDF0758413333333330872841CDCCCCECDA075841666666663487284133333313D9075841666666663787284166666666D7075841000000003987284166666686D6075841CDCCCCCC3D87284166666666D607584166666666448728419A999959D607584166666666488728419A999979D5075841333333334F8728419A999999D20758413333333359872841CDCCCC6CCE075841CDCCCCCC6B872841000000A0C70758419A9999997087284133333393C6075841666666667987284133333393C5075841333333339687284166666606BF075841CDCCCCCCA1872841666666E6BE0758419A999999C6872841CDCCCC6CBE075841CDCCCCCC0F8828419A999919BD0758413333333347882841333333D3BB075841333333338088284166666666BA075841CDCCCCCC8D88284133333313BA075841666666669F882841CDCCCCECB807584100000000AA88284133333393B807584166666666E3882841666666A6B60758413333333309892841CDCCCC2CB5075841333333331D89284133333393B4075841CDCCCCCC3889284100000080B307584133333333618928419A9999B9B1075841CDCCCCCC8A89284133333393AF07584166666666B9892841000000C0AD07584166666666DF89284166666686AC07584100000000F189284100000040AC07584166666666FE89284133333353AC07584166666666ED892841333333939C0758419A999999E38928419A9999B992075841333333334E8A28419A9999D9770758419A9999997A8A2841CDCCCCCC5E075841CDCCCCCCA68A2841333333D35507584133333333AF8A284100000020540758419A999999D18A2841CDCCCC8C4D075841CDCCCCCC098B28419A9999194607584133333333198B2841CDCCCCAC44075841000000003E8B28410000002040075841000000004D8B2841666666463E07584166666666738B2841CDCCCCEC3A075841333333337B8B2841000000E03907584166666666A88B2841000000A0330758419A999999E58B2841666666062B075841CDCCCCCC078C2841CDCCCCCC2607584166666666178C28419A99993925075841000000001E8C2841CDCCCC0C2507584100000000348C2841CDCCCC6C23075841666666664A8C2841666666C62107584100000000998C2841666666661B07584166666666D08C2841000000001707584166666666FD8C28410000006013075841CDCCCCCC108D2841333333531207584166666666258D2841000000C0110758419A9999993F8D28416666668611075841CDCCCCCC5A8D284166666626110758419A9999996B8D2841000000601007584166666666798D2841CDCCCC4C0E075841666666668B8D2841000000A00B0758419A999999A28D2841666666E607075841CDCCCCCCB58D2841CDCCCCEC040758419A999999D08D284133333313020758419A999999F68D284100000000FF06584133333333148E284100000080FC065841333333331A8E284166666606FC06584166666666308E284133333333FA065841CDCCCCCC508E28419A999959F7065841000000006C8E2841CDCCCCECF406584166666666818E28419A9999F9F3065841CDCCCCCC968E28419A999999F206584166666666BD8E2841CDCCCC4CF0065841CDCCCCCCC88E28419A999979EF06584100000000D68E284166666686EE0658419A999999F48E284133333353EB0658419A999999058F284166666626E906584133333333168F28419A9999B9E6065841CDCCCCCC368F28419A999979E006584100000000528F284166666606DB065841000000005C8F284133333353D9065841CDCCCCCC708F2841000000C0DA065841000000009F8F28419A9999D9DD0658419A999999B68F284100000020DF06584100000000C08F284166666606DD065841CDCCCCCCCF8F28419A999939D906584100000000DB8F2841CDCCCC2CD606584100000000E68F28419A9999B9D206584133333333F08F28419A999939CF06584133333333FB8F28419A9999B9CB06584133333333099028419A999939C7065841333333331590284166666626C3065841000000001D9028419A9999B9BF065841CDCCCCCC2090284166666626BC065841CDCCCCCC289028419A999919B9065841333333333690284166666686B506584166666666469028419A9999F9B1065841CDCCCCCC53902841000000C0AE065841000000005A9028419A999959AC065841333333335B902841CDCCCC4CA9065841666666665C90284100000060A6065841666666666190284100000080A3065841000000006A902841333333939F0658419A999999739028419A9999D99A06584133333333759028419A9999799906584100000000709028419A9999199906584133333333669028416666664698065841333333335F9028413333339397065841666666665E902841000000C0960658419A999999639028419A999959950658419A9999997290284133333333920658416666666686902841CDCCCC8C8D065841000000009B9028419A99991989065841CDCCCCCC9F902841CDCCCC0C88065841CDCCCCCCA8902841CDCCCCAC85065841CDCCCCCCAA902841000000A08406584100000000A5902841000000E083065841000000007C902841000000E0800658419A9999997D902841333333D37F0658413333333396902841333333337A065841CDCCCCCCCB902841333333B36D06584166666666EA9028410000000066065841666666660E9128419A9999195D065841CDCCCCCC3E9128416666664652065841666666664D912841333333F34E065841CDCCCCCC6B912841666666E647065841000000007091284100000040460658419A9999996C9128419A999999450658416666666662912841666666C64406584166666666519128410000008043065841333333334C912841CDCCCC8C42065841000000004C91284133333313410658413333333358912841000000603E065841000000006A912841000000203A0658413333333368912841CDCCCC4C39065841666666665791284133333353380658416666666612912841CDCCCCEC3406584133333333F29028419A9999193306584166666666E29028419A9999F931065841CDCCCCCCEA9028410000000030065841000000000A9128410000006029065841000000005D912841CDCCCC0C17065841000000006D9128413333331313065841CDCCCCCC82912841333333331306584100000000AD912841CDCCCCAC130658419A999999CE91284166666666140658419A99999904922841000000001606584166666666289228419A99991917065841666666663C92284166666666170658419A9999995C922841666666E617065841666666667F922841CDCCCC0C190658416666666699922841000000001A06584166666666A8922841000000401A06584166666666B3922841CDCCCC4C1A065841CDCCCCCCBC922841CDCCCC0C1A06584133333333C5922841CDCCCC4C1906584166666666D89228413333337314065841CDCCCCCC0393284100000040090658419A9999991E932841000000C0010658419A9999994193284166666606F80558419A9999996A93284166666686ED055841333333337E932841333333B3E80558416666666693932841CDCCCC6CE50558419A999999AF93284166666606E105584133333333FE93284133333313D7055841333333332194284166666626D3055841000000003394284133333353D1055841000000003794284100000040CD0558413333333337942841CDCCCC6CCC0558419A99999939942841CDCCCC0CC5055841333333333F942841333333D3B9055841666666664C942841CDCCCC8CB30558419A99999956942841000000C0B0055841000000001B95284133333353A60558419A99999924952841333333D3A5055841CDCCCCCC2D95284133333353A5055841333333331A9528419A9999F998055841CDCCCCCC0A952841000000C0930558419A99999905952841000000C09205584166666666F2942841333333138F0558419A999999C89428416666660689055841CDCCCCCCA99428419A99997986055841000000008A94284100000080850558419A9999994594284133333333830558419A99999925942841CDCCCC0C8105584133333333EA932841000000607A05584133333333BC93284166666606750558410000000099932841000000A070055841000000007D932841CDCCCC0C6A055841666666664F9328419A9999995C055841000000003E932841CDCCCC8C58055841000000001E932841333333F3520558419A999999DB9228419A9999394905584133333333CD9228419A9999B94605584133333333C1922841666666A64405584133333333B0922841666666464205584166666666919228419A9999F93F055841000000006B922841CDCCCCAC3D055841CDCCCCCC429228419A9999F93B05584166666666F6912841666666C6390558419A9999997E9128419A99991936055841666666663B912841333333B33305584166666666AE902841333333B32F055841666666667C902841CDCCCCEC2E055841666666665E902841CDCCCCAC2E0558419A999999259028419A9999592F05584166666666CC8F2841666666663205584133333333918F28419A999999330558419A9999995C8F2841000000A033055841CDCCCCCC2F8F28419A9999993205584100000000148F284100000080310558419A999999E48E28419A9999792F05584133333333A98E2841CDCCCCEC2A055841000000005D8E2841333333532405584166666666498E2841000000A02205584166666666E48D2841000000C0190558419A9999998E8D28416666660612055841CDCCCCCC8F8D2841000000A01005584100000000958D2841666666E60A055841CDCCCCCC988D28410000002008055841333333339B8D28419A9999F9050558419A9999999C8D2841000000C003055841CDCCCCCC9F8D2841000000600205584100000000CB8D28419A999939FE04584166666666D48D284166666686FD04584133333333EF8D2841666666E6FC0458419A999999F88D2841CDCCCC0CF80458419A999999FE8D2841666666E6F404584100000000068E2841000000C0F2045841333333330D8E28419A999939F0045841CDCCCCCC128E284166666646EE04584133333333138E2841666666E6EB045841666666660B8E2841CDCCCC0CEA04584100000000068E2841000000C0E704584133333333008E28419A999999E404584100000000FE8D284166666666E104584100000000008E28419A999999DD0458419A999999018E28419A999999DA04584166666666028E2841CDCCCCACD70458419A999999038E2841CDCCCC0CD40458419A999999068E284133333373D0045841CDCCCCCC078E284166666646CF045841666666660E8E28419A999959C904584133333333168E2841CDCCCC4CC604584133333333208E2841CDCCCCACC304584133333333268E28419A999919C2045841666666662A8E284166666686BF0458419A9999993B8E2841666666A6B80458419A999999598E2841333333B3AC04584133333333608E284166666606AA04584133333333758E2841333333F3A104584166666666A18E2841333333F39004584166666666AD8E28419A9999998A04584166666666AC8E2841CDCCCC2C8604584100000000AD8E2841333333338404584133333333AB8E28419A9999D9820458419A9999999E8E2841000000607F0458419A999999988E28419A9999997D0458419A999999948E2841333333537C04584133333333928E2841CDCCCC6C7A0458419A999999918E2841CDCCCCEC7704584100000000908E28413333331375045841000000008F8E2841CDCCCC8C72045841666666668D8E2841333333B3700458419A999999838E2841CDCCCC6C6C045841666666667F8E2841CDCCCCAC6A0458419A999999808E28419A9999796904584166666666858E28416666660668045841333333338E8E2841CDCCCCCC65045841666666669F8E2841000000C06204584133333333BA8E2841333333D35F0458419A999999CB8E2841333333335E045841CDCCCCCCE38E2841000000E05C0458419A9999990B8F2841333333B35B045841666666661E8F2841666666E65A045841CDCCCCCC278F2841000000C059045841666666662B8F2841CDCCCC4C5804584133333333308F2841CDCCCCAC520458419A999999328F28419A999919510458419A999999398F28413333333350045841CDCCCCCC588F2841000000E04C0458419A999999648F2841000000404C04584100000000708F2841333333334C04584166666666768F2841CDCCCCAC4B045841CDCCCCCC778F2841000000604A0458419A999999768F2841CDCCCCCC48045841CDCCCCCC728F2841000000A04604584166666666518F2841CDCCCC2C3E045841666666664E8F2841666666063C045841000000004F8F2841333333F33904584100000000528F28413333333338045841666666665A8F28419A9999993504584166666666718F2841333333F32E04584100000000768F2841666666C62D045841000000007D8F2841000000402D045841CDCCCCCC868F2841CDCCCC4C2D0458419A999999948F2841333333D32D0458419A999999B08F2841000000602E04584133333333C38F2841666666062E0458419A999999DD8F2841333333532C045841CDCCCCCCEE8F2841333333D32A045841CDCCCCCCFA8F2841CDCCCC2C2904584100000000049028413333331327045841000000000A902841CDCCCCAC24045841CDCCCCCC0A902841CDCCCCEC220458419A999999099028419A99997921045841CDCCCCCC04902841000000601F04584133333333F78F28419A99997919045841CDCCCCCCF48F284133333333180458419A999999F28F28419A9999191704584166666666F08F284100000000140458419A999999EF8F2841000000A0110458419A999999F28F2841CDCCCCAC0E04584100000000F68F2841666666860B04584100000000F58F2841666666A6070458419A999999F18F28419A9999590604584100000000EA8F2841000000A004045841CDCCCCCCE28F2841CDCCCC6C0304584133333333DB8F28419A9999D902045841CDCCCCCCCE8F2841CDCCCC6C0204584133333333C58F28419A9999790204584166666666838F28419A9999590404584133333333798F2841CDCCCC6C040458419A9999996F8F2841000000000404584100000000688F28419A99993903045841CDCCCCCC628F2841CDCCCC4C0204584100000000568F2841000000400004584100000000498F2841666666E6FE035841CDCCCCCC468F2841333333F3FD03584133333333308F284100000020F703584166666666278F28419A9999F9F403584166666666228F28419A999999F30358419A999999178F28419A9999B9F103584166666666088F28419A999919F003584133333333FF8E284133333353EF03584100000000F18E284133333353EE0358419A999999E48E2841333333F3ED03584133333333D38E2841333333B3ED035841CDCCCCCCB98E2841CDCCCC2CED03584166666666938E2841333333D3EB03584166666666828E2841CDCCCC8CEA035841CDCCCCCC5F8E2841666666A6E603584100000000558E2841CDCCCCCCE4035841CDCCCCCC4D8E284166666626E303584166666666488E2841CDCCCC8CE0035841CDCCCCCC468E28419A999959DF0358419A999999458E28419A999939DE03584133333333448E284166666606DC03584166666666428E28419A999939D90358419A9999993C8E284133333393D3035841666666663B8E28419A9999B9D10358419A999999378E284166666666D0035841333333332D8E28419A9999B9CF0358419A9999991D8E284133333353CF035841666666660E8E2841333333F3CE03584133333333048E284100000000CF03584100000000F88D2841000000A0CF03584100000000D28D28419A9999D9D1035841CDCCCCCCA88D2841CDCCCC4CD3035841000000007F8D284100000040D4035841666666666A8D2841CDCCCC0CD503584100000000588D284100000020D6035841333333334B8D2841CDCCCCACD7035841CDCCCCCC398D2841000000E0D9035841CDCCCCCC2F8D284100000040DB03584166666666208D284133333373DC0358419A999999108D28419A999919DD03584100000000FC8C284166666686DD03584100000000D98C28419A999939DE03584100000000CA8C28419A999999DF035841CDCCCCCCC48C284166666646E003584166666666BF8C2841666666E6E003584100000000B88C2841666666A6E203584133333333B08C2841666666A6E40358419A999999A88C2841CDCCCC4CE703584133333333A58C284166666686E803584166666666A08C284100000020EA0358419A999999998C284133333353EB03584100000000838C2841333333D3EC0358419A999999768C2841333333F3EC0358419A999999688C2841000000E0EC03584133333333598C2841CDCCCC8CEC0358419A9999994A8C2841000000C0EB035841333333333E8C28419A999959EA03584100000000328C2841CDCCCCCCE803584133333333268C28419A9999B9E603584100000000198C2841CDCCCC8CE4035841CDCCCCCC0D8C2841CDCCCCCCE203584133333333EA8B284166666626DE0358419A999999DF8B28419A999959DC0358419A999999DA8B284133333313DB0358419A999999DA8B284133333353DA03584133333333DA8B2841000000E0D803584100000000DC8B2841CDCCCCECD603584133333333E98B2841CDCCCC8CCD0358419A999999EA8B2841000000A0CA0358419A999999E88B284133333333C80358419A999999E48B28419A999939C503584133333333DE8B28419A9999B9C203584133333333D78B284133333353C003584100000000CF8B28419A9999D9BD03584166666666C48B2841000000E0BB0358419A999999BC8B2841333333D3BA035841CDCCCCCCB48B2841000000C0B903584133333333A88B2841000000A0B8035841CDCCCCCC978B284133333353B70358419A999999868B284166666606B603584100000000798B2841333333D3B403584166666666648B2841CDCCCCCCB203584133333333458B2841333333D3AF03584133333333238B2841000000A0AC0358419A999999188B2841666666A6AB035841CDCCCCCC0D8B2841CDCCCCECAA03584133333333D68A2841666666C6A903584166666666C28A284100000000A9035841CDCCCCCCB48A284166666626A8035841CDCCCCCCA68A2841333333D3A6035841666666669A8A284166666686A50358419A9999998F8A2841666666C6A303584100000000838A28419A999979A10358419A999999698A28419A9999399D03584100000000628A28419A9999F99B035841000000005A8A2841666666C69A03584166666666518A2841000000C09903584133333333448A28410000000099035841333333333A8A2841000000A098035841CDCCCCCC268A28419A99997998035841000000001C8A28410000002099035841666666660E8A2841000000209A03584133333333FC892841333333139B0358419A999999EC892841000000809B0358419A999999E3892841000000A09B03584100000000DA892841666666C69B03584133333333CB8928419A9999B99B03584166666666BC892841CDCCCCAC9B035841CDCCCCCCB4892841CDCCCC6C9B03584133333333AE892841333333539B035841CDCCCCCCA08928419A9999399A035841666666669789284166666686990358419A9999998B892841000000E098035841CDCCCCCC688928419A9999B9970358419A99999951892841333333D396035841CDCCCCCC3B892841CDCCCCAC9503584166666666068928419A9999D99303584133333333C6882841333333F39003584166666666B08828413333331390035841CDCCCCCCBA8828419A9999B98D0358419A999999E4882841666666A67E03584133333333EA8828419A9999F97D035841CDCCCCCCF5882841333333737D0358419A99999907892841333333F37C0358416666666614892841000000E07C035841CDCCCCCC2F892841000000A07D0358410000000045892841CDCCCCAC7E035841000000006A892841CDCCCC4C800358413333333372892841666666868003584133333333788928413333333380035841000000007C892841000000807F0358416666666689892841333333737B035841CDCCCCCCAD8928419A99995971035841CDCCCCCCB58928419A9999196F035841CDCCCCCCC5892841333333F36A0358419A999999CB892841CDCCCC2C6A03584100000000DD892841000000C0680358419A999999EB892841CDCCCC8C67035841333333331A8A2841000000606303584133333333288A28419A99991962035841333333333A8A28419A99995960035841333333335A8A28419A9999995B0358419A999999898A2841666666065303584100000000B18A2841333333334A03584133333333B48A28413333339349035841CDCCCCCC868B28413333339320035841CDCCCCCCD48B2841666666A60203584133333333858B284166666646FA025841000000000E8B2841CDCCCCCCED02584100000000E08A2841333333F3E802584100000000F48A284133333353E7025841CDCCCCCC5F8B2841CDCCCC0CE402584100000000C58B284133333373E002584100000000108C2841000000E0DD02584133333333548C284133333393DB02584166666666118D2841CDCCCC6CD5025841000000007D8D2841CDCCCC2CD20258419A999999C38D284166666626D002584166666666E78D2841333333B3CF02584166666666F28D2841CDCCCC8CCF025841CDCCCCCC1E8E28419A999919CF025841CDCCCCCC568E284166666626CF02584166666666818E284166666666CF0258419A999999AF8E2841CDCCCCCCCF02584100000000DB8E284166666646D0025841000000001A8F2841666666A6D002584166666666328F28419A999999D00258419A999999498F284166666666D0025841666666664F8F28419A999959D0025841CDCCCCCC5D8F2841CDCCCC2CD0025841333333337D8F2841CDCCCCACCF025841CDCCCCCCAF8F2841000000C0CE02584100000000D78F2841CDCCCCCCCD02584166666666F78F28419A999919CD025841666666660C902841666666A6CC02584166666666219028419A999999CC025841000000003D9028419A999999CC0258413333333343902841000000A0CC0258419A9999994390284100000040CA025841000000004A902841333333D3C8025841CDCCCCCC4E90284166666626C30258419A9999996B9028419A9999B9B40258410000000082902841CDCCCC0CA802584100000000849028419A9999F9A6025841000000009C9028419A9999D99702584166666666A89028419A9999198F02584166666666469028419A999979880258416666666687902841000000806B0258419A9999990C902841333333336702584133333333EF8F28419A9999D96502584100000000D08F2841666666C66402584166666666B28F28419A9999196402584166666666578F28413333339362025841CDCCCCCCDE8E28413333331360025841CDCCCCCC958E2841CDCCCCCC5D025841666666662C8E2841CDCCCC0C5C02584166666666CA8D2841000000405B02584166666666658D2841CDCCCC8C5902584133333333608D284100000080590258419A999999FC8C28419A9999D957025841CDCCCCCCB98C28419A99999957025841666666669D8C28413333337358025841000000006D8C28419A99995959025841CDCCCCCC378C2841333333135A02584133333333FE8B28419A9999795B0258419A9999997D8B2841333333F37A0258419A9999994F8B2841CDCCCC2C85025841CDCCCCCC358B2841666666668B025841333333330B8B28419A9999D99602584133333333EF8A2841000000E09C02584100000000EF8A2841666666269E02584166666666E28A2841333333F3A1025841CDCCCCCCD08A284133333353A8025841CDCCCCCCC18A2841CDCCCC4CAF02584133333333BC8A2841333333F3B302584133333333B38A2841000000C0B9025841CDCCCCCCAE8A284100000060BB02584100000000A88A28419A9999D9BC0258419A999999878A284166666626C4025841666666667F8A2841000000C0C5025841CDCCCCCC698A2841CDCCCC8CC8025841333333334D8A2841CDCCCCECCC0258419A9999993D8A2841333333D3CF02584100000000278A2841333333B3D402584166666666038A2841CDCCCCCCD00258419A999999ED8928419A999959D602584166666666E3892841CDCCCCECD80258413333333333892841666666C6050358419A9999990D892841000000600F035841CDCCCCCC07892841CDCCCCCC1003584133333333BF882841CDCCCC6C2303584100000000868828419A9999D9310358419A99999946882841666666E641035841666666663088284166666686470358410000000037882841CDCCCCEC4703584166666666BC8728419A9999196D03584166666666798728416666666680035841666666663E872841333333D37C035841000000000087284133333393780358419A999999A3862841333333B3700358413333333369862841000000406A0358419A9999994286284133333333660358416666666632862841666666A66803584166666666EC852841333333B37A03584166666666BD8528410000004087035841CDCCCCCC83852841000000A096035841CDCCCCCC7885284100000080990358413333333370852841CDCCCCCC9A0358419A99999965852841000000E09A035841333333334E852841000000609B035841CDCCCCCC40852841CDCCCCCC9B0358419A99999932852841000000E09C03584166666666278528419A9999599E035841666666661A85284100000080A00358410000000012852841666666E6A20358416666666609852841CDCCCC2CA603584100000000FC84284133333393AA03584100000000F4842841666666C6AC03584100000000EF842841CDCCCCECAD035841333333330885284133333353B3035841CDCCCCCC2D852841666666E6BB03584166666666478528419A9999B9C20358410000000058852841CDCCCC2CC9035841CDCCCCCC5E8528419A999959CD035841666666665B852841333333D3D30358419A9999994D852841CDCCCCECD9035841666666664185284166666626E10358413333333339852841333333B3E8035841666666662F852841CDCCCC6CE80358410000000017852841CDCCCCECE80358416666666600852841CDCCCCECEB0358419A999999F48428419A999979ED035841CDCCCCCCC184284166666646F20358419A999999B7842841CDCCCC8CF603584133333333B684284100000040F803584100000000BC8428419A9999B9F903584133333333B384284133333373FB035841333333330D842841333333D317045841CDCCCCCC04842841666666A61804584166666666028428419A9999191A045841CDCCCCCC9C832841CDCCCC6C2B0458416666666697832841CDCCCC6C2C0458419A9999995F8328419A9999D928045841000000003C832841666666E6300458419A99999914832841CDCCCCCC3904584133333333F18228416666668641045841000000009E822841333333B353045841CDCCCCCC998228413333337354045841666666668F8228419A99995956045841000000008682284166666606580458413333333373822841000000A05A0458416666666663822841333333D35B0458416666666650822841000000C05C045841000000003C822841000000005E0458413333333333822841CDCCCC6C5F045841666666662F8228419A9999396004584133333333BB812841CDCCCCEC7804584166666666818128419A99991985045841000000006C812841000000A089045841666666665D812841666666C68B0458413333333354812841000000408D0458419A9999994C812841CDCCCC0C8E045841000000003A812841CDCCCCCC900458419A9999992E812841000000809204584133333333248128419A99997992045841000000001B812841333333939204584166666666238128413333331395045841CDCCCCCC28812841000000E096045841000000002C812841666666A6980458410000000025812841CDCCCC4C9B045841CDCCCCCC16812841666666869E045841CDCCCCCC0981284100000020A104584100000000FD802841CDCCCC6CA3045841CDCCCCCCCB80284133333353AD04584133333333A180284166666606B7045841666666669580284100000040B9045841000000006C8028419A999999C2045841666666663980284100000080CD045841CDCCCCCC068028419A999999D80458419A9999990480284166666646D90458419A9999990080284166666666DA04584166666666C37F2841CDCCCC0CE904584133333333B47F28419A9999D9EC045841CDCCCCCCA87F2841666666C6EE045841000000006F7F2841CDCCCC0CFD045841CDCCCCCC647F2841333333B3FF0458419A999999627F2841CDCCCC6C01055841CDCCCCCC667F2841CDCCCC2C09055841000000006E7F2841666666E61105584166666666767F2841666666661C055841333333337A7F2841333333731F055841CDCCCCCC8C7F284133333333210558419A999999C57F28419A999939240558416666666615802841CDCCCC2C2A055841000000002F8028419A999939320558419A99999902802841333333133A05584166666666E37F28419A9999B94005584166666666DE7F2841CDCCCCCC4105584133333333BC7F2841000000604805584133333333AA7F2841333333D34A05584166666666827F2841000000604E05584100000000757F2841000000C04E05584100000000717F28419A9999994D05584166666666FF7E2841CDCCCCAC6005584166666666FA7E2841000000606105584166666666F97E284100000040620558419A999999FC7E2841666666666405584100000000257F2841CDCCCC0C71055841CDCCCCCC327F2841CDCCCCEC7405584166666666327F2841CDCCCCEC750558419A9999992D7F2841666666267705584166666666267F2841333333D37705584133333333197F2841000000607805584133333333077F2841CDCCCC6C79055841CDCCCCCCF07E2841CDCCCC0C7C05584100000000E37E2841CDCCCCEC7D05584166666666D47E2841CDCCCCEC7F05584133333333C27E2841666666068405584100000000B47E2841CDCCCCEC8705584133333333947E28419A9999B990055841CDCCCCCC717E2841000000A0990558419A999999627E2841CDCCCC8C9D055841CDCCCCCC447E28419A999999A505584133333333397E2841666666C6A80558419A999999237E284100000020AD055841CDCCCCCC087E284100000080B20558419A999999057E284100000020B305584133333333EF7D2841CDCCCC6CB705584133333333E37D2841CDCCCCCCB80558419A999999D37D28419A999919BA0558419A999999C07D284133333333BB05584133333333857D2841333333D3C1055841666666664B7D284166666666CB05584133333333D17C284100000020C6055841CDCCCCCCA57C284166666666C6055841CDCCCCCC9A7C284166666666CB0558419A999999417C28419A999959C705584166666666087C2841666666A6C605584133333333D27B28419A9999F9C505584166666666A67B2841CDCCCC6CC5055841666666668F7B284166666666C8055841666666667E7B284100000060CA055841333333337E7B28419A999979CC055841CDCCCCCC6D7B284100000020CE05584133333333317B284133333313D4055841666666660E7B284100000000D505584166666666F77A2841000000A0D5055841CDCCCCCCF07A284166666626D30558419A999999E17A284100000060D305584100000000DF7A2841CDCCCC6CD3055841000000008F7A2841333333F3D105584166666666867A284133333333D505584100000000857A28419A9999B9D50558419A9999997B7A2841CDCCCC0CD605584133333333457A28419A9999F9D705584166666666A9792841CDCCCC4CDB05584100000000A879284100000060DB0558416666666679792841333333D3DD055841CDCCCCCC8079284166666666EB055841CDCCCCCC8279284133333333EF055841CDCCCCCC5979284166666646EF05584133333333407928419A9999B9F00558410000000022792841333333B3F20558419A9999990D7928419A999979F405584133333333F4782841333333B3F605584133333333CE78284133333373FA05584166666666B478284100000040FD055841000000009B7828419A9999D9000658419A999999837828419A9999B904065841333333337C782841CDCCCC8C06065841CDCCCCCC6F7828419A99999909065841CDCCCCCC5578284100000080100658413333333342782841CDCCCC6C16065841333333332C782841000000001C065841333333330E782841CDCCCCEC21065841CDCCCCCCE6772841CDCCCC2C2906584133333333CB7728419A9999792F0658419A999999BA772841333333D33206584100000000A47728416666664636065841CDCCCCCC98772841CDCCCCCC370658419A999999937728413333333339065841000000009377284100000060390658419A9999998A772841CDCCCC8C3B065841CDCCCCCC727728419A9999B9420658419A99999964772841000000A046065841000000005E77284100000060470658410000000055772841CDCCCCEC470658419A999999397728419A999959480658416666666634772841000000204C0658419A9999992A772841666666A6510658419A999999157728419A9999D95B065841CDCCCCCCF77628419A9999596706584166666666F3762841333333F36906584133333333F37628419A9999D96D06584166666666F2762841333333F37206584133333333F2762841CDCCCC8C7506584133333333E8762841000000607D0658419A999999DD762841CDCCCCEC82065841CDCCCCCCD7762841333333D38306584100000000BD7628419A999939860658419A999999A67628410000004088065841CDCCCCCC9E762841333333F388065841333333338E762841000000C08A065841CDCCCCCC79762841666666A68C0658413333333363762841CDCCCC2C8E065841CDCCCCCC4B762841CDCCCC6C8F0658419A9999991F762841333333D39006584166666666137628419A99995991065841CDCCCCCCF6752841666666A69206584133333333DE752841333333F39306584100000000C67528419A9999F9950658410000000097752841333333B39A06584100000000637528419A9999599F065841CDCCCCCC477528419A999919A10658416666666628752841000000A0A2065841333333330D75284100000020A306584166666666E07428419A999979A30658419A9999998774284166666666A3065841000000004D74284166666666A3065841CDCCCCCC3F742841CDCCCC4CA3065841CDCCCCCC22742841000000C0A30658419A9999991174284166666666A406584133333333FC732841333333B3A506584133333333DC73284166666646A80658419A999999D273284133333313A90658416666666684732841CDCCCC8CB00658419A99999933732841CDCCCC0CB8065841CDCCCCCC0B7328419A999999BB06584133333333F37228419A999919BE0658419A999999DB722841666666E6C106584133333333A2722841000000C0CC065841666666665B7228419A999919DB065841CDCCCCCC8F722841CDCCCC0CF4065841666666667772284166666666220758410000000075722841CDCCCC4C270758416666666664722841CDCCCCCC290758419A9999994D722841666666E62C07584166666666487228419A9999792F0758419A99999945722841666666A630075841CDCCCCCC42722841666666A631075841666666663E722841CDCCCCAC32075841333333332C722841666666C635075841CDCCCCCC26722841666666A636075841333333332472284166666646370758410000000021722841333333B338075841CDCCCCCC197228419A9999D93B0758410000000014722841333333D33D075841CDCCCCCC0B722841CDCCCCAC3F07584166666666FF712841666666A642075841CDCCCCCCEB7128410000000048075841CDCCCCCCDD712841CDCCCC2C4C07584100000000D7712841333333334E075841CDCCCCCCD07128419A9999F94F07584166666666C57128416666662652075841CDCCCCCCC8712841000000605307584166666666D2712841333333135607584133333333EB712841000000005B075841333333330F722841333333B3610758419A99999917722841CDCCCCCC6307584100000000247228419A9999D966075841CDCCCCCC2D722841CDCCCC2C6A075841CDCCCCCC32722841666666666C075841000000004B722841CDCCCCEC72075841000000005A72284166666626760758419A99999961722841CDCCCC6C770758419A9999996E7228416666660679075841CDCCCCCC7F7228419A9999D97A0758410000000098722841333333137D07584100000000B67228419A9999D97F075841CDCCCCCCDD722841666666A6830758419A999999E2722841666666668407584100000000E5722841CDCCCC0C85075841CDCCCCCCE67228419A9999198607584166666666E9722841CDCCCC8C8707584100000000EC722841CDCCCCEC8B07584100000000FA722841666666068C0758410000000000732841666666268C0758416666666617732841000000A08C0758410000000044732841000000608D07584100000000567328419A9999998D07584133333333647328419A9999198E0758416666666670732841666666868E07584166666666A4732841000000809007584133333333CF73284166666606930758419A999999DA732841000000A09307584166666666F0732841CDCCCCCC9407584100000000FE732841CDCCCC2C9507584166666666097428410000006095075841CDCCCCCC1474284100000080950758413333333322742841CDCCCC8C95075841333333332E742841666666A6950758419A9999993C742841333333B39507584100000000477428419A99999995075841000000005174284133333333950758419A99999974742841CDCCCCCC940758419A99999982742841333333B394075841666666668D742841CDCCCCCC94075841333333339C742841CDCCCCEC940758419A999999A574284166666606950758419A999999AD7428416666662695075841CDCCCCCCB87428419A9999599507584100000000C47428419A99997995075841CDCCCCCCBC74284133333333960758419A999999B0742841666666069807584133333333AF7428410000004099075841CDCCCCCCAA742841000000009E075841');
INSERT INTO commune VALUES ('30190', 'Sainte-Anastasie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
INSERT INTO commune VALUES ('30820', 'Caveirac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
INSERT INTO commune VALUES ('30000', 'Nimes', '30189', '30', '01060000206A08000001000000010300000001000000B70A0000CDCCCCCC7A67284166666666660F5841CDCCCCCC4E67284100000060670F584133333333606628419A9999F9790F5841666666662C66284133333333900F5841CDCCCCCC2A662841333333B3980F58419A9999996366284166666626AA0F5841666666664D6628419A999919C80F5841CDCCCCCC4566284166666626D20F5841000000003D662841000000C0D80F58419A9999993A66284100000000DB0F58416666666632662841666666A6DE0F58410000000018662841CDCCCC8CE50F584166666666AA6528419A99993902105841CDCCCCCCA66528419A99997909105841666666669C652841000000E00B1058419A9999996B6528416666664617105841000000008C652841000000C021105841666666664C652841333333F325105841000000004265284166666686261058419A999999416528419A9999B92610584100000000476528419A99997927105841000000004A652841CDCCCC4C2A105841CDCCCCCC43652841CDCCCC6C2D1058419A99999938652841CDCCCC0C30105841333333332F652841000000E031105841666666662C652841CDCCCCCC341058419A9999990C652841CDCCCC6C3F1058419A999999F964284133333393471058419A999999EB642841000000804C1058419A999999E86428419A99999950105841CDCCCCCC4065284166666606541058419A9999994F652841000000C066105841333333334765284100000080841058419A999999636528419A9999398A105841CDCCCCCC90652841666666E6A61058416666666666652841666666C6A7105841CDCCCCCC52652841333333F3A7105841333333334B65284166666606A8105841666666663665284166666646A810584166666666316528419A999979A8105841000000002E652841333333B3AB105841666666661C65284133333313BE105841333333331565284133333373C8105841CDCCCCCC1265284166666646CB1058416666666614652841000000E0CC1058416666666619652841CDCCCC8CD01058419A9999992665284100000080D7105841666666662D65284133333313DB1058416666666631652841333333F3DF1058413333333330652841CDCCCC4CE3105841000000002F65284133333393E8105841CDCCCCCC2A652841CDCCCC8CF0105841333333332865284133333333F710584166666666286528419A9999D9F9105841000000002B65284133333373FD105841CDCCCCCC3B652841CDCCCCEC02115841666666664D6528419A9999591D115841CDCCCCCC5065284133333373221158410000000053652841CDCCCCCC25115841CDCCCCCC66652841333333D34311584133333333696528419A9999994711584166666666B96528416666668649115841CDCCCCCC13662841CDCCCC6C531158419A99999941662841CDCCCC6C581158419A999999526628413333333359115841000000005C662841666666C659115841000000006A662841000000205B115841CDCCCCCC7C662841CDCCCCCC5C115841CDCCCCCC90662841CDCCCCCC5E11584166666666B06628419A9999996111584133333333D5662841CDCCCC8C6411584166666666F0662841333333F3661158410000000013672841333333536A1158419A9999993D672841000000C06D115841666666665D672841CDCCCC6C7011584166666666726728416666660672115841000000008B672841333333D3731158419A999999A8672841666666467611584100000000CF6728419A9999F97911584100000000DC6728419A9999397B115841333333330D682841333333F37F11584166666666266828419A99995982115841CDCCCCCC2D6828413333331383115841666666664D682841333333F3861158419A99999966682841CDCCCCEC8911584166666666726828419A9999598B115841000000008D682841666666468E115841CDCCCCCC9D682841000000409011584100000000A76828419A9999B99111584166666666AA682841333333B39211584133333333AE682841000000C09511584133333333D86828419A999939B7115841CDCCCCCCE96828419A999959C5115841333333332969284166666606F8115841000000004E6928410000000005125841000000006469284166666646091258413333333380692841000000C00E1258419A9999998A692841333333F31212584166666666B0692841CDCCCC2C1E125841CDCCCCCCE3692841000000802C12584166666666FB6928419A99999933125841CDCCCCCC216A2841000000A03B12584100000000376B28416666666672125841666666665A6B28413333337378125841333333337F6B2841333333937E1258419A999999966B2841666666468212584100000000AD6B2841CDCCCCAC851258419A999999BF6B28419A9999598912584166666666D46B2841666666268D125841CDCCCCCCE36B2841CDCCCCCC9012584166666666F66B2841333333D3951258419A999999FC6B28419A99991997125841CDCCCCCCFF6B2841CDCCCC6C9712584133333333296C284100000000A712584100000000326C284133333353AA12584100000000416C28419A9999F9AF125841666666664B6C2841333333D3B312584166666666616C2841333333F3BB1258419A999999B86C28419A9999D9D2125841CDCCCCCCD56C284133333393DA125841CDCCCCCCF96C28419A999919E4125841CDCCCCCC086D284133333313E81258419A999999F76C284166666626F612584166666666CE6C2841333333931713584133333333546C28419A9999D9411358419A999999836C2841000000405613584133333333C26C284100000020711358419A999999C96C2841666666467413584100000000DD6C2841000000E07413584133333333F36D2841CDCCCCAC7D135841666666660D6E2841666666867E135841000000001A6E2841333333537F1358419A9999992D6E28419A9999398013584100000000496E284166666646811358419A999999626E2841666666A6821358419A9999997D6E28419A9999B983135841CDCCCCCC9C6E28419A9999998413584100000000AB6E2841CDCCCC2C8513584133333333B76E2841000000808513584133333333C16E2841666666868513584133333333C76E2841333333938513584133333333D06E2841666666A68513584133333333DD6E2841000000408613584133333333E96E2841000000408713584133333333F46E28410000002088135841CDCCCCCC036F2841CDCCCCAC8813584133333333226F2841333333F3891358419A9999993E6F2841000000E08A13584100000000646F2841CDCCCC0C8C13584100000000926F2841CDCCCC2C8E13584100000000CD6F28413333337390135841CDCCCCCC04702841000000809213584166666666127028410000000093135841CDCCCCCC38702841CDCCCC6C9413584133333333677028416666662696135841CDCCCCCC97702841CDCCCCEC9713584100000000B8702841666666269913584133333333DE702841666666669A135841666666661A712841666666E69C13584166666666647128419A999959A013584100000000317228419A9999F9B61358416666666644722841CDCCCCACB91358419A9999995372284133333333BB135841CDCCCCCC6272284133333333BD135841666666667472284166666686BF1358419A9999998B72284100000040C1135841333333339F72284166666626C313584166666666C172284133333373CC1358419A999999D4722841000000A0D11358419A999999ED72284100000080D81358410000000007732841CDCCCC6CDF13584166666666277328419A999939E81358413333333363732841CDCCCC8CF8135841CDCCCCCC8E7328410000006004145841CDCCCCCCBD732841333333331114584100000000A0742841000000C014145841000000007C75284133333333181458419A9999998475284133333353181458413333333303762841333333531A145841CDCCCCCC37762841666666261B14584166666666CC7628419A9999791D145841CDCCCCCC4B7728419A9999791F1458419A9999995A7828416666664636145841333333336278284166666686391458419A99999974782841333333B33E145841000000008D782841CDCCCC6C441458410000000096782841666666064814584166666666987828419A9999794A1458410000000098782841666666064C1458410000000097782841333333F34D1458419A99999993782841333333934F14584133333333917828419A9999D9501458419A99999983782841333333D354145841000000007F7828419A999939581458410000000080782841CDCCCC6C5A1458413333333387782841CDCCCCCC5C1458419A9999999F782841333333F3631458419A999999C0782841000000C06A14584166666666D1782841CDCCCCEC7014584133333333DB7828419A9999797514584166666666DC782841333333537814584133333333DC782841666666867A14584100000000DC782841CDCCCC6C7B14584166666666DC782841333333737D145841CDCCCCCCE4782841333333538214584166666666E7782841666666868314584100000000F0782841333333938714584166666666FE782841333333D38A1458419A9999990E7928419A9999998D145841CDCCCCCC11792841CDCCCCEC8E1458413333333319792841000000E091145841666666661E792841000000C096145841CDCCCCCC267928419A9999F99D145841333333332B7928419A9999F9A3145841666666662C79284166666626A7145841666666662B792841CDCCCCACA81458419A999999287928419A999919AC1458410000000028792841333333F3AD145841CDCCCCCC2879284133333393B1145841666666662B792841CDCCCC2CB5145841000000002A79284166666666B9145841CDCCCCCC2979284133333313BB1458419A9999992B79284166666606BC145841666666663279284100000060BF145841CDCCCCCC4C79284100000000C91458416666666661792841CDCCCC6CD1145841CDCCCCCC74792841333333D3D9145841333333337979284133333353DB145841333333338C79284133333333E2145841CDCCCCCCA17928419A999919EA145841CDCCCCCCA5792841333333B3EA14584166666666B3792841CDCCCCACEC14584166666666087A28419A9999F90015584100000000337A284133333313FB145841CDCCCCCCF07A2841CDCCCC0CEE145841CDCCCCCC367B2841CDCCCC0CE914584133333333827B2841000000E0E3145841CDCCCCCCF17B284166666626DC1458419A999999397C284166666646D714584100000000677C284133333373D414584133333333D27C2841CDCCCC4CD3145841CDCCCCCCDA7C28419A999939D31458419A999999937D284166666646D114584100000000FF7D284100000020D01458419A999999317E2841CDCCCC2CCC145841CDCCCCCC627E284100000060C814584100000000747E2841333333D3C6145841CDCCCCCC797E284133333373C61458419A999999887E2841CDCCCC6CC5145841333333339E7E284166666606C414584166666666A47E2841333333D3C31458419A999999AF7E284166666666C314584100000000C37E2841CDCCCC2CC314584100000000DB7E2841333333F3C214584133333333F37E284166666686C2145841333333331A7F28419A9999F9C1145841CDCCCCCC3D7F284100000060C114584100000000517F28419A999939C114584100000000607F284133333313C114584133333333837F2841CDCCCC2CC114584166666666917F284133333353C114584133333333A27F284100000080C114584100000000B97F2841000000A0C114584166666666C77F284133333393C114584133333333D27F284133333373C114584133333333E27F2841333333B3C1145841CDCCCCCC8A802841CDCCCCACB714584100000000B2802841CDCCCC8CB6145841CDCCCCCCCD802841CDCCCC6CB514584166666666EB802841CDCCCCECB314584166666666018128419A9999D9B21458416666666624812841CDCCCC4CB1145841333333333B812841333333F3AF14584133333333418128419A999999AF1458416666666660812841333333F3AD145841CDCCCCCC81812841000000A0AC14584100000000A1812841000000A0AB14584133333333C7812841333333B3AA145841CDCCCCCCE3812841666666A6A9145841CDCCCCCC0282284133333373A8145841CDCCCCCC2382284100000000A71458419A999999478228419A999959A51458410000000065822841000000C0A3145841CDCCCCCC7F82284100000020A2145841CDCCCCCC91822841000000C0A2145841CDCCCCCCA7822841666666E6A214584166666666B682284100000000A31458419A999999DF82284133333333A314584166666666E482284100000040A314584100000000FC82284133333373A3145841333333330D83284133333373A31458419A99999921832841666666A6A3145841CDCCCCCC2C832841000000C0A31458413333333336832841666666E6A31458416666666636832841CDCCCCECA4145841CDCCCCCC36832841333333F3A5145841666666663A832841666666A6B1145841000000003E832841CDCCCCCCBE145841000000003B832841333333D3CC1458410000000039832841333333F3D2145841CDCCCCCC36832841333333B3DD145841000000003583284133333393E9145841000000003583284166666606F51458413333333335832841CDCCCCACFC1458419A9999995C832841333333D3F71458419A99999965832841000000C0F614584166666666B2832841CDCCCC4CED1458419A9999998484284133333393D314584100000000D48528419A999979AA145841CDCCCCCC63862841000000C0A1145841000000003E872841666666869414584166666666A28828419A9999F9801458419A9999991A892841000000607A145841CDCCCCCC7A8928413333331375145841666666661E8A28419A9999196C145841666666665C8A2841333333B36814584166666666F78A28419A99993960145841CDCCCCCC048B2841000000805F14584100000000748B28419A9999995914584100000000C18B284100000080551458419A999999428C28419A9999994E14584100000000E68C2841CDCCCCEC4514584166666666718E2841333333532B14584133333333BE8E284166666626261458419A999999198F2841000000002014584100000000288F2841333333F31E145841666666668D8F28419A9999F917145841666666664D902841000000201314584166666666A5902841666666E610145841CDCCCCCC00912841333333930E1458413333333312912841666666260E145841000000006D912841000000200A14584166666666CC912841000000E0051458419A999999469228413333337300145841000000001693284166666626FC135841333333330795284100000000E2135841CDCCCCCC2E9728419A9999D9CB135841666666663B9728419A999959CB135841CDCCCCCC81982841333333F3BE135841CDCCCCCCD4992841CDCCCC0CB2135841CDCCCCCC279B284166666626A513584166666666A19B284166666686A0135841000000003E9C2841000000C0A213584100000000B99C284166666686A4135841CDCCCCCCC99C2841000000C0A413584166666666A59D2841666666E6A713584100000000819E284166666606AB135841333333335C9F2841CDCCCC2CAE135841CDCCCCCC8D9F2841000000E0B3135841CDCCCCCCC29F284133333313B813584100000000F09F2841666666C6B91358416666666629A028419A999979B91358416666666642A0284133333373BA1358416666666664A028419A999959BD13584133333333C2A0284100000020C913584166666666D8A02841CDCCCCCCCA135841000000000DA12841666666C6CC1358413333333333A1284133333353CD1358419A999999FBA128419A999919CA1358416666666612A2284133333373CA135841000000001CA228419A9999F9CA135841000000002FA2284166666686CC1358419A99999939A22841666666C6CD1358416666666641A228419A999919CF1358416666666647A22841CDCCCC8CD01358416666666654A22841333333D3D51358413333333360A2284100000000D91358413333333377A22841000000C0DC135841CDCCCCCC91A2284166666606E0135841CDCCCCCCA9A2284166666686E413584166666666C1A2284166666646E613584100000000E4A2284100000060E813584133333333F1A22841CDCCCC0CEA13584166666666F9A2284133333313EC1358410000000001A32841333333D3EE135841CDCCCCCC1BA328419A999959EC1358413333333363A3284166666666E813584166666666BEA32841333333F3E41358413333333314A42841666666A6E213584166666666C8A42841CDCCCC8CDE135841000000001BA528419A999959DE135841333333335BA5284166666666DD1358416666666693A52841CDCCCC4CD81358410000000093A5284133333373DA135841CDCCCCCC98A5284100000060E11358419A9999999AA5284100000040E2135841666666669EA52841333333D3E313584166666666B4A52841666666A6E913584133333333CBA52841000000A0F113584166666666CDA5284166666646F213584166666666EBA5284100000060F613584133333333F1A52841333333F3F613584166666666FEA5284133333353F91358416666666606A6284133333333FB135841666666660BA62841666666C6FD1358413333333308A62841000000C0021458413333333309A628416666664606145841333333330FA628419A9999190B1458416666666619A62841000000200D1458419A99999929A62841000000C00F145841000000003BA6284133333353131458410000000041A62841333333B314145841333333334CA628419A999979181458413333333356A62841666666E61A145841CDCCCCCC5DA628419A9999391C145841000000007AA62841000000801E1458410000000087A628419A9999391F145841CDCCCCCC96A628419A9999791F14584133333333A0A62841CDCCCC2C20145841CDCCCCCCA9A62841666666462114584166666666BDA62841CDCCCC4C25145841CDCCCCCCD3A62841000000E02914584133333333FCA628419A9999792F1458419A9999991BA7284133333393341458413333333327A7284166666606371458413333333340A72841000000603D145841333333334DA72841CDCCCC4C40145841CDCCCCCC5FA728410000004043145841666666666EA7284133333373461458416666666675A7284100000080481458410000000084A728419A9999D94E1458419A99999984A728419A999959511458413333333382A728413333333354145841CDCCCCCC89A728419A99997959145841333333338CA72841666666865A1458419A9999998CA72841333333935B145841333333338AA72841666666E65E1458410000000085A72841CDCCCC6C63145841CDCCCCCC84A7284133333313641458419A99999986A72841666666E6641458410000000086A72841666666A667145841333333331FA72841666666A69E1458413333333313A728419A999939A5145841CDCCCCCC96A62841CDCCCCCCB01458419A999999ADA628419A9999F9E81458419A999999F2A72841333333D3061558419A999999E5A82841333333331D1558410000000007A92841333333131B1558419A99999940A92841CDCCCCAC131558419A9999994DA9284166666646121558413333333359A9284166666626111558410000000066A92841CDCCCC6C10155841333333337CA928419A9999B90F15584166666666BEA92841CDCCCC8C0D155841CDCCCCCCE0A928419A9999390C1558410000000021AA2841CDCCCC2C0A1558413333333345AA2841333333B308155841333333336DAA28419A9999B9051558413333333386AA28419A9999390415584166666666A9AA2841333333130415584100000000B5AA2841000000E00315584166666666C1AA284100000060031558419A99999922AB2841333333130415584166666666A0AB2841333333330315584100000000F1AB2841CDCCCCAC001558419A9999993DAC284133333393FE1458419A99999993AC2841666666A6FD145841CDCCCCCC47AD284133333333FC14584133333333BCAD28419A999959FC1458419A9999991BAE28419A999999FD1458416666666673AE284100000020FF1458410000000099AE28419A999939001558419A999999ABAE284100000040FF1458419A999999BCAE284166666666FC14584100000000EDAE284100000020F3145841CDCCCCCC07AF2841CDCCCC6CF1145841CDCCCCCC19AF284100000000F0145841333333332CAF284100000020EE145841CDCCCCCC41AF2841666666C6EB145841666666666DAF28419A999919E51458419A99999987AF28419A999939E1145841CDCCCCCCB7AF28419A999939D614584166666666BDAF2841000000E0D614584100000000CAAF2841CDCCCCACD714584166666666D0AF2841333333D3D9145841CDCCCCCC2AB0284166666606F81458410000000068B02841CDCCCC8C0C1558419A999999AFB0284133333373091558410000000064B12841666666A601155841CDCCCCCC99B12841CDCCCC2C031558419A9999999EB128419A99999903155841CDCCCCCCB1B12841666666A6021558413333333313B228419A9999F9FE1458413333333324B228419A9999B9FE1458416666666641B22841000000A0FE145841666666664FB228419A999959FE145841CDCCCCCC6DB22841CDCCCC4CFD1458419A9999997AB2284133333353FC145841CDCCCCCCCAB228419A9999D9FB14584166666666F9B228419A999959FB1458419A99999924B3284100000020FA145841000000003DB3284166666606F91458419A99999993B328419A999999F214584166666666B9B3284166666666EF14584166666666DCB328419A9999B9ED1458416666666631B4284133333313EA1458416666666651B42841333333F3E8145841333333335FB4284133333393E81458410000000086B428419A999919E814584100000000A0B4284100000020E81458419A999999B3B42841CDCCCC4CE714584166666666CEB4284166666606E7145841CDCCCCCCF8B42841CDCCCC0CE61458410000000031B52841CDCCCCCCE31458413333333359B5284100000040E21458419A99999976B52841666666C6E01458416666666683B52841666666E6DF14584166666666C4B5284100000040DF14584133333333FEB5284166666646DE145841000000003EB628419A9999D9DC1458410000000075B62841CDCCCCACDA1458419A999999DDB62841CDCCCC4CD9145841CDCCCCCC08B72841666666C6D9145841CDCCCCCC8FB72841000000A0D714584166666666D8B72841666666C6D51458413333333314B82841000000E0D3145841000000004AB8284166666686D1145841666666669BB8284133333353CF14584166666666ACB82841666666C6CE14584133333333ECB82841CDCCCC6CCD1458416666666609B9284100000080CC1458419A99999950B92841CDCCCCACC6145841CDCCCCCC6AB9284166666686C51458419A9999998EB92841333333D3C414584133333333BAB9284166666606C61458413333333308BA284100000060C61458419A99999929BA284100000080C61458410000000045BA2841666666E6C514584100000000B7BA284100000020C4145841CDCCCCCCFDBA2841000000E0C2145841666666663BBB2841666666C6C314584166666666A5BB2841000000A0C414584166666666CEBB28419A999919C41458413333333388BC2841CDCCCC8CC31458413333333320BD284133333373C41458413333333341BD2841000000E0C31458410000000085BD284133333373C114584133333333BABD2841CDCCCCECC014584166666666D1BD28419A9999D9BF14584166666666E3BD284100000040BE14584166666666E4BD284133333333BE1458419A999999F4BD284100000020BD1458410000000005BE2841666666A6BB145841CDCCCCCC14BE28419A999999B9145841CDCCCCCC21BE2841CDCCCCACB71458419A9999992FBE284166666606B51458410000000058BE2841CDCCCC2CAC1458410000000060BE284100000060AA1458410000000066BE2841666666C6A91458416666666675BE284100000040A8145841666666668DBE2841333333B3A614584166666666AEBE284166666626A514584166666666DCBE28419A9999D9A314584100000000F2BE284100000020A3145841CDCCCCCC09BF2841CDCCCC8CA21458419A9999991FBF28419A999959A2145841CDCCCCCC43BF2841CDCCCCACA21458419A9999997ABF284166666686A2145841000000009DBF2841CDCCCC4CA214584133333333C7BF2841CDCCCC6CA114584166666666F9BF2841333333F3A0145841666666660BC0284100000000A11458410000000023C0284133333393A1145841333333333BC02841CDCCCC0CA31458410000000045C02841333333D3A3145841CDCCCCCC58C02841CDCCCC4CA41458410000000082C028419A999979A41458413333333341C1284100000040A414584133333333B7C12841666666A6A114584100000000DBC12841CDCCCC6CA0145841000000004EC22841666666669C14584166666666BEC2284133333313981458416666666643C328419A99995992145841000000008BC328419A9999998E14584166666666EBC32841333333538C1458413333333310C42841333333D38B145841CDCCCCCC25C42841CDCCCCCC8B1458419A99999942C428419A9999198C1458410000000074C42841666666468F1458419A999999AEC428419A99995992145841CDCCCCCCE2C42841000000409414584100000000FCC42841333333D3941458410000000021C52841CDCCCCAC95145841CDCCCCCC7CC528419A9999599414584100000000A6C52841CDCCCC2C961458419A999999CEC528410000006097145841CDCCCCCCF9C52841CDCCCCEC98145841000000001FC62841CDCCCC4C99145841CDCCCCCC7AC72841333333D394145841CDCCCCCC94C828419A9999398E145841CDCCCCCCAEC828419A9999398E145841CDCCCCCCB3C828419A9999398E14584133333333C1C82841666666068F145841CDCCCCCCCDC828419A9999199014584100000000F1C828416666662693145841CDCCCCCCF2C82841CDCCCC4C9314584100000000CDC72841CDCCCCACB91458419A999999A9C7284166666646BB145841CDCCCCCC8CC728419A999939BD145841CDCCCCCC50C728419A9999B9C11458413333333342C7284100000020C31458416666666626C728419A999999C5145841333333330FC7284166666606C61458419A999999E2C6284100000040D4145841CDCCCCCC91C62841666666C6EC1458413333333324C62841CDCCCCAC0D1558413333333303C628413333331317155841CDCCCCCCF3C52841CDCCCC6C1B1558419A999999ECC5284166666606241558419A999999D4C52841000000602A15584166666666ACC528419A9999D935155841666666668CC528419A9999D93C155841666666666DC528419A9999F9451558416666666611C52841000000205C1558416666666602C528419A9999596115584100000000CBC42841666666E6661558416666666603C428419A9999D97A1558419A999999FCC228410000000095155841000000007EC12841333333D3B4155841333333334CC12841CDCCCC0CB9155841000000004AC02841000000E0CE1558410000000048BF2841000000C0E41558419A99999945BE284133333393FA1558419A999999D6BD2841CDCCCC6C01165841000000007CBD284133333373071658416666666648BD2841000000E00A1658419A9999995CBC28419A999999191658419A9999995DBC28419A9999B91F165841666666665EBC2841666666C624165841CDCCCCCC5FBC28419A9999192B165841CDCCCCCC60BC28416666666632165841CDCCCCCC2BBE2841666666662E1658419A999999A5BE2841000000202D1658419A99999928BF2841666666A62A16584100000000A6BF28419A999939291658419A9999992EC0284100000040281658410000000054C0284166666666281658419A9999997DC12841666666462E16584166666666F1C12841333333B32E1658416666666672C22841666666262E165841CDCCCCCCACC22841333333532D165841000000000AC32841666666062C1658410000000048C32841666666463F1658419A99999987C32841CDCCCC0C531658416666666624C42841666666466E165841000000002EC42841000000606F1658413333333377C42841000000007816584166666666EEC42841CDCCCCEC881658410000000032C52841CDCCCC6C97165841CDCCCCCC70C52841CDCCCCACB01658410000000082C5284133333353B9165841CDCCCCCC87C52841000000E0BE16584166666666E3C528419A999919BF1658419A99999937C6284133333313BE1658419A9999994DC72841CDCCCCACBA1658419A9999994DC72841333333D3B8165841000000004DC7284166666626B71658419A9999994CC728419A9999F9B5165841666666664BC72841CDCCCCCCB4165841CDCCCCCC4AC728419A999959B3165841333333334AC7284166666626B2165841CDCCCCCC49C728419A9999F9B0165841CDCCCCCC48C728419A999999AF1658410000000049C72841333333D3AD1658410000000049C728419A9999B9AC165841666666664AC72841000000A0AB165841666666664CC7284166666686AA165841000000004DC7284100000060A91658419A9999994BC72841666666C6A7165841CDCCCCCC49C72841666666A6A51658413333333348C7284133333313A4165841CDCCCCCC46C72841666666A6A2165841CDCCCCCC46C7284166666686A1165841CDCCCCCC48C728419A999939A01658419A99999949C72841333333139F1658413333333349C72841000000209E165841333333334AC72841333333F39C165841000000004DC72841666666A69B165841CDCCCCCC50C728419A9999399A165841CDCCCCCC56C728410000002099165841000000005CC728416666660698165841CDCCCCCC5FC72841CDCCCCCC96165841CDCCCCCC61C728419A9999F9951658419A99999962C72841CDCCCC4C951658419A99999964C7284133333373941658416666666667C728410000006093165841CDCCCCCC69C728410000004092165841000000006BC728410000008091165841666666666CC72841CDCCCCEC90165841CDCCCCCC6FC7284100000040901658416666666674C72841000000A08F1658416666666679C72841666666268F1658419A99999990C7284133333393831658419A999999D8C72841333333737E16584166666666F9C72841000000607E1658419A99999906C92841666666E67D1658419A99999903C92841CDCCCC0C7C165841CDCCCCCCFEC828419A9999997A16584166666666F7C828419A9999197916584133333333F3C82841000000207816584100000000F2C82841666666E6761658419A999999F3C82841666666E6751658419A999999F6C828419A9999397516584166666666FAC82841CDCCCC4C741658416666666606C928416666662672165841666666660CC9284166666606711658413333333311C9284166666626701658410000000016C928419A9999F96E165841666666661EC92841000000206E165841CDCCCCCC27C928419A9999796D1658410000000033C928419A9999396D1658413333333355C92841CDCCCC0C6D1658410000000060C92841333333D36C165841666666666AC92841CDCCCC2C6D1658416666666675C928419A9999F96C1658419A9999998CC92841333333136C165841000000009AC92841000000A06B16584133333333A2C92841333333D36A165841CDCCCCCCA8C92841000000E0691658419A999999B1C92841333333336916584133333333BAC928419A99993968165841CDCCCCCCBFC92841CDCCCCEC661658419A999999C3C92841666666C66516584166666666C6C92841666666066316584100000000CAC928419A9999B961165841CDCCCCCCCFC92841000000806016584166666666D2C928419A9999595F16584133333333CEC92841000000E05C16584166666666CEC92841333333B35B16584133333333D0C92841CDCCCC8C5A165841CDCCCCCCD6C92841000000405816584100000000E4C928419A9999595616584100000000F0C92841CDCCCC4C5516584166666666F7C928410000002054165841000000000DCA28410000008051165841333333331FCA284100000040501658419A9999992FCA28419A9999994E1658419A9999993ACA2841666666664C165841000000003CCA2841CDCCCC4C4B1658419A99999938CA2841000000A0481658419A99999942CA2841CDCCCC4C43165841CDCCCCCC49CA284100000020401658419A99999950CA28419A9999F93D1658413333333357CA28419A9999F93C165841333333335CCA28419A9999D93B165841CDCCCCCC5ECA2841000000E03A165841000000006CCA284166666686381658416666666674CA28416666662635165841666666667BCA28410000006033165841333333338ACA2841666666A6301658410000000099CA2841CDCCCCAC2C16584133333333A1CA2841000000202B1658419A999999B3CA2841333333F3281658419A999999BECA2841CDCCCC0C281658419A999999C7CA2841666666A62616584133333333E7CA2841333333D32016584166666666EFCA2841666666061F165841666666660CCB2841333333731A1658416666666612CB2841666666A6181658416666666617CB284100000040161658413333333322CB2841CDCCCCEC12165841CDCCCCCC2ACB2841CDCCCCCC0E1658413333333331CB2841000000E00C165841CDCCCCCC37CB2841CDCCCC6C091658419A9999999DCB2841333333F3061658410000000013CC2841333333730016584100000000ACCC284166666606F515584100000000ADCC2841333333F3F4155841CDCCCCCC40CD284100000000ED1558419A999999EBCE2841666666E6DE15584166666666B4CF2841333333B3E215584133333333E8CF2841CDCCCCACE115584133333333A3CF2841333333B3C91558419A9999998BCF284133333393C2155841CDCCCCCC70CF2841CDCCCC2CBB155841000000006ACF28419A9999B9B81558413333333361CF2841CDCCCC0CB7155841666666665CCF2841666666A6B51558416666666652CF284100000020B41558410000000048CF2841CDCCCC4CB21558419A99999943CF2841CDCCCC8CB0155841000000003ECF284100000020AF1558410000000030CF284166666666AB1558413333333318CF2841CDCCCC4CA3155841333333330DCF2841000000C0A015584166666666F2CE28419A9999B99815584166666666E2CE28419A99997995155841CDCCCCCCBACE28416666660690155841000000005FCE284166666626871558419A99999948CE284100000000741558419A99999923CE2841000000C054155841666666660ACE2841666666663F15584133333333F8CD2841333333D32F1558419A999999F2CD2841CDCCCC2C2B155841CDCCCCCCEDCD2841CDCCCC2C271558416666666602CE2841333333D32615584166666666A2CE28419A9999F92315584166666666B4CE2841666666A623155841CDCCCCCC7BCF28419A9999192015584133333333A7D02841CDCCCCCC1A15584133333333B3D0284100000000191558419A999999BFD028413333339317155841CDCCCCCCD0D028413333335316155841CDCCCCCCE3D0284133333353151558419A9999991FD12841333333B3131558413333333359D12841000000C011155841333333335ED1284166666666111558413333333391D12841CDCCCCAC10155841666666667FD12841666666460D155841666666667BD128419A9999790C1558413333333369D12841333333930D1558419A99999947D128419A9999F9FD1458416666666645D1284100000000FD1458419A999999CAD02841CDCCCC4CFF1458419A9999997BD02841666666C60015584100000000F0CF2841000000600315584133333333E6CF2841CDCCCCECFF14584166666666CACF284133333313F61458419A999999ADCF2841333333F3EB14584133333333A3CF2841CDCCCCECE7145841CDCCCCCC97CF2841333333B3E11458419A9999997ACF284166666686D11458419A9999994FCF284166666606BA145841CDCCCCCC3FCF284100000060B1145841CDCCCCCC3FCF2841000000A0AE145841CDCCCCCC3FCF284133333313AD145841333333333FCF28410000004099145841333333333ECF2841CDCCCCEC831458413333333373CF2841000000E0741458413333333389CF28419A9999996E14584100000000AFCF28419A9999995014584100000000D5CF2841CDCCCC8C3214584100000000FBCF284166666686141458419A99999910D02841CDCCCC8C031458416666666630D0284100000040EA1358416666666635D028419A999939E6135841333333333AD028419A999939DF1358416666666641D0284133333373D41358419A99999941D0284133333313D413584100000000A1D02841CDCCCC4CD41358419A99999997D12841000000E0D4135841CDCCCCCCF9D2284166666646D813584133333333D4D328419A999919D81358419A999999DED42841333333B3D81358416666666674D528419A999919DC13584166666666F4D52841000000E0D81358419A9999991ED62841CDCCCC0CD913584100000000DAD6284166666686D81358413333333359D728419A999939D9135841CDCCCCCCAFD728419A999939D61358416666666652D82841000000A0D013584133333333BBD82841CDCCCCACD41358413333333318D92841333333B3D6135841CDCCCCCC31D9284100000040D71358410000000056D928419A9999B9DB13584133333333CADA284166666626E3135841CDCCCCCCB4DB28419A9999B9EB13584100000000B6DB2841CDCCCC0CE913584166666666BDDB284133333373DA13584100000000C5DB2841CDCCCC8CCB13584166666666C7DB284166666686B813584133333333CBDB28419A9999D9981358419A999999CADB2841666666A68E135841CDCCCCCCC9DB28419A9999597F13584166666666C9DB2841666666C6781358410000000098DB2841CDCCCC0C611358419A9999998EDB2841CDCCCC6C5C135841CDCCCCCCF0DA2841666666A61013584166666666B8DA28419A999979F5125841666666666EDA2841666666E6D11258419A9999990ADA2841333333F3A112584166666666C6D9284100000040811258416666666682D928416666668660125841666666663ED92841333333D33F125841000000003CD92841000000203C1258413333333339D928413333335337125841CDCCCCCC01D928419A999919201258419A999999DFD828419A9999D91112584166666666BDD8284133333373031258419A999999A3D82841000000C0F8115841CDCCCCCC8AD8284133333353EE1158416666666683D828419A999939EB1158410000000069D8284100000040E01158419A99999945D8284133333373D11158413333333312D828419A9999F9BB115841CDCCCCCC0CD82841000000C0B91158419A999999C9D72841666666A69D1158416666666686D72841CDCCCC8C81115841CDCCCCCC76D72841333333F36C115841CDCCCCCC7BD72841333333D36A1158416666666676D72841CDCCCCCC671158410000000078D72841666666E6621158413333333375D72841CDCCCC2C5D1158419A9999996FD72841000000E0521158419A9999996CD72841000000204D115841CDCCCCCC56D72841333333F3221158419A99999986D72841CDCCCC6C1C11584100000000F8D72841666666060D1158416666666614D8284166666626091158413333333337D82841CDCCCC6C04115841CDCCCCCC8DD82841CDCCCC2CE310584100000000A3D8284166666626DD10584133333333E2D8284100000020CB1058419A999999E5D82841CDCCCC0CBF1058419A999999E4D82841000000A0BD10584166666666E7D8284166666626B810584100000000DCD828419A999999B310584166666666C6D82841000000E0B210584133333333B8D828419A9999F9B110584133333333A9D82841CDCCCC4CB0105841333333339CD8284133333373AE1058413333333383D82841000000C0A91058416666666664D828419A999959A31058419A99999950D8284166666626A01058413333333340D82841000000E09D1058419A9999993AD82841333333D39C105841CDCCCCCC2FD82841666666C699105841333333330DD828419A9999D993105841CDCCCCCCE6D72841666666A68E105841CDCCCCCCC6D7284133333373881058419A999999BBD72841333333B385105841CDCCCCCC97D72841CDCCCC0C80105841000000007AD728419A9999D97B105841CDCCCCCC60D728419A9999D9761058413333333349D72841CDCCCC8C721058410000000042D72841000000C070105841666666663BD72841CDCCCC4C68105841CDCCCCCC38D7284133333373571058419A99999936D72841CDCCCCCC4C1058413333333334D72841CDCCCCCC411058413333333332D72841CDCCCCCC371058419A9999992ED7284100000000261058419A9999992AD728410000002013105841CDCCCCCC26D72841666666C6001058410000000025D72841000000A0F80F58413333333343D728419A9999B9F00F5841CDCCCCCC74D72841CDCCCCACE30F584100000000B1D72841333333D3D30F584166666666DAD72841333333F3C80F5841CDCCCCCCEBD7284166666666C40F584166666666F5D728419A9999D9C10F584166666666FAD7284166666686C00F5841666666662CD8284133333313B30F58419A99999940D8284100000040AD0F58416666666650D828419A9999B9A80F58416666666651D8284100000060A80F58419A99999970D82841CDCCCC6C9F0F58416666666677D82841666666869D0F58419A999999A4D8284166666666900F5841CDCCCCCCBED82841666666C6880F58419A999999CFD82841666666C6830F5841CDCCCCCCDAD8284166666686800F58419A999999E5D828419A9999597C0F58419A999999F6D82841666666C6750F5841CDCCCCCC07D92841000000C06C0F584100000000FAD82841333333D34E0F5841CDCCCCCC15D9284100000060420F58419A9999993DD928419A9999F93E0F5841CDCCCCCCF4D9284100000020300F58410000000019DA28419A9999392D0F5841333333334FDA2841666666462C0F58413333333371DA28419A9999B92B0F584166666666BBDA2841CDCCCC4C2A0F584133333333E7DA2841333333F3290F584100000000FFDA284100000060290F58419A99999939DB28419A999979280F58416666666687DB2841CDCCCCEC260F58419A999999C4DB284166666666250F584100000000EDDB28419A999919240F584166666666FEDB284133333393230F584166666666B6DC28419A9999591C0F584133333333E9DC28419A9999991A0F5841CDCCCCCC2DDD2841000000E0180F5841CDCCCCCC89DD284133333353170F5841CDCCCCCC07DE2841000000E0150F58419A99999984DE28419A9999B9140F58416666666621DF284166666666130F5841333333334ADF28419A9999F9120F58416666666690DF2841CDCCCCCC120F584166666666D7DF284166666666120F584166666666E6DF2841666666A60E0F584100000000F2DF284166666646080F5841CDCCCCCCF6DF2841000000A0030F58413333333305E028419A999939FC0E5841CDCCCCCC04E02841CDCCCCECFA0E58419A99999901E0284100000040F90E58413333333303E0284166666626F60E584166666666FCDF2841CDCCCC4CF00E584133333333FBDF2841CDCCCC6CEE0E584133333333FBDF28419A9999B9EC0E584166666666FFDF284133333393E80E58413333333305E02841CDCCCCCCE50E5841000000000CE02841CDCCCC6CE10E58419A99999913E02841CDCCCC0CDF0E58419A99999927E0284133333333D60E5841CDCCCCCC3CE0284166666686D20E58416666666646E02841333333D3CF0E58419A99999948E0284133333393CE0E5841CDCCCCCC43E028419A9999B9C90E58416666666632E02841CDCCCCACC10E58416666666636E02841000000E0C00E58416666666638E02841CDCCCCCCBF0E5841000000003EE02841666666C6BB0E5841CDCCCCCC41E028419A9999B9BA0E5841CDCCCCCC44E0284100000060B80E58410000000046E02841000000C0B60E58419A99999943E02841666666E6B20E58416666666646E0284100000020B10E58419A9999994BE02841CDCCCCACAF0E58419A9999995CE02841666666E6AD0E5841CDCCCCCC64E02841CDCCCCCCAC0E58410000000066E0284166666646AB0E58419A99999962E02841000000C0A90E58410000000062E0284133333333A80E58419A9999995FE0284133333373A60E58416666666661E0284100000040A30E58419A9999995BE02841000000809E0E5841333333334EE0284100000080980E58413333333347E02841CDCCCCAC960E58416666666645E028419A9999B9940E58413333333345E02841CDCCCCEC920E58419A9999994AE02841333333538F0E5841333333334BE02841CDCCCC4C8D0E58419A99999941E02841666666A6840E58416666666637E02841333333137E0E58419A99999938E0284133333313780E58410000000031E02841333333D3710E58410000000028E02841CDCCCCEC6D0E58416666666626E028419A9999D96B0E58413333333327E02841CDCCCC2C6A0E5841000000002FE02841000000A0620E58419A99999936E02841333333B35E0E58413333333338E02841333333B35C0E58419A99999938E0284133333353580E58419A99999937E02841CDCCCCAC560E58416666666632E0284166666686530E58416666666631E028419A999979510E58416666666634E02841333333B34F0E58419A99999947E02841000000004B0E58419A9999994FE02841CDCCCC6C490E58419A99999962E02841000000C0460E58413333333373E028419A9999F9430E58419A99999980E02841666666A6400E58413333333384E02841000000003F0E5841CDCCCCCC8AE02841666666463D0E5841CDCCCCCC94E028419A9999D9390E5841CDCCCCCC94E0284166666606380E58410000000092E02841333333F3350E58416666666696E028419A999999300E58410000000099E02841000000002C0E58419A9999999BE028419A9999392A0E584166666666A6E02841CDCCCC2C270E58419A999999A8E0284133333373250E5841CDCCCCCCADE028419A999979230E584100000000B1E028419A999959210E58419A999999B7E02841333333731F0E584133333333C6E02841CDCCCC2C1C0E5841CDCCCCCCD0E028419A9999191B0E58419A999999D7E02841CDCCCC0C1A0E584166666666E7E02841666666C6160E58419A999999EAE02841333333F3140E58419A999999F0E02841333333F3120E584166666666F8E0284166666606110E58419A999999FEE02841CDCCCC0C0F0E58410000000006E12841000000C00D0E5841CDCCCCCC0DE12841000000000A0E5841CDCCCCCC0DE128419A9999F9070E58419A99999912E12841000000A0060E5841CDCCCCCC21E12841666666A6030E5841CDCCCCCC31E12841333333B3000E5841CDCCCCCC37E128419A9999D9FE0D5841CDCCCCCC3EE12841666666E6FA0D5841CDCCCCCC44E1284166666666F90D58419A99999953E1284100000060F60D58416666666657E12841CDCCCCECF40D58419A9999995BE1284133333313F20D58419A9999995FE12841666666C6F00D58410000000068E12841333333B3EF0D5841CDCCCCCC7CE12841CDCCCC2CEA0D584133333333B0E1284133333333EC0D5841CDCCCCCCEAE1284133333313F00D584100000000DCE1284166666626EA0D5841CDCCCCCCE2E12841333333D3E90D584166666666F0E1284133333393E80D584133333333F5E128419A999979E70D58419A999999F6E1284133333393E60D5841CDCCCCCCF4E1284166666626E50D584133333333EFE12841666666C6E30D584166666666EDE12841666666C6E10D584133333333EFE12841CDCCCCECDF0D584133333333F7E12841CDCCCCACDB0D584166666666F7E128419A9999B9D90D5841CDCCCCCCF2E12841CDCCCC0CD60D58419A999999EBE1284133333333D20D584166666666EAE128419A999999D00D584166666666FBE12841CDCCCC8CC90D58410000000001E22841CDCCCC0CC80D58416666666601E2284166666626C60D584100000000FFE1284133333353C40D584166666666FEE128419A9999D9C10D58416666666605E22841CDCCCCCCBE0D58416666666613E22841000000E0BA0D58416666666663E2284166666666BD0D58410000000090E2284100000060BF0D584166666666A5E22841CDCCCC0CC10D584100000000B0E22841CDCCCCACC10D584100000000C1E2284133333373C20D584166666666D3E2284133333313C30D584100000000F0E22841CDCCCC6CC40D58413333333337E3284100000020C80D5841666666663FE32841000000A0C30D58413333333349E32841333333B3B90D5841333333334CE32841333333F3B70D58419A99999953E32841CDCCCC0CB60D58416666666646E32841666666E6A10D58419A99999940E32841CDCCCCAC950D5841333333336AE3284100000060930D584166666666F8E32841000000808B0D5841666666666FE42841000000C0960D5841333333339BE4284133333333970D584100000000DBE4284166666626980D584133333333EBE42841CDCCCC8C980D5841CDCCCCCCF4E428419A999939930D58419A999999FEE428419A9999D98E0D5841000000003FE5284133333373740D5841000000003FE52841CDCCCC2C730D58416666666639E5284133333313720D5841333333334DE52841000000E0710D58416666666656E528419A9999996E0D58419A9999995DE52841666666666B0D58419A9999996EE5284100000060650D58416666666678E52841000000C0600D58413333333387E52841333333F35A0D58413333333388E52841000000E0590D58410000000089E52841666666E6560D5841333333338FE5284133333353510D58413333333398E5284133333353460D584100000000A8E52841000000C03A0D5841CDCCCCCCADE5284100000000370D5841CDCCCCCCB0E52841333333532F0D584166666666AFE5284100000060280D584133333333B1E52841000000601E0D58419A999999A9E5284133333333170D584133333333CAE6284166666666150D58419A999999DBE62841666666E6170D584133333333F1E62841333333931A0D58416666666623E72841CDCCCC6C200D58416666666640E72841CDCCCC8C230D58419A99999961E72841000000C0260D5841000000009AE72841CDCCCCAC2B0D58419A999999CDE72841000000A02F0D58410000000007E828419A999959330D58419A99999954E8284166666626370D58413333333394E82841CDCCCCEC300D58416666666620E92841666666E6200D58419A9999994FE92841000000A01B0D58413333333358E92841333333B31A0D58410000000082E92841CDCCCC4C150D5841CDCCCCCC43EA28419A9999F9040D584100000000ABEB284133333373DD0C584100000000EFEB2841CDCCCCACD50C58413333333398EA28419A9999F9DA0C58419A999999D0E92841000000E0DD0C58410000000031E9284166666626E00C58419A999999DCE8284166666686E10C584133333333E4E72841CDCCCCACE60C584100000000DDE62841000000A0EB0C5841000000000BE6284100000000EF0C5841CDCCCCCC59E42841000000A0F40C584133333333FAE32841CDCCCCECF50C58419A999999BCE32841CDCCCC0CF70C58413333333358E2284100000060FC0C58416666666674E12841333333D3FF0C58416666666644E1284133333393000D5841333333331FE12841CDCCCC6C010D58416666666610E1284100000080010D5841000000009AE0284166666646030D5841333333334CE02841666666C6040D584100000000E0DF284133333313060D58419A99999942DF2841CDCCCC2C080D584166666666DBDE2841333333B3090D58410000000053DE2841666666060C0D58419A999999F8DD2841666666060D0D5841666666669DDD2841CDCCCC4C0E0D5841CDCCCCCC70DD2841666666A60E0D584133333333FFDC284100000000100D5841CDCCCCCCA7DC2841000000C0100D5841CDCCCCCC04DC2841333333B3110D5841333333333EDB284166666606130D58413333333310DB28419A9999B9130D584133333333F4DA28419A999919140D584100000000F1DA284166666626140D5841CDCCCCCCD5DA2841CDCCCCAC140D5841CDCCCCCCD2DA28419A9999B9140D584100000000C0DA284133333313150D58410000000027DA284133333313180D5841CDCCCCCCFED82841CDCCCCCC1C0D58419A99999954D82841CDCCCCAC1F0D58416666666612D82841CDCCCCAC200D584166666666E2D7284166666666210D58419A99999989D7284133333313230D5841CDCCCCCC15D72841333333D3240D5841CDCCCCCC8FD62841000000E0260D584133333333A3D52841333333D32A0D5841CDCCCCCC35D52841666666E62C0D5841000000007AD428419A9999D9300D5841CDCCCCCC2AD428419A999959320D584133333333D4D3284166666646340D5841CDCCCCCCD3D32841000000A0320D58419A999999D3D3284133333373310D584133333333D8D32841666666862D0D584100000000F3D328419A9999B9270D58419A9999991DD42841CDCCCCCC160D5841CDCCCCCC32D428419A9999590A0D58413333333343D42841333333F3040D5841CDCCCCCC4CD4284133333393020D58410000000058D4284133333313000D58410000000082D4284100000040F80C584166666666AAD42841666666E6F10C58419A99999900D52841000000C0E20C58419A9999995CD5284166666686D20C5841CDCCCCCCFED528419A999979B70C58410000000044D6284166666626AC0C5841333333337CD62841333333F3A20C58410000000092D628419A999919A00C584100000000A5D62841CDCCCCCC9C0C5841CDCCCCCCC5D62841000000E0960C584166666666E7D62841000000A08F0C584100000000E4D62841CDCCCC6C8A0C584100000000E0D62841333333F3870C584166666666C8D628419A999919800C584166666666C1D628419A9999F97C0C58419A999999BBD62841CDCCCCEC790C58419A999999B7D62841666666C6760C584100000000B3D62841000000E0710C58419A9999999BD62841CDCCCC6C5C0C58419A99999983D6284133333313490C5841666666667CD62841333333D3450C5841333333336ED628419A999939410C58416666666643D6284100000020360C58419A9999993FD6284100000080340C5841333333331FD628419A9999B92C0C58410000000005D6284166666646250C584166666666E9D52841000000601C0C584166666666E3D52841333333B3190C5841CDCCCCCCD8D528419A999959160C58419A999999C9D52841CDCCCC2C130C584166666666BFD52841CDCCCCAC110C58419A999999B0D52841CDCCCCEC0E0C584100000000ACD52841333333730D0C584166666666B1D52841CDCCCC0C0D0C58419A999999B7D528419A9999990C0C584133333333BAD528419A9999590C0C584133333333BDD52841CDCCCC0C0C0C584166666666C1D528419A9999190B0C58419A999999C5D52841666666060A0C58419A999999C8D528419A999939090C584166666666CBD5284133333393080C584166666666D1D5284133333373070C584133333333D7D5284166666606060C584133333333E1D528419A999959030C584133333333C8D5284133333353020C5841CDCCCCCCB7D5284100000040010C58413333333385D528419A999999FE0B58419A9999995ED5284133333353FD0B58419A9999991BD52841333333D3FA0B5841CDCCCCCCAFD42841666666E6F50B5841000000006DD42841333333D3F30B58413333333365D4284166666666F30B58419A99999940D42841CDCCCC8CF10B5841CDCCCCCC21D42841CDCCCCCCEF0B58419A9999990ED42841CDCCCC2CEE0B58419A99999909D4284166666686ED0B58410000000005D42841CDCCCC4CEC0B5841CDCCCCCCFFD328419A999979EB0B58419A999999F8D328419A999959EB0B584100000000D2D3284166666646EB0B584100000000A3D328419A999999EB0B5841CDCCCCCC90D32841CDCCCC8CEB0B58413333333373D32841CDCCCCCCEB0B5841CDCCCCCC63D328419A9999B9EB0B58419A99999950D3284133333353EB0B58419A99999934D3284166666606EA0B58419A9999991CD32841333333D3E70B58419A999999E8D2284100000020E50B5841CDCCCCCCD7D2284133333373E40B5841CDCCCCCCC5D2284100000000E40B584100000000B6D22841CDCCCC4CE30B58413333333397D2284166666666E20B58416666666687D2284166666626E20B5841CDCCCCCC7AD22841666666A6E10B58413333333355D2284133333393DE0B5841CDCCCCCC48D2284166666666DC0B5841000000003CD2284100000080D90B58416666666638D22841CDCCCC4CD80B5841CDCCCCCC2ED228419A999999D30B58419A99999926D22841333333D3D00B58419A999999E9D1284133333353C80B584100000000E2D12841000000E0C60B584100000000DCD12841666666C6C40B5841CDCCCCCCD5D1284100000060C00B584166666666D6D12841CDCCCC8CBC0B58419A999999DDD1284133333373B50B58413333333302D2284133333313A30B58419A99999904D2284133333333A10B58410000000001D22841333333F39F0B584166666666A9D1284100000020900B5841CDCCCCCCA0D128419A9999398E0B5841CDCCCCCC86D1284100000060880B58419A9999993CD12841CDCCCCAC790B58416666666622D12841666666A6740B5841CDCCCCCC17D1284133333353730B5841CDCCCCCC02D1284166666626710B5841CDCCCCCCCBD02841000000806C0B5841666666666CD02841333333B3650B5841333333333CD028419A999919630B58413333333330D0284133333333620B58413333333319D0284133333353610B58419A99999905D0284100000080600B5841CDCCCCCCFACF284166666626600B584133333333E3CF28419A999919600B584133333333B8CF284166666626610B58419A999999AACF2841CDCCCC4C610B58419A99999997CF2841CDCCCC2C610B58419A9999998FCF2841CDCCCCAC600B5841000000004FCF28419A9999395A0B584100000000ACCE2841CDCCCCCC4B0B58413333333387CE2841CDCCCC4C480B5841CDCCCCCCE2CD2841CDCCCCEC380B5841CDCCCCCC70CD2841666666262D0B58416666666658CD2841000000202A0B58419A9999992BCD284100000040250B5841CDCCCCCC12CD284100000040220B58416666666608CD2841CDCCCC6C200B58419A999999FBCC2841666666061F0B584166666666F2CC2841333333731D0B584100000000C7CC2841CDCCCC0C190B58419A999999B6CC28419A9999F9170B58419A9999999DCC284100000000150B58413333333390CC28419A9999D9130B58419A99999985CC284166666646120B5841000000007ACC28419A9999F9100B58410000000058CC2841666666860C0B58416666666644CC2841000000C0090B5841CDCCCCCC38CC284100000080080B58419A99999927CC28419A9999D9050B5841CDCCCCCC19CC284133333353030B58419A9999990FCC2841000000C0000B58416666666609CC28419A9999F9FD0A5841CDCCCCCC05CC284100000000F90A58410000000007CC284100000060F50A58410000000005CC28419A999979F10A58413333333307CC284166666646ED0A58410000000006CC28419A9999B9EB0A58419A99999901CC2841CDCCCC8CEA0A584133333333F9CB284100000060E90A5841CDCCCCCCECCB28419A999979E80A58419A999999BECB2841000000C0E50A584100000000ABCB28419A999959E40A58419A9999999BCB2841666666A6E30A5841CDCCCCCC92CB2841666666A6E20A58413333333380CB28419A999979DF0A58416666666674CB2841000000C0DD0A58416666666669CB2841333333B3DC0A58413333333326CB2841CDCCCC4CD50A5841CDCCCCCCFECA2841333333B3D00A584133333333D5CA284166666626CC0A5841000000006BCA2841CDCCCC2CBF0A58416666666653CA2841000000C0BC0A58410000000033CA28419A999979B80A5841CDCCCCCC27CA28419A999939B70A5841CDCCCCCC1BCA284133333353B60A5841666666660BCA2841CDCCCCACB40A584133333333F3C92841CDCCCC8CB10A584133333333B9C92841666666E6AA0A584133333333A5C92841CDCCCC8CA80A58410000000081C9284166666626A50A58419A9999995FC928419A9999D9A20A5841CDCCCCCC53C9284133333353A10A58410000000043C92841CDCCCCEC9F0A58419A9999991FC92841CDCCCCEC9C0A58419A999999FAC82841000000209A0A58419A99999980C82841333333D38F0A58410000000073C82841333333538E0A58416666666656C82841000000E08B0A5841000000003EC8284100000080890A5841333333332AC828419A9999D9870A5841666666661AC82841000000C0860A58419A9999990FC8284166666686850A584100000000DAC7284100000020810A5841CDCCCCCCABC728419A9999197D0A58419A9999999DC72841CDCCCC2C7C0A58410000000086C72841CDCCCC4C790A5841CDCCCCCC77C72841666666E6770A58419A9999996BC7284166666666760A5841CDCCCCCC32C7284133333373700A58416666666619C72841666666666D0A58413333333311C72841666666266C0A5841CDCCCCCC04C72841666666C66A0A584166666666F3C62841333333F3670A584100000000DCC62841000000A0640A584100000000D0C6284133333373630A5841CDCCCCCCC5C62841666666C6610A584166666666BAC6284166666666600A584133333333B0C628419A9999D95E0A5841CDCCCCCC96C628419A9999B95B0A5841333333337BC6284133333353570A58419A9999995CC6284133333393530A58416666666644C62841666666C64F0A58419A9999993DC62841CDCCCC2C4E0A58416666666634C628419A9999F94C0A584166666666FDC5284133333333420A584166666666EBC52841CDCCCC0C3F0A584100000000D0C52841000000C0380A5841CDCCCCCCC2C52841666666C6360A584166666666B8C52841CDCCCC6C340A584100000000B3C52841000000C0320A5841CDCCCCCCACC528419A999959310A5841CDCCCCCCA5C52841CDCCCC2C300A584100000000A1C528419A9999F92E0A5841000000008FC52841000000E0280A58419A99999985C5284133333393260A58410000000074C52841CDCCCC0C230A58413333333359C52841CDCCCCCC1B0A5841CDCCCCCC55C52841CDCCCC0C1A0A5841000000004EC5284100000080180A5841CDCCCCCC47C52841333333B3160A58419A9999993BC52841CDCCCC2C120A5841000000003AC52841000000800C0A58413333333337C52841333333130B0A5841CDCCCCCC35C528419A999939090A58416666666632C5284133333353070A5841666666662FC52841CDCCCC8C050A58419A9999992AC5284133333333040A58410000000024C52841000000C0FF095841CDCCCCCC0CC52841000000E0F80958416666666605C52841CDCCCC0CF70958419A999999FBC4284133333353F509584133333333F3C4284133333333F3095841CDCCCCCCE9C428419A999939F109584100000000D5C42841CDCCCC8CED0958419A999999B9C42841CDCCCCECE609584166666666A3C428419A999999E20958419A9999997AC4284100000000D9095841CDCCCCCC5DC4284100000060D30958410000000041C42841CDCCCCECCE095841333333332FC4284133333393CB09584133333333E3C3284166666646C009584166666666D0C32841CDCCCCECBD09584100000000CAC328419A9999D9BC09584133333333BBC3284100000020BB095841333333339DC32841000000E0B60958416666666691C32841666666C6B50958419A9999996CC3284133333353B10958416666666649C3284133333373AD0958419A99999923C32841333333D3A90958416666666613C3284100000020A8095841CDCCCCCC07C3284166666626A70958416666666600C3284133333333A60958419A999999E8C22841CDCCCC2CA409584133333333DEC22841CDCCCC0CA3095841CDCCCCCCD1C228419A999919A2095841CDCCCCCCC7C2284166666606A109584100000000B0C22841CDCCCC2C9F0958413333333396C22841333333739D095841666666668CC22841000000809C095841333333337FC22841666666669B0958416666666676C22841666666669A095841333333335EC22841CDCCCCAC98095841CDCCCCCC3FC2284166666606960958419A99999932C228413333333395095841666666660AC2284100000020920958410000000001C22841666666A691095841CDCCCCCCFBC1284166666606910958419A999999E8C12841000000E08F09584166666666D7C128419A9999598E09584100000000D1C12841CDCCCC8C8D09584133333333B9C12841333333D38B09584133333333A5C128419A9999D9890958410000000083C128419A999939870958416666666679C128410000000086095841CDCCCCCC72C12841CDCCCC6C850958419A9999995CC12841666666E6830958419A99999932C12841333333D380095841CDCCCCCC17C128419A9999D97E09584166666666E7C02841666666467B09584166666666BDC028419A9999B97809584100000000A7C02841666666C6770958419A99999989C02841000000C076095841666666661BC02841333333D37309584133333333F3BF2841CDCCCC0C7309584166666666CABF2841000000A07209584166666666ADBF28410000008072095841333333335EBF2841CDCCCC2C7209584133333333F1BE2841333333F37109584100000000E9BE2841CDCCCCAC7209584100000000D5BE28419A999979740958419A9999991ABE284100000060850958410000000018BE28419A999999850958416666666633BD2841666666869A095841CDCCCCCC23BD28419A9999399C0958410000000010BD2841333333539E095841000000009DBC2841333333739B09584100000000A0BC2841000000009909584133333333A5BC2841333333339709584100000000A8BC2841333333339609584100000000AABC28419A99997995095841CDCCCCCCABBC2841333333D39409584166666666AFBC2841000000609309584166666666B9BC2841000000C0900958419A99999917BD28419A9999797C0958416666666632BD28419A9999B9760958416666666643BD2841CDCCCC0C73095841000000006BBD2841000000606A0958410000000076BD2841CDCCCC8C670958410000000082BD2841000000E0640958419A99999966BD2841000000206309584133333333ABBC28416666662654095841CDCCCCCC0ABC284100000020480958410000000021BB2841CDCCCC8C36095841CDCCCCCC04BB28413333337334095841CDCCCCCCC0BA2841333333532F0958410000000091BA2841666666A62B0958410000000077BA2841333333D328095841000000006BBA28410000008027095841000000001DBA284166666626220958410000000003BA2841000000A02009584133333333E8B928419A9999591F0958419A999999CBB928419A9999591E095841CDCCCCCC91B92841000000A01C095841CDCCCCCC54B92841000000401A0958410000000016B92841000000601809584100000000C9B82841333333F314095841000000009FB8284166666666120958410000000084B82841CDCCCC8C100958416666666659B828419A9999190D0958413333333351B82841000000A00C0958413333333343B828419A9999590B0958410000000029B8284100000080090958419A99999911B828419A9999590709584100000000D7B72841000000C0FF08584133333333B8B728419A9999F9FB08584100000000C9B72841CDCCCC6CFB0858419A999999D8B7284166666626FB08584166666666EDB72841CDCCCC2CFA0858416666666607B8284133333353F9085841666666663AB8284166666646F70858413333333354B82841333333B3F6085841666666666CB8284133333393F5085841CDCCCCCC83B82841CDCCCCECF30858410000000097B8284133333333F208584166666666A5B82841000000A0F0085841CDCCCCCCD6B8284166666646E908584100000000F8B828419A999939E5085841000000002FB9284133333373DE085841CDCCCCCC3EB9284133333353DC085841666666664AB928419A999979DA0858413333333359B92841000000E0D6085841CDCCCCCC5FB92841333333D3D30858419A99999964B9284133333333D00858413333333375B9284100000080C7085841000000007EB928419A9999B9C4085841CDCCCCCC81B9284133333353C30858419A9999998EB92841666666E6BF0858419A9999999AB9284100000020BD0858419A999999A9B9284166666626BA085841CDCCCCCCB9B9284100000080B7085841CDCCCCCCEAB928419A9999D9B1085841CDCCCCCC0EBA2841333333F3AE085841000000001ABA2841CDCCCC4CAE0858410000000034BA284133333333AD0858419A9999997CBA2841000000E0AA0858419A9999999DBA284166666646A908584166666666CFBA28419A9999D9A508584100000000F9BA284100000060A20858410000000018BB2841666666E69E085841CDCCCCCC24BB2841CDCCCC4C9D0858416666666670BB284133333353930858416666666698BB2841000000408D08584166666666B1BB284100000020890858419A999999B7BB2841666666A68708584100000000C1BB2841000000408408584100000000CBBB28419A99997982085841CDCCCCCCD5BB2841000000207D0858416666666638BC2841666666067D0858413333333378BC2841666666C67D085841CDCCCCCCAEBC2841666666067F08584166666666EDBC28419A9999D9800858419A9999994ABD28419A9999D9830858410000000083BD2841CDCCCC8C8508584166666666BFBD284166666606870858419A999999FBBD28419A9999D987085841333333333ABE284166666646880858413333333375BE28419A999939880858410000000093BE28410000000088085841CDCCCCCC13BF28410000002086085841CDCCCCCCB2BF2841CDCCCCAC8308584133333333BFBF28410000008083085841CDCCCCCCC1BF28419A9999998008584100000000CDBF2841000000007C08584166666666D7BF2841CDCCCCEC78085841CDCCCCCCF1BF28419A9999F9720858413333333300C028419A999919700858419A99999911C02841666666E66C085841333333332FC028410000004068085841CDCCCCCC51C028413333333363085841CDCCCCCC64C02841000000E0600858419A9999998DC02841CDCCCC6C5C08584133333333BAC02841000000A05808584133333333CFC02841333333335708584133333333E1C02841CDCCCC4C5608584166666666E3C02841CDCCCC0C5008584100000000F9C02841000000603C085841333333330AC12841666666461C08584166666666FEC02841000000600D0858419A999999DAC02841000000A0FC0758419A999999CEC02841666666E6E80758419A999999DDC02841333333D3CE0758413333333310C128419A9999B9BA075841666666668AC128410000000091075841333333333AC22841666666266907584100000000DBC228419A999959710758410000000074C328419A999999860758416666666609C428419A9999398C0758410000000054C42841CDCCCC2C8F075841CDCCCCCC90C42841CDCCCC4C9107584100000000BDC4284166666686920758419A9999993DC528419A999999970758410000000056C52841333333F3980758419A99999965C52841666666C6990758419A99999976C52841333333539B0758416666666683C52841666666E69C07584133333333B9C52841CDCCCC4CA407584166666666CCC52841CDCCCCCCA607584133333333D6C52841000000C0A70758419A9999990BC6284100000060AC0758413333333364C62841CDCCCC0CB30758419A9999990AC72841CDCCCCCCBE0758416666666644C728419A9999B9C20758416666666650C728419A999939C30758419A9999996DC72841CDCCCC6CC40758419A9999997CC72841CDCCCCCCC4075841CDCCCCCC97C72841000000E0C407584166666666F7C728419A9999B9C20758413333333303C82841CDCCCC6CC0075841000000002CC828419A9999B9B7075841CDCCCCCC54C8284166666646AF075841000000007DC82841CDCCCC4CA607584100000000C1C82841000000609807584100000000D3C828410000004094075841CDCCCCCCDBC82841333333F391075841000000001FC92841CDCCCC0C83075841000000003CC92841000000807C0758413333333360C9284133333373740758416666666681C92841333333136D075841000000008EC92841666666466A07584166666666AAC92841333333336307584100000000D1C92841CDCCCCAC59075841CDCCCCCCEBC92841666666C653075841333333331DCA2841666666A6490758419A99999958CA2841000000603E075841333333336DCA2841CDCCCC6C3A075841CDCCCCCCB8CA28419A9999392D075841CDCCCCCCBCCA2841000000802C07584100000000C1CA28419A9999B92B07584100000000C4CA28419A9999192B0758419A999999CACA28419A9999D92907584133333333EACA2841000000202407584133333333F2CA2841666666A622075841CDCCCCCC21CB2841000000001A075841333333337CCB2841CDCCCC0C0A0758419A999999A2CB2841CDCCCCCC030758416666666617CC2841CDCCCCACF30658419A99999949CC28419A999999ED065841333333337DCC284133333353E706584133333333D1CC28419A9999B9DE065841333333333DCD284100000020D5065841000000007ECD2841666666C6CE0658419A99999992CD2841333333D3CC06584100000000C1CD284100000040C8065841000000000ECE2841CDCCCC6CBF0658419A99999922CE2841CDCCCCACBC0658419A99999940CE284133333353B90658416666666655CE284133333333B6065841000000005DCE284166666646B5065841000000007DCE2841CDCCCCACB00658416666666683CE28419A999979AF065841CDCCCCCCB2CE28419A9999D9A80658419A99999984CF28419A9999B989065841CDCCCCCCA8CF2841CDCCCC4C830658419A999999BFCF2841000000A07F06584133333333DDCF2841CDCCCC8C7A065841CDCCCCCCF9CF284100000020750658413333333335D02841666666A668065841333333335DD02841666666A65F0658419A9999997CD02841666666A657065841CDCCCCCC8BD028419A9999995206584166666666ABD028410000004048065841CDCCCCCCB0D02841333333F34506584166666666BBD02841666666C6410658419A99999905D12841666666A62D0658419A9999997ED12841CDCCCCCC0506584133333333A8D1284166666606F9055841666666660BD2284133333373DA0558416666666623D2284100000040D0055841CDCCCCCC26D2284100000040CF055841000000003AD22841CDCCCC4CC50558416666666671D2284100000080A3055841CDCCCCCCA8D22841333333B38105584166666666E0D22841CDCCCCEC5F0558413333333309D328419A999999450558416666666632D32841333333D32C0558413333333365D32841666666E60C05584166666666C5D32841333333D3D40458419A99999930D32841000000C0A60458419A9999999BD22841666666A6780458419A99999906D228419A9999994A04584166666666F6D12841333333934504584100000000EDD12841666666064504584166666666E7D12841CDCCCC6C4404584133333333E2D12841666666A64304584133333333D8D12841CDCCCC6C410458419A999999CAD12841333333B33B045841000000009FD1284166666686260458410000000093D128419A99995922045841666666661CD128419A9999190604584166666666FAD028419A999959FD035841CDCCCCCCE2D028419A9999B9F7035841CDCCCCCCD9D028419A999999F5035841CDCCCCCC9DD0284166666626E7035841CDCCCCCCD2CF2841000000E0B603584100000000CECF28419A999919B60358419A9999998FCF2841333333F3A50358413333333340CF28419A999919990358413333333331CF28413333331397035841CDCCCCCC1ECF28419A999999940358416666666612CF2841666666A692035841CDCCCCCC86CE2841666666667C0358413333333371CE2841CDCCCCAC78035841CDCCCCCC2ECE284166666646700358419A99999971CD2841000000C0590358416666666668CD28419A99993958035841333333334ACD284133333353520358416666666666CC2841666666E6330358419A99999968CB2841000000002C035841666666666ACA28419A999919240358419A9999996CC928419A9999391C0358419A999999BBC72841666666C60E035841000000009BC628419A99999918035841CDCCCCCCC3C52841CDCCCCEC1F03584166666666C4C428419A999999280358419A999999BBC42841CDCCCCEC3E03584133333333A4C42841333333933E03584133333333E0C32841666666863D0358419A999999E3C22841666666063C0358419A999999C7C22841333333333C0358410000000084C22841CDCCCC0C3D0358419A99999944C22841000000C03E0358419A999999E6C12841000000C041035841CDCCCCCC44C128410000000047035841CDCCCCCCD7C02841333333934A035841000000009CC02841666666464C035841666666668AC02841333333934C0358416666666666C02841CDCCCCAC4C0358410000000057C02841666666664C0358416666666647C02841CDCCCCCC4B0358419A99999939C02841333333F34A0358413333333309C02841333333F34703584100000000FEBF2841000000404D035841333333339DBF2841CDCCCCEC8C0358419A99999955BF28419A9999398D0358419A99999949BF28419A9999598D035841000000003DBF2841000000C08D035841CDCCCCCC32BF28419A9999798E0358413333333329BF28419A9999F98F0358416666666615BF2841333333D3930358416666666601BF2841333333939803584133333333F5BE28419A9999199B03584100000000EFBE28419A9999599B03584166666666E4BE2841666666269B035841CDCCCCCCB3BE2841666666E6980358413333333396BE284100000060970358410000000079BE2841666666A6950358419A99999945BE2841CDCCCC2C92035841666666662CBE284100000000A30358413333333320BE284100000040AB035841CDCCCCCCB9BD28419A999999A9035841333333337CBD2841CDCCCC8CA903584166666666E0BC2841CDCCCC4CA903584133333333E7BC2841CDCCCC8CAF0358419A999999EBBC2841333333B3B30358419A999999F7BC284166666686B9035841333333331BBD284133333353C30358416666666640BD284100000080CD035841666666666ABD2841CDCCCC0CD903584100000000C5BD2841333333F3F103584100000000FBBD2841000000C000045841CDCCCCCCF0BC28419A9999F9FA035841000000009EBC284166666686F8035841CDCCCCCC7BBC284133333313090458410000000058BC2841000000601A0458419A99999935BC2841666666262B045841CDCCCCCC0EBC2841666666E63D04584166666666D5BA28413333331331045841CDCCCCCCD8B928419A9999992604584100000000D5B92841000000002604584100000000CFB92841333333F32604584166666666CCB928419A999959270458419A999999AEB92841CDCCCC6C3404584166666666A5B928410000006039045841CDCCCCCC95B92841CDCCCC0C42045841CDCCCCCC7EB92841666666E64C045841666666666DB92841CDCCCC2C560458413333333356B92841CDCCCCEC620458410000000050B92841CDCCCC8C65045841666666662BB928413333333364045841000000001FB82841666666465A045841CDCCCCCCD5B7284100000020570458419A99999950B7284166666646520458410000000011B72841666666E64F0458419A999999BDB628419A9999B94C0458410000000065B628419A9999D9480458410000000016B62841CDCCCCEC450458419A999999CCB52841CDCCCC0C4304584166666666CBB52841CDCCCC2C4404584166666666C0B52841333333534E04584100000000B4B5284133333393590458416666666682B52841333333138F0458413333333358B528419A9999998D045841333333334DB52841666666468C0458416666666644B528419A9999F98B0458419A9999992AB52841666666468C045841666666660AB52841333333738D04584166666666D6B428419A9999998F04584100000000BDB32841666666669A0458419A99999981B32841CDCCCC0C9D0458416666666642B328419A9999199F04584166666666CFB22841333333F3A204584166666666AAB2284133333373A40458416666666689B22841CDCCCC2CA60458419A9999996AB2284133333393A70458419A999999AEB12841333333D3AD0458416666666638B12841333333D3B0045841CDCCCCCCC5B0284166666646B3045841666666667AB028419A999959B5045841CDCCCCCC1FB02841CDCCCC6CB70458419A999999E8AF2841666666A6B80458419A999999B7AF284133333333BA04584100000000A2AF284100000080BA0458410000000086AF284100000020BB0458416666666668AF2841333333F3BB045841CDCCCCCC0AAF2841000000A0BE04584100000000B0AE2841666666C6C00458410000000079AE2841CDCCCC6CC10458413333333332AE2841333333B3C1045841CDCCCCCC04AE284133333373C104584166666666D4AD2841666666E6C004584100000000A0AD2841CDCCCCACBF0458413333333362AD284166666686BB0458416666666642AD28419A9999D9B8045841333333330AAD2841CDCCCC2CB904584133333333E1AC2841000000A0B80458413333333356AC284133333333B5045841000000002DAC284100000060B404584100000000F8AB2841000000A0B3045841CDCCCCCC75AB2841CDCCCC0CB204584166666666F0A9284166666626AE045841CDCCCCCCAAA928419A999999D50458419A99999988A9284133333313E90458416666666666A9284133333353FC0458410000000042A928419A99991911055841333333331EA92841666666662505584133333333FBA828413333333339055841CDCCCCCCD7A828419A9999594D055841CDCCCCCCABA82841000000406605584133333333EAA82841000000A06705584166666666D0A82841666666A675055841CDCCCCCCAFA82841CDCCCCAC87055841CDCCCCCCA6A82841666666E68A055841CDCCCCCC70A82841666666A69D0558410000000035A82841333333F3B3055841CDCCCCCC27A8284100000040B9055841CDCCCCCC19A8284100000040BE0558413333333302A82841CDCCCCCCC505584133333333D5A72841CDCCCC6CD505584133333333B9A7284133333373DD0558416666666696A7284100000060E80558416666666691A728419A999959EA055841000000008FA72841000000A0EC055841000000008CA7284100000020ED0558416666666688A7284133333393EE0558410000000084A7284133333353F10558410000000080A7284133333393F20558413333333378A7284133333353F3055841CDCCCCCC6AA72841CDCCCC8CF3055841666666669EA7284166666666F805584133333333C5A728419A999979FE05584133333333CDA728419A9999D90206584166666666D0A72841CDCCCCCC0506584100000000D4A72841333333530706584133333333DFA72841000000600A0658413333333308A82841CDCCCC2C100658410000000023A8284100000000130658410000000086A82841333333331E0658419A999999A2A82841000000A023065841CDCCCCCCB4A828419A9999D927065841CDCCCCCCBDA828413333331329065841CDCCCCCCC7A82841333333332B0658419A999999EEA8284100000040300658419A9999990FA92841666666A6330658419A99999917A92841000000203406584133333333D0A828419A9999D94A0658419A999999A3A828410000006049065841666666665CA828419A9999F9600658413333333333A828413333335370065841333333333AA828410000000070065841CDCCCCCC46A82841CDCCCCAC70065841666666664AA828419A99991971065841666666663FA828410000008074065841666666660EA82841333333B3830658419A999999FCA72841666666E682065841CDCCCCCCF2A728419A99991982065841000000007AA72841CDCCCCCCA40658419A999999F5A628419A9999B9A70658419A999999D2A62841000000A0A806584166666666B9A6284100000000A9065841000000006AA62841333333F3A90658410000000059A6284166666646AA065841666666662AA62841CDCCCCCCAB065841CDCCCCCC0BA62841CDCCCC8CAC065841CDCCCCCCE6A52841000000C0AD065841666666669DA528419A999999AF0658419A99999981A52841333333B3AF065841666666664DA5284133333373AF0658416666666640A5284166666666AF0658416666666621A5284133333333B30658419A9999990DA5284166666686B106584166666666EAA42841333333B3BA065841000000005CA42841CDCCCCECDF065841CDCCCCCC7AA32841666666A61A075841CDCCCCCC5DA3284166666646220758416666666659A3284100000060230758416666666678A32841666666C6250758416666666678A3284100000080260758419A99999978A32841CDCCCC4C27075841CDCCCCCC70A3284100000000290758413333333350A328419A99999935075841CDCCCCCC3BA328419A9999993C075841000000001DA328419A999999440758410000000008A3284166666646490758419A999999E2A228419A9999F94F07584133333333B2A22841666666C65D0758416666666662A22841666666E6700758416666666622A22841CDCCCC8C83075841666666660EA22841CDCCCC4C88075841000000007DA1284133333313A7075841CDCCCCCC9AA1284166666646AB07584100000000ACA128419A9999D9AE07584166666666B7A12841666666A6B007584100000000C4A1284166666606B20758413333333310A22841CDCCCC8CB6075841CDCCCCCCE7A128419A9999B9BC0758419A9999999AA1284166666606CA0758410000000006A2284166666666CF075841CDCCCCCC0AA2284166666686CD075841CDCCCCCC1AA22841666666A6C90758419A99999926A2284166666626C8075841000000007EA22841000000A0D007584166666666A3A228419A999959D3075841333333330BA32841333333F3DB0758413333333305A328419A9999B9DD07584100000000E3A228419A9999B9E4075841666666662DA32841333333F3EC075841000000005AA3284133333353F30758416666666658A328419A999999F30758416666666674A32841CDCCCC8CF607584133333333A2A328419A9999D9FA07584166666666B9A328419A999979FD07584133333333C1A328419A9999B9FE07584100000000D3A32841CDCCCC8C020858419A999999E4A328410000000005085841CDCCCCCCF1A32841CDCCCC4C0608584166666666FEA328419A99995907085841000000000DA428410000006008085841666666662AA42841000000E0090858410000000068A42841CDCCCCAC0D085841CDCCCCCC9FA42841333333131108584133333333C6A42841CDCCCC2C13085841CDCCCCCC09A5284100000040170858419A9999994DA52841CDCCCCEC1A0858419A99999962A52841666666461C085841CDCCCCCCDAA52841333333F322085841CDCCCCCC7EA52841CDCCCCCC2A0858419A9999993EA52841333333F33008584166666666D2A42841CDCCCC4C3B08584133333333B3A428419A9999D93D0858419A99999941A428416666666647085841CDCCCCCC05A42841000000E04D0858413333333363A32841333333935F085841666666665DA328419A999939600858413333333306A32841666666E6690858419A999999D5A22841666666C66F085841CDCCCCCCBEA22841000000407208584133333333C1A2284100000060720858410000000096A2284133333313780858419A999999FBA12841CDCCCC4C8A0858419A999999DFA128419A9999D98D08584166666666C4A12841666666469108584166666666BDA128410000002092085841CDCCCCCCAAA12841CDCCCC8C940858413333333365A12841666666C69D085841333333334CA12841CDCCCCCCA10858410000000044A1284100000020A30858419A99999928A1284100000020A80858413333333305A1284166666666AF08584100000000DEA028419A999919B908584166666666CFA028419A9999B9BC08584133333333BCA02841CDCCCCACC1085841CDCCCCCC9FA0284133333373C80858419A99999991A0284166666626CC0858413333333389A02841CDCCCC4CCE085841CDCCCCCC68A028419A999939DB085841CDCCCCCC61A0284133333393DF085841666666665BA028419A9999F9E40858416666666651A02841CDCCCC8CE90858416666666644A028419A9999F9ED0858419A99999934A02841666666C6F10858416666666625A028419A9999D9F4085841000000000DA0284133333353F80858419A999999DD9F284100000060FE08584100000000CD9F28419A99999901095841CDCCCCCCBF9F28419A99993905095841CDCCCCCCB59F28419A9999190909584100000000A69F2841333333130E09584100000000709F2841666666C623095841666666665B9F2841333333B32B095841000000004C9F2841CDCCCC8C3009584166666666379F2841333333733809584166666666199F2841333333734009584100000000F79E284166666626480958419A999999DD9E2841000000604D09584133333333AD9E2841CDCCCCEC54095841CDCCCCCC7B9E2841CDCCCCAC5B095841CDCCCCCC619E28419A9999F95E095841666666660C9E284166666626690958419A999999D79D28416666660670095841666666668A9D28419A9999597809584100000000789D2841666666867A0958419A9999993E9D2841CDCCCC6C8109584166666666F39C2841000000008B095841CDCCCCCCE09C2841000000608D09584100000000A19C28419A99993996095841CDCCCCCC719C2841666666A69D09584100000000709C2841333333D39F09584166666666659C284100000020A4095841000000005D9C2841CDCCCC6CA909584166666666549C2841333333B3AD0958419A9999994F9C2841CDCCCC4CB0095841CDCCCCCC4C9C2841CDCCCCCCB1095841CDCCCCCC459C2841000000C0B509584100000000329C284100000000C109584133333333279C284100000060CB0958419A999999219C2841CDCCCC2CD20958419A9999991D9C2841666666A6DA09584133333333259C28419A9999D9E10958419A999999379C2841000000E0EC09584166666666BA9B2841333333F3D7095841CDCCCCCCA49A28419A999999A60958419A999999899A28419A9999D9A1095841CDCCCCCC5B9A2841CDCCCCCC9909584100000000F7992841CDCCCCAC8709584100000000B6992841CDCCCC6C7B09584166666666A0992841CDCCCC2C77095841CDCCCCCCA1982841333333B34D0958410000000092982841666666464A0958413333333381982841666666A646095841666666666C9828416666664643095841CDCCCCCC60982841CDCCCC8C45095841333333335D982841666666464609584100000000599828413333331347095841333333334B9828419A9999F949095841000000003A9828419A9999394C0958410000000027982841666666664E0958410000000015982841CDCCCC0C510958413333333307982841000000605309584133333333F29728419A9999D9560958419A999999E2972841333333535909584133333333C6972841333333D35E09584133333333BF972841666666266009584166666666BA97284166666666610958419A999999A4972841CDCCCCEC65095841666666668A972841666666466B0958416666666681972841000000E06C0958419A9999996F972841000000006F095841333333335A972841666666C672095841CDCCCCCC40972841666666E67609584133333333359728419A999979780958419A99999922972841666666467B095841CDCCCCCC0D972841CDCCCC6C7E095841CDCCCCCCF89628419A9999998109584133333333E89628413333331384095841CDCCCCCCDF962841666666668509584100000000DE9628419A9999F98609584166666666D6962841666666868809584166666666CE962841333333F38909584100000000C5962841000000A08B0958419A999999AE962841000000808F0958419A999999A2962841333333F391095841CDCCCCCC7D96284133333373990958410000000061962841CDCCCC6CA0095841CDCCCCCC46962841CDCCCCCCA6095841CDCCCCCC0C96284100000020B5095841CDCCCCCCFA952841CDCCCCCCB90958419A999999F9952841CDCCCCACBA0958419A999999EB952841CDCCCC4CBA09584100000000D795284133333373BA09584133333333C495284166666626BB095841CDCCCCCCB7952841CDCCCC4CBC0958419A999999AA952841CDCCCC2CBE0958419A9999999995284133333333C1095841CDCCCCCC8095284100000060C50958419A9999996A952841000000E0C80958413333333350952841CDCCCCCCCC095841CDCCCCCC429528419A999959CF0958419A9999992D95284166666686D30958419A9999991A95284166666606D7095841CDCCCCCC0695284166666606DA09584100000000F194284100000080DD0958419A999999E594284100000060E009584133333333D7942841666666A6E3095841CDCCCCCCC69428419A999979E609584133333333B6942841333333F3E8095841CDCCCCCCA1942841CDCCCC2CEB095841666666668E94284133333333ED0958419A9999997794284133333353EF0958416666666662942841333333D3F0095841CDCCCCCC55942841CDCCCC6CF1095841666666663E9428419A9999D9F20958413333333337942841CDCCCC6CF3095841000000002B9428419A9999B9F60958413333333315942841CDCCCC8CFD095841CDCCCCCCF29328419A9999F9070A5841CDCCCCCCC393284100000020160A584133333333BF932841CDCCCC6C170A5841CDCCCCCCA8932841CDCCCC6C1D0A5841666666669D93284166666686200A5841000000008393284133333393260A5841666666667D932841CDCCCCCC280A58419A9999997C932841CDCCCCAC290A5841666666667B932841000000002B0A58419A99999978932841666666A62F0A584133333333709328419A999939330A5841CDCCCCCC639328419A9999B9360A58410000000072932841333333B3380A5841666666667F932841666666863A0A584133333333879328419A9999993B0A5841333333335E932841666666A6480A58419A99999909932841000000A0520A584133333333F592284166666606550A5841CDCCCCCCBB922841333333935E0A584166666666379228419A999939740A5841CDCCCCCCF4912841CDCCCC4C830A584133333333E8912841CDCCCCAC850A584133333333BB9128419A9999398E0A5841CDCCCCCC8E912841666666A6960A5841333333338C91284166666626970A5841000000003591284166666686A00A58410000000034912841CDCCCCACA00A58410000000010912841666666C6A60A584166666666DF90284166666606AF0A584133333333C190284133333313B40A5841333333338A9028419A9999D9BD0A5841333333338190284133333353C00A58419A9999999C90284133333333C10A584166666666FD9028419A9999D9C40A5841000000000B912841CDCCCC4CC50A58413333333305912841000000A0C60A5841000000000291284100000040C70A5841CDCCCCCCF5902841000000C0C80A58419A999999CE902841CDCCCC4CCE0A584133333333AC90284166666626D40A58419A9999998F90284166666666D90A58410000000076902841CDCCCC8CDE0A58413333333360902841CDCCCC2CE20A58413333333350902841CDCCCCACE40A5841CDCCCCCC3D90284166666646E70A5841CDCCCCCC2B90284166666686E90A5841333333331F902841000000C0EA0A5841CDCCCCCC169028419A999979EB0A58419A9999990D902841333333D3EB0A5841CDCCCCCC05902841333333B3EC0A58419A999999FD8F2841CDCCCCECEE0A584166666666F68F284133333313F10A5841CDCCCCCCE68F284133333373F40A5841CDCCCCCCCD8F28419A999959F90A584100000000AA8F2841CDCCCC2CFF0A5841000000008C8F2841000000A0040B584100000000688F284133333393090B584100000000558F28419A9999790C0B584133333333438F2841333333930F0B584166666666308F284166666686120B5841CDCCCCCC1A8F284166666646150B58419A999999068F2841666666C6170B584133333333F68E2841CDCCCC4C1A0B584133333333E98E2841000000E01D0B584166666666E38E2841666666C6210B584100000000DE8E284166666686270B5841CDCCCCCCD78E2841CDCCCCEC290B58419A999999E48E2841666666C62C0B58419A999999B68E28419A999979300B58419A999999598E284133333313370B584166666666268E2841333333933D0B58419A999999A18D2841000000C0440B5841666666663A8D2841333333B3480B58419A999999148D2841CDCCCC4C4B0B584133333333D98C28419A999979750B584166666666C08C2841333333F3760B584133333333AA8C28419A999979790B58419A9999999D8C2841CDCCCCCC7B0B58419A9999998A8C2841000000407E0B584133333333758C2841666666C67F0B584166666666628C2841333333337E0B5841CDCCCCCC598C2841333333F37E0B584166666666508C284166666646800B58419A999999498C284100000060810B584166666666408C2841333333D3820B584100000000358C284133333353840B584133333333288C28419A999959850B58419A9999991B8C2841CDCCCC2C860B58419A999999178C2841CDCCCCAC860B58419A999999128C2841CDCCCC4C870B58419A999999088C2841CDCCCC8C880B584100000000008C2841000000A0890B584166666666F68B2841CDCCCC2C8B0B584133333333EE8B2841000000408C0B5841CDCCCCCCE28B2841000000608E0B5841CDCCCCCCD38B28419A999919910B584133333333C68B284133333353930B58419A999999BA8B28419A9999B9960B584133333333AA8B2841666666469A0B5841000000009E8B28419A9999799D0B584100000000938B2841000000A0A00B5841CDCCCCCC888B2841CDCCCCCCA20B5841000000007C8B2841666666C6A50B5841CDCCCCCC6B8B2841666666E6A80B584100000000548B28419A999919AC0B5841333333333F8B2841CDCCCCACAF0B584100000000278B2841666666A6B30B5841333333331B8B2841333333D3B50B5841333333330F8B284133333313B80B5841CDCCCCCC0B8B2841CDCCCC0CB90B58419A999999FC8A284166666686BD0B584100000000F08A2841666666C6C00B58419A999999E38A284100000060C40B584100000000D88A2841000000C0C70B584133333333CF8A2841666666E6CA0B584166666666C98A284100000040CE0B584133333333C68A28419A999999D10B58419A999999BF8A2841CDCCCC0CD50B5841CDCCCCCCB38A284100000000D80B584133333333A18A2841CDCCCC8CDB0B58419A9999998F8A28419A999919DE0B5841666666667A8A2841CDCCCC6CE00B584100000000668A284100000020E20B5841CDCCCCCC528A2841666666C6E30B584133333333448A284100000020E60B5841CDCCCCCC328A2841CDCCCC4CE90B58419A999999258A28419A999939EC0B58419A999999168A2841333333F3EF0B584133333333088A284166666686F20B58419A999999F78928419A999939F60B5841CDCCCCCCEB892841CDCCCC8CF90B5841CDCCCCCCE289284100000020FC0B584133333333D4892841CDCCCC0CFF0B58419A999999C989284133333313010C5841CDCCCCCCB5892841CDCCCC0C040C584166666666A68928419A999999070C5841333333339A8928419A9999F90A0C5841CDCCCCCC8E892841666666860E0C58419A99999987892841CDCCCC8C100C5841CDCCCCCC8189284166666606120C58419A9999997889284100000000150C58419A9999997289284133333393180C5841000000006F892841666666C61A0C58419A99999965892841000000C01F0C58410000000055892841CDCCCCCC230C5841CDCCCCCC3D8928419A999999290C58419A9999992C892841666666E62E0C5841000000002289284166666666340C5841666666661D89284100000000390C5841666666661C892841333333333A0C58419A9999991A892841666666063E0C58419A99999918892841666666E6410C584133333333138928419A9999194E0C58416666666610892841CDCCCC0C550C5841000000000A892841333333F35C0C58413333333306892841666666E6630C58413333333305892841CDCCCC8C690C58419A999999048928419A9999B96D0C5841333333330189284100000060730C58416666666607892841CDCCCC4C7E0C5841666666660889284100000020810C5841333333330689284133333353840C584100000000F98828419A9999F9890C584166666666F3882841333333338D0C584166666666EF882841000000208F0C584100000000E988284100000060930C584166666666E8882841000000809D0C584166666666E8882841CDCCCC6CA00C584133333333F78828419A999979A40C584133333333FF8828419A999919A70C58419A9999990689284166666686AA0C584166666666108928419A9999F9B20C58416666666612892841000000C0B40C584100000000188928419A9999F9B60C58413333333317892841CDCCCCECB80C5841CDCCCCCC13892841333333F3BB0C5841CDCCCCCC0F892841000000C0BE0C5841000000000489284100000060C20C5841CDCCCCCCF388284100000020C80C584100000000EB882841333333B3CB0C5841CDCCCCCC9988284133333353DA0C58419A99999989882841000000A0DD0C5841CDCCCCCC7D882841CDCCCCACE00C58413333333373882841000000E0E30C5841333333336388284133333393ED0C5841666666665688284133333393F30C5841CDCCCCCC4988284166666666FE0C5841000000004B8828419A9999B9050D58416666666635882841666666060C0D5841CDCCCCCC2A882841333333D3100D58419A9999992A882841333333F3110D5841666666660F882841000000E00F0D5841CDCCCCCC0F88284100000040130D58419A9999990B88284166666626170D5841CDCCCCCC0A88284166666686180D5841666666660C882841000000A0190D584100000000118828419A9999191B0D58413333333316882841666666261D0D58419A99999917882841CDCCCC4C1E0D58413333333317882841CDCCCC6C1F0D58419A99999915882841CDCCCCAC200D5841CDCCCCCC1188284133333393260D5841333333331188284133333393270D58419A9999990F8828419A999999280D5841333333330C882841CDCCCC8C290D5841333333330A882841CDCCCCAC2A0D58410000000008882841666666462C0D584100000000078828419A9999F92D0D5841CDCCCCCC08882841CDCCCC8C2F0D5841CDCCCCCC0A88284133333393310D5841333333330C88284100000040330D5841CDCCCCCC0B8828419A999919340D58419A99999908882841000000E0340D584166666666038828419A999979350D584100000000D78728419A999919390D584100000000C5872841666666863B0D5841CDCCCCCCC3872841333333733C0D584166666666C3872841000000203D0D584100000000AE8728419A9999F93C0D58419A999999A8872841333333F33C0D584133333333A6872841CDCCCCEC3C0D58416666666699872841666666A63B0D5841000000005C872841CDCCCC2C340D58416666666620872841000000E02C0D584166666666F3862841000000A0270D5841CDCCCCCCE9862841CDCCCC8C260D584133333333C78628419A999959230D584166666666BD862841666666A6220D584166666666AC86284166666686220D584100000000A486284100000000230D5841666666669B862841CDCCCCEC230D58419A999999858628419A999919270D58410000000064862841333333D32C0D58410000000048862841CDCCCCCC300D5841CDCCCCCC19862841CDCCCC8C360D58419A999999F3852841000000203C0D584100000000F0852841CDCCCC8C3D0D5841CDCCCCCCEF852841000000C03E0D584166666666F18528419A9999D93F0D584100000000F885284166666606410D5841CDCCCCCC27862841CDCCCCAC470D5841666666663586284100000080490D58419A99999939862841333333734A0D58413333333338862841000000C04C0D5841CDCCCCCC28862841CDCCCC0C510D5841CDCCCCCC1A8628419A9999F9540D5841000000000D862841666666A65B0D58419A99999906862841333333535F0D584100000000FB85284166666646630D584166666666E28528419A9999996A0D58419A999999DE852841666666C66B0D584166666666D5852841000000C06E0D584133333333CE852841666666E6700D5841CDCCCCCCA2852841666666A6780D58419A99999974852841CDCCCCEC800D58410000000048852841CDCCCCEC880D5841333333333B852841CDCCCC4C8B0D5841CDCCCCCC208528419A999919900D58419A9999990B852841000000E0920D584133333333E584284133333333970D584100000000B1842841666666469C0D58416666666691842841000000E09E0D5841333333335E842841333333D3A00D5841333333333D842841CDCCCCECA10D58410000000029842841333333D3A10D58419A999999CD832841333333B3A00D584166666666C48328419A999919A10D584133333333C08328419A9999D9A10D584133333333B1832841CDCCCC4CA60D5841CDCCCCCCA8832841666666A6A90D5841CDCCCCCCA283284133333313AC0D5841CDCCCCCCC1832841333333B3AE0D584100000000E683284100000080B30D58419A999999FB83284100000080B60D58419A99999928842841666666C6BC0D5841CDCCCCCC32842841333333B3BE0D5841000000003784284166666606C00D5841CDCCCCCC3884284166666666C10D58410000000038842841333333F3C20D58413333333338842841666666A6C60D5841666666663C8428419A9999F9C90D584166666666458428419A999959CC0D584166666666608428419A9999B9D00D5841CDCCCCCC7E842841CDCCCCECD40D5841CDCCCCCCA684284166666606DA0D58419A999999B58428419A999979DB0D584133333333D584284133333393DE0D58419A999999DB842841CDCCCC2CDF0D58419A9999990B85284100000000E30D5841333333332B85284166666686E50D5841000000006385284166666646EA0D58410000000083852841000000E0EC0D58419A9999998B85284133333393ED0D58419A999999F0852841000000A0F30D5841333333334186284100000080F90D5841333333335D8628419A999999FB0D5841CDCCCCCC69862841CDCCCC8CFC0D5841000000009B86284166666666020E584133333333B28628419A999939050E584133333333C0862841CDCCCCEC060E584133333333E1862841333333F30A0E58416666666606872841CDCCCC0C0F0E5841CDCCCCCC12872841CDCCCC8C0F0E58416666666622872841CDCCCCAC0F0E5841CDCCCCCC3E872841CDCCCC0C100E58419A99999967872841000000A0100E58419A9999996C872841CDCCCCAC100E584100000000818728419A999979110E5841333333339E87284100000020130E58419A999999A5872841333333D3130E584133333333AC87284133333373140E584166666666D687284133333353190E5841CDCCCCCCFD872841000000601D0E5841CDCCCCCC2988284100000080200E5841666666666E882841CDCCCC0C230E5841000000009988284133333313250E584133333333AF882841000000E0250E58419A999999C8882841666666E6260E584133333333D28828419A999919270E584133333333DE88284100000060270E584100000000FE882841000000C0270E584100000000338928419A9999D9270E5841666666664D892841666666E6270E58410000000065892841CDCCCCEC270E5841666666667189284166666606280E58410000000096892841CDCCCC6C280E584166666666C3892841CDCCCCAC280E584133333333D489284100000000290E5841CDCCCCCCDE8928419A9999B9290E584133333333E3892841333333932A0E584133333333008A2841000000E02D0E5841666666662D8A284166666626330E5841666666664C8A28419A999979360E58419A9999995E8A2841333333F3370E5841666666666F8A2841666666C6380E5841CDCCCCCC598A2841CDCCCCAC3A0E58419A999999278A2841000000C03E0E584100000000128A2841333333B3400E584133333333028A28419A999919420E584100000000E189284100000020450E5841CDCCCCCCCB89284166666666460E584166666666BB892841CDCCCCEC460E5841CDCCCCCCB2892841000000E0460E584166666666AA892841000000E0460E584100000000A1892841333333F3460E58413333333394892841CDCCCC0C470E5841000000008589284133333373470E58419A99999972892841CDCCCC6C480E58419A9999995A89284166666686490E58413333333349892841333333F3490E5841CDCCCCCC3F8928419A9999F9490E58419A99999935892841CDCCCC0C4A0E5841000000001E8928419A999999490E5841666666660689284100000000490E58419A999999F5882841000000C0480E584100000000EB882841000000C0480E584166666666D9882841000000C0480E584100000000C28828419A999939490E5841CDCCCCCCAA882841CDCCCC2C4A0E58416666666690882841666666E64B0E5841333333335288284100000060510E58416666666631882841666666C6530E5841CDCCCCCC0B882841CDCCCCCC550E584166666666CF87284100000080580E584166666666A7872841333333B35A0E5841CDCCCCCC91872841000000205C0E5841CDCCCCCC7D872841666666665D0E5841CDCCCCCC468728419A9999F9600E5841333333331E872841CDCCCC0C630E584166666666078728419A9999D9630E58419A999999EF862841CDCCCCAC640E584100000000C28628419A999919660E584133333333A88628419A9999B9660E5841666666668D8628419A9999B9670E58410000000077862841333333F3680E5841000000007186284166666646690E58413333333351862841333333736A0E5841CDCCCCCC25862841000000C06B0E58416666666601862841000000006D0E584100000000E9852841666666E66D0E584100000000DF8528419A9999796E0E584133333333D5852841333333136F0E58419A999999B585284100000080710E5841000000009D85284100000000730E58419A99999988852841CDCCCC6C730E5841333333337485284166666666730E5841666666666B8528419A999959730E58413333333362852841CDCCCC4C730E5841CDCCCCCC4C852841333333F3720E5841666666663185284100000080720E5841333333331685284100000020720E58419A9999990385284100000000720E584133333333EC84284100000000720E58419A999999D584284133333373720E58419A999999A884284166666666730E5841333333337B8428419A999979740E5841666666666184284133333333750E58419A99999950842841CDCCCC8C750E5841333333334284284166666686750E5841333333332984284100000040750E584133333333108428419A9999D9740E58419A999999F6832841CDCCCC6C740E584166666666D5832841333333D3730E584100000000AE8328419A9999F9720E5841000000007E8328419A9999D9710E58413333333374832841CDCCCCAC710E5841333333334B832841000000E0700E58419A9999992683284100000040700E58410000000004832841000000A06F0E5841CDCCCCCC96822841CDCCCCAC6D0E58419A99999946822841666666466C0E58416666666627822841CDCCCCEC6B0E58419A9999991C822841333333D36B0E5841CDCCCCCC0C822841CDCCCCAC6B0E58419A999999F3812841333333B36B0E584133333333D38128419A9999F96B0E584166666666A9812841333333736C0E5841CDCCCCCC9F812841333333936C0E58419A9999997D812841000000C06C0E5841CDCCCCCC77812841333333B36C0E5841666666666E812841CDCCCCAC6C0E584100000000668128419A9999996C0E58413333333353812841333333536C0E5841CDCCCCCC42812841CDCCCC0C6C0E58410000000035812841666666C66B0E58416666666628812841666666A66B0E5841CDCCCCCC1C812841000000A06B0E58419A99999912812841000000006C0E58419A99999908812841000000806C0E584133333333FC802841666666666D0E58419A999999EF802841333333936E0E5841CDCCCCCCE58028419A9999396F0E584100000000DB802841666666A66F0E584166666666CD8028419A9999F96F0E584166666666A68028419A999999700E5841CDCCCCCC6F80284100000060710E5841666666665E802841666666A6710E5841CDCCCCCC4E802841333333D3710E5841000000007280284100000060750E5841666666667D80284166666686760E5841CDCCCCCC9480284133333333790E5841CDCCCCCCAB802841333333D37B0E5841CDCCCCCCB0802841666666667C0E5841CDCCCCCCD1802841CDCCCCEC7F0E58419A999999E980284100000020820E5841000000000881284133333373840E58416666666617812841000000C0850E5841CDCCCCCC37812841666666C6870E58419A99999949812841CDCCCCEC880E58413333333359812841666666468A0E58419A9999996D8128419A9999598C0E5841666666667B812841666666668D0E5841666666667F8128419A9999D98D0E58416666666687812841333333338E0E58419A999999BB812841CDCCCC6C920E584133333333C5812841CDCCCC2C930E584133333333D181284100000020940E584166666666DA812841666666E6940E5841CDCCCCCCE3812841CDCCCCAC950E584133333333F581284100000020970E5841CDCCCCCC0482284166666626980E5841CDCCCCCC1682284133333353990E58419A99999928822841333333739A0E58419A99999939822841CDCCCCAC9B0E58416666666648822841666666069D0E5841CDCCCCCC4E822841333333939D0E5841666666665E8228419A9999F99E0E58413333333366822841000000A09F0E58419A99999975822841000000E0A00E5841CDCCCCCC86822841CDCCCC4CA20E584133333333A38228419A9999F9A40E58419A999999AE82284100000020A60E584100000000B98228419A999959A70E58419A999999C28228419A999959A90E5841CDCCCCCCD9822841000000C0AD0E58419A999999F682284100000060B30E5841333333330A83284166666646B70E5841666666661B832841666666E6BA0E584100000000238328419A999999BC0E5841CDCCCCCC37832841000000A0C00E5841333333334583284133333333C30E5841CDCCCCCC42832841CDCCCCACC60E5841CDCCCCCC4A832841000000A0C80E5841CDCCCCCC4B832841333333B3CB0E5841666666664D83284100000080CE0E58419A9999994D83284133333393CF0E5841CDCCCCCC4383284100000000D00E58419A9999990D83284133333353D20E58419A999999AF82284133333313D60E5841333333334F82284133333333D90E5841000000001782284100000000DB0E5841333333330D822841CDCCCC4CDB0E5841CDCCCCCCBA8128419A999919DE0E58419A999999848128419A999959E00E58419A9999993F812841333333F3E20E58413333333310812841666666A6E40E5841CDCCCCCCE0802841CDCCCCACE50E5841CDCCCCCCC48028419A999979E60E5841CDCCCCCCA880284100000000E80E5841666666669A802841333333D3E80E5841CDCCCCCC8D80284166666686E90E5841333333337D80284100000020EA0E5841333333336D802841333333B3EA0E58416666666662802841666666E6EA0E58419A9999992F802841333333F3EB0E58413333333309802841333333D3EC0E58419A999999E27F284133333313ED0E584133333333BF7F2841CDCCCC0CED0E5841666666669D7F2841CDCCCCCCEC0E584133333333897F28419A999939ED0E584100000000697F2841CDCCCCCCED0E584166666666327F284133333353EE0E584166666666ED7E284166666686EE0E5841CDCCCCCCA87E2841666666C6EE0E5841000000008F7E28419A9999B9EE0E584166666666787E2841333333B3EE0E584100000000547E28419A9999B9EE0E5841CDCCCCCC037E28419A9999F9EE0E5841CDCCCCCCE57D28419A999959F00E584166666666D97D2841666666A6EF0E584133333333C97D284133333373EF0E584166666666537D28419A999919F00E5841666666660A7D2841CDCCCCECF00E584100000000FA7C284100000040F10E58419A999999EC7C284166666626F10E584133333333BD7C284133333313F20E584166666666477C2841CDCCCC4CF40E5841666666668D7B284100000060F60E58419A999999597B2841CDCCCC8CF40E584133333333457B284166666646F50E584166666666267B28419A999939F60E5841000000000A7B2841CDCCCC0CF70E584100000000E57A28419A999999F70E584166666666B07A284166666666F80E584133333333387A284133333313FA0E58419A9999998379284133333373FC0E5841CDCCCCCCF578284133333353FE0E5841CDCCCCCCCC782841333333D3FE0E584133333333A178284166666686FF0E58419A9999998C782841CDCCCCECFF0E58419A9999997B782841CDCCCC4C000F58416666666640782841CDCCCC6C010F584166666666F377284166666646030F5841CDCCCCCC6D77284166666646060F5841666666663977284133333373070F584133333333F8762841000000A0080F584133333333DE7628419A9999F9080F584166666666AC762841666666060A0F5841CDCCCCCC87762841666666E60A0F5841CDCCCCCC60762841666666E60B0F58419A9999993A762841333333D30C0F58410000000012762841CDCCCC0C0E0F584166666666EB752841000000200F0F584166666666B5752841333333B3100F584166666666F974284100000000160F584166666666A874284133333353180F5841666666666E742841333333F3190F58410000000041742841000000401B0F5841000000000B742841CDCCCCCC1C0F584133333333E3732841CDCCCCCC1D0F5841666666662F73284100000040220F5841000000002673284100000080220F58419A9999991A732841666666C6220F584133333333EE722841666666C6230F58419A99999995722841CDCCCCCC250F584133333333ED712841333333B3290F584100000000E4712841666666E6290F58413333333384712841CDCCCC0C2C0F584133333333FC7028419A9999192F0F584100000000E0702841333333B32F0F5841CDCCCCCC7470284100000000320F5841CDCCCCCC4B702841666666E6320F58419A999999DA6F284133333373350F584166666666C26F284100000000360F584166666666A76F28419A999999360F5841666666665A6F284133333353380F5841CDCCCCCC0B6F2841333333133A0F584100000000F36E2841000000A03A0F5841000000009A6E2841CDCCCCAC3C0F584133333333796E2841CDCCCC6C3D0F584166666666096E284100000000400F584100000000CC6D2841CDCCCC6C410F58419A999999766D284100000060430F584166666666066D2841333333F3450F584166666666DC6C2841333333D3460F58419A999999A56C28419A999919480F58419A999999396C2841000000A04A0F58419A9999991B6C28419A9999594B0F584133333333DE6A2841CDCCCCCC520F584166666666BD6A2841CDCCCC8C530F584133333333536A28419A9999F9550F584166666666156A284133333353570F5841CDCCCCCC106A2841CDCCCC6C570F584166666666AD692841CDCCCCAC590F58419A9999991E692841CDCCCC0C5D0F584166666666036928419A9999B95D0F584166666666BA6828419A9999595F0F5841CDCCCCCCAE6828419A9999995F0F584100000000456828419A9999F9610F584100000000CE67284133333393640F5841666666667A67284133333373660F5841CDCCCCCC7A67284166666666660F5841');
INSERT INTO commune VALUES ('30190', 'Saint-Genies-de-Malgoires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
INSERT INTO commune VALUES ('30320', 'Bezouce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
INSERT INTO commune VALUES ('30210', 'Cabrieres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
INSERT INTO commune VALUES ('30190', 'Saint-Chaptes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
INSERT INTO commune VALUES ('30128', 'Garons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
INSERT INTO commune VALUES ('30132', 'Caissargues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
INSERT INTO commune VALUES ('30980', 'Saint-Dionisy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
INSERT INTO commune VALUES ('30320', 'Saint-Gervasy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
INSERT INTO commune VALUES ('30350', 'Mauressargues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
INSERT INTO commune VALUES ('30190', 'La Calmette', '30061', '30', '01060000206A08000001000000010300000001000000780200003333333335832841CDCCCCACFC145841000000003583284166666606F5145841000000003583284133333393E9145841CDCCCCCC36832841333333B3DD1458410000000039832841333333F3D2145841000000003B832841333333D3CC145841000000003E832841CDCCCCCCBE145841666666663A832841666666A6B1145841CDCCCCCC36832841333333F3A51458416666666636832841CDCCCCECA41458413333333336832841666666E6A3145841CDCCCCCC2C832841000000C0A31458419A99999921832841666666A6A3145841333333330D83284133333373A314584100000000FC82284133333373A314584166666666E482284100000040A31458419A999999DF82284133333333A314584166666666B682284100000000A3145841CDCCCCCCA7822841666666E6A2145841CDCCCCCC91822841000000C0A2145841CDCCCCCC7F82284100000020A21458410000000065822841000000C0A31458419A999999478228419A999959A5145841CDCCCCCC2382284100000000A7145841CDCCCCCC0282284133333373A8145841CDCCCCCCE3812841666666A6A914584133333333C7812841333333B3AA14584100000000A1812841000000A0AB145841CDCCCCCC81812841000000A0AC1458416666666660812841333333F3AD14584133333333418128419A999999AF145841333333333B812841333333F3AF1458416666666624812841CDCCCC4CB114584166666666018128419A9999D9B214584166666666EB802841CDCCCCECB3145841CDCCCCCCCD802841CDCCCC6CB514584100000000B2802841CDCCCC8CB6145841CDCCCCCC8A802841CDCCCCACB714584133333333E27F2841333333B3C114584133333333D27F284133333373C114584166666666C77F284133333393C114584100000000B97F2841000000A0C114584133333333A27F284100000080C114584166666666917F284133333353C114584133333333837F2841CDCCCC2CC114584100000000607F284133333313C114584100000000517F28419A999939C1145841CDCCCCCC3D7F284100000060C1145841333333331A7F28419A9999F9C114584133333333F37E284166666686C214584100000000DB7E2841333333F3C214584100000000C37E2841CDCCCC2CC31458419A999999AF7E284166666666C314584166666666A47E2841333333D3C3145841333333339E7E284166666606C41458419A999999887E2841CDCCCC6CC5145841CDCCCCCC797E284133333373C614584100000000747E2841333333D3C6145841CDCCCCCC627E284100000060C81458419A999999317E2841CDCCCC2CCC14584100000000FF7D284100000020D01458419A999999937D284166666646D1145841CDCCCCCCDA7C28419A999939D314584133333333D27C2841CDCCCC4CD314584100000000677C284133333373D41458419A999999397C284166666646D7145841CDCCCCCCF17B284166666626DC14584133333333827B2841000000E0E3145841CDCCCCCC367B2841CDCCCC0CE9145841CDCCCCCCF07A2841CDCCCC0CEE14584100000000337A284133333313FB14584166666666087A28419A9999F90015584166666666B3792841CDCCCCACEC145841CDCCCCCCA5792841333333B3EA145841CDCCCCCCA17928419A999919EA145841333333338C79284133333333E2145841333333337979284133333353DB145841CDCCCCCC74792841333333D3D91458416666666661792841CDCCCC6CD1145841CDCCCCCC4C79284100000000C9145841666666663279284100000060BF1458419A9999992B79284166666606BC145841CDCCCCCC2979284133333313BB145841000000002A79284166666666B9145841666666662B792841CDCCCC2CB5145841CDCCCCCC2879284133333393B11458410000000028792841333333F3AD1458419A999999287928419A999919AC145841666666662B792841CDCCCCACA8145841666666662C79284166666626A7145841333333332B7928419A9999F9A3145841CDCCCCCC267928419A9999F99D145841666666661E792841000000C0961458413333333319792841000000E091145841CDCCCCCC11792841CDCCCCEC8E1458419A9999990E7928419A9999998D14584166666666FE782841333333D38A14584100000000F0782841333333938714584166666666E77828416666668683145841CDCCCCCCE4782841333333538214584166666666DC782841333333737D14584100000000DC782841CDCCCC6C7B14584133333333DC782841666666867A14584166666666DC782841333333537814584133333333DB7828419A9999797514584166666666D1782841CDCCCCEC701458419A999999C0782841000000C06A1458419A9999999F782841333333F3631458413333333387782841CDCCCCCC5C1458410000000080782841CDCCCC6C5A145841000000007F7828419A999939581458419A99999983782841333333D35414584133333333917828419A9999D9501458419A99999993782841333333934F1458410000000097782841333333F34D1458410000000098782841666666064C14584166666666987828419A9999794A14584100000000967828416666660648145841000000008D782841CDCCCC6C441458419A99999974782841333333B33E145841333333336278284166666686391458419A9999995A7828416666664636145841CDCCCCCC4B7728419A9999791F14584166666666CC7628419A9999791D145841CDCCCCCC37762841666666261B1458413333333303762841333333531A1458419A999999847528413333335318145841000000007C752841333333331814584100000000A0742841000000C014145841CDCCCCCCBD7328413333333311145841CDCCCCCC8E73284100000060041458413333333363732841CDCCCC8CF813584166666666277328419A999939E81358410000000007732841CDCCCC6CDF1358419A999999ED72284100000080D81358419A999999D4722841000000A0D113584166666666C172284133333373CC135841333333339F72284166666626C31358419A9999998B72284100000040C1135841666666667472284166666686BF135841CDCCCCCC6272284133333333BD1358419A9999995372284133333333BB1358416666666644722841CDCCCCACB913584100000000317228419A9999F9B613584166666666647128419A999959A01358413333333361712841CDCCCC2CA2135841000000005E71284100000060A313584166666666F670284100000020E11358410000000097702841000000001A1458419A9999998E702841000000E01E145841666666666E7028419A999999311458416666666667702841000000A0351458419A99999960702841CDCCCCAC39145841666666665F702841666666463A145841666666661B702841333333D361145841666666661A7028410000006062145841CDCCCCCC167028419A999959641458419A999999FA6F2841666666C67414584100000000F86F28419A999939761458419A999999E76F2841333333B37F14584100000000D46F2841666666268B145841CDCCCCCCCC6F2841333333338F145841CDCCCCCCA56F28419A9999D9A514584133333333536F2841CDCCCCCCD514584166666666316F284133333353E9145841CDCCCCCC2E6F2841CDCCCCCCEA1458419A999999246F2841666666E6F0145841CDCCCCCCE46E28419A9999B915155841CDCCCCCCD86E2841666666C61C15584100000000D46E2841666666861F15584133333333BD6E28419A9999D92C1558419A999999BB6E2841CDCCCCAC2D155841666666669B6E28413333335340155841666666668B6E28419A9999994915584133333333716E28419A9999D958155841CDCCCCCC536E2841CDCCCCCC691558419A999999486E28413333335370155841666666663A6E2841333333937615584166666666376E284166666626791558419A9999991C6E2841CDCCCC0C78155841CDCCCCCCED6D2841666666268D15584100000000DA6D2841666666269615584100000000D56D2841000000E097155841666666669A6D28419A999959AC15584166666666F36D28419A9999F9AE155841CDCCCCCC716E28419A999999B41558419A999999566E28419A9999D9C2155841CDCCCCCC486E284100000020CA15584133333333296E2841CDCCCC8CDA15584133333333E56D28419A9999F9FB15584133333333CE6D284166666646FA155841CDCCCCCCD76D2841CDCCCC0C0316584100000000EF6D2841666666661816584166666666DD6D2841333333F31716584166666666C06D2841333333D32D165841CDCCCCCCBB6D284133333373311658419A999999D76D28419A99997930165841CDCCCCCCCF6D2841CDCCCC8C3416584100000000C16D2841CDCCCC2C3C16584166666666BB6D2841000000004016584166666666C16D2841666666A651165841666666667E6D2841CDCCCCCC7516584133333333856D2841333333137A165841CDCCCCCC826D28419A9999997D16584100000000656D28419A99991988165841333333335B6D2841CDCCCC6C8F165841000000005E6D28416666666691165841CDCCCCCC4C6D2841333333139616584100000000376D2841666666069E16584133333333306D2841333333D3A2165841CDCCCCCC2B6D28419A999979A61658419A9999992B6D2841000000A0AB1658419A9999992E6D284133333333B0165841000000002F6D2841666666A6B416584100000000296D28419A9999F9BA16584100000000226D28419A999979C1165841000000001B6D284100000020C6165841CDCCCCCC0F6D284133333333CB16584166666666066D28419A9999B9CF165841CDCCCCCCFD6C28419A999939D516584133333333FC6C284166666606DB16584133333333026D2841666666E6DF165841CDCCCCCC0B6D284133333333E416584100000000146D284133333353E7165841CDCCCCCC366D2841666666A6EF165841CDCCCCCC546D2841CDCCCC2CF4165841666666666A6D28419A999919F81658419A9999997C6D284133333373FD16584100000000876D2841000000800217584100000000966D28416666666608175841666666669D6D28416666660614175841CDCCCCCC9B6D2841000000601817584133333333926D2841666666061B1758419A999999F16D2841333333932317584100000000386E2841CDCCCC8C2C17584133333333916E2841000000E03417584166666666F36E2841333333533E175841CDCCCCCC0B6F2841CDCCCC0C49175841CDCCCCCCDE6F28419A999919481758419A999999AE6F2841000000605217584166666666AC6F2841333333B354175841CDCCCCCCAD6F2841333333335617584166666666A26F284100000060561758419A999999706F2841000000C05717584166666666426F2841666666A658175841666666660D6F28419A9999F958175841333333330C6F28419A9999F95817584133333333E96E284166666666591758419A999999D46E2841000000005A1758419A999999C66E2841333333F35A1758419A999999BB6E2841000000C05B17584166666666AE6E2841666666865C17584100000000A06E2841333333335D175841000000008F6E2841333333D35D175841000000007F6E28419A9999595E175841CDCCCCCC706E2841CDCCCCCC5E175841CDCCCCCC646E2841666666265F175841CDCCCCCC586E28419A9999795F175841CDCCCCCC4A6E2841000000C05F17584166666666396E28419A9999D95F17584166666666316E2841333333935F175841333333332A6E28419A9999595F17584100000000226E2841000000205F1758419A999999196E2841333333135F1758419A999999016E2841666666E65E17584133333333F96D2841000000E05E17584166666666D36D28419A9999798A17584100000000696D2841CDCCCC2CBF175841333333333B6D28419A999979CB17584100000000426D2841CDCCCCECCC175841333333334C6D28419A999979CE17584133333333536D28419A9999F9CF1758419A999999596D284100000040D2175841CDCCCCCC606D2841333333B3D517584133333333686D2841666666A6D81758419A9999996E6D2841333333D3DA1758419A999999756D2841000000C0DC175841CDCCCCCC7F6D2841333333F3DE175841000000008E6D284100000080E11758419A9999999E6D284100000060E417584166666666A76D2841000000C0E517584100000000B06D2841CDCCCCECE61758419A999999BA6D28419A999919E81758419A999999CB6D284100000080E9175841CDCCCCCCE06D2841000000E0EA1758419A999999076E284133333373ED175841CDCCCCCC3A6E2841666666A6F0175841CDCCCCCC736E28419A999959F417584133333333916E284133333353F61758419A999999A36E2841CDCCCC8CF717584133333333B26E284100000060F8175841CDCCCCCCC26E284166666606F917584133333333DA6E2841333333D3F917584133333333F16E2841CDCCCC8CFA175841666666661D6F2841000000C0FB17584166666666496F2841666666E6FC17584133333333696F2841333333B3FD175841333333338D6F284100000060FF1758419A999999BF6F28419A9999790218584133333333FE6F28413333333307185841CDCCCCCC28702841333333530B185841000000003B702841666666460D185841CDCCCCCC1E702841333333331618584166666666F66F28419A9999992318584166666666D66F2841000000802E185841CDCCCCCCBE6F2841666666A636185841CDCCCCCC956F2841CDCCCCCC4518584100000000776F2841CDCCCCEC4F18584133333333506F28419A9999995D1858419A999999156F2841000000407018584133333333D86E28413333333385185841CDCCCCCCCB6E2841000000E08818584100000000A26E2841000000E097185841333333338B6E28419A9999799F18584133333333716E284166666666A818584133333333626E2841000000A0AD1858419A9999992C6E284133333353BF1858419A9999991C6E2841666666C6C418584166666666166E2841333333D3C61858419A999999066E2841CDCCCC0CCC1858419A999999E16D284100000020D618584166666666AB6D284166666666E41858419A999999A36D284133333373E61858419A999999686D284100000020F618584133333333616D284100000020F818584100000000356D28419A9999D903195841666666660C6C2841666666461C19584100000000086C2841666666A61D1958419A999999FD6B2841666666E61E195841CDCCCCCCED6B2841666666662019584100000000DB6B2841CDCCCC0C2219584133333333C26B2841CDCCCC6C2419584133333333B16B28419A9999F925195841CDCCCCCCA06B28416666666627195841666666668B6B28416666662629195841000000007B6B2841CDCCCCCC2A195841666666666D6B28419A9999392C195841666666665C6B2841333333532E1958419A999999536B2841CDCCCC8C2F19584133333333406B28416666666631195841333333332E6B28419A9999F932195841333333331B6B28419A9999B93319584166666666086B2841666666A6341958419A999999EC6A2841CDCCCC0C36195841CDCCCCCCD56A28419A9999393719584166666666C26A2841000000403819584166666666B36A2841333333333919584166666666A36A2841333333F33919584133333333976A2841333333733A19584166666666886A2841666666063B19584133333333796A2841000000403B195841666666666A6A2841CDCCCC6C3B195841CDCCCCCC5A6A2841333333933B195841333333334C6A28419A9999F93B1958419A9999993D6A28419A9999B93C1958419A9999992D6A28419A9999B93D195841CDCCCCCC186A2841333333933F19584100000000046A2841333333F34019584166666666ED6928413333339342195841CDCCCCCCD8692841CDCCCC2C4419584100000000C5692841333333D34519584100000000AB692841333333F3471958416666666697692841333333B3491958416666666695692841CDCCCCCC49195841CDCCCCCC99692841666666A64A195841666666669E6928419A9999F94B195841CDCCCCCC9F692841CDCCCC2C4D195841CDCCCCCC9F692841333333534E195841666666669E692841333333D34F195841000000009C6928419A99991952195841666666669A6928419A999999551958410000000099692841CDCCCC8C591958410000000099692841000000205B195841666666669A692841333333B35D195841CDCCCCCC9C692841000000A05F19584100000000A2692841CDCCCC2C62195841CDCCCCCCA3692841CDCCCC2C63195841CDCCCCCCA5692841CDCCCCEC6419584166666666A7692841333333336719584100000000A9692841000000A0691958419A999999AA692841CDCCCC6C6C1958419A999999AA692841666666466F19584100000000AB6928419A999979711958419A999999AB692841666666267319584133333333AC692841CDCCCCCC741958419A999999AD6928410000008076195841CDCCCCCCAF69284100000000781958419A999999B2692841000000207B19584133333333B7692841CDCCCCAC7E19584166666666BD692841000000E0831958419A999999BF692841333333938519584133333333C06928419A9999B98619584133333333C0692841333333F38819584100000000C0692841000000408E1958419A999999BF692841666666E691195841CDCCCCCCBF692841333333139519584166666666BF692841CDCCCCAC971958419A999999BF692841CDCCCC0C9919584100000000C0692841666666E69A19584100000000C1692841000000A09C19584166666666C2692841CDCCCC2C9F1958419A999999C56928419A999919A219584100000000CF692841CDCCCC4CA219584133333333E4692841666666C6A21958419A999999DD692841666666E6CF1958419A999999E06928419A999999D41958419A999999026A284133333353DA195841333333331B6A284166666666DF1958419A999999116A284166666606E1195841333333330A6A2841CDCCCC2CE219584166666666F66928419A999959E5195841CDCCCCCCD969284166666686E919584166666666B869284133333353EE19584166666666676928419A999959F8195841333333334D6928419A999999FB19584133333333666A284133333333181A5841CDCCCCCC106C284100000080421A584166666666646D2841000000E0651A584133333333ED6D284166666606721A584100000000706D284133333333461A584166666666536D284100000080381A584100000000416D284166666646311A584100000000976D284133333373291A5841333333331E6E2841333333D31E1A58419A999999E36E2841CDCCCC8C0E1A5841CDCCCCCC216F2841666666060B1A58419A999999766F284166666666091A5841CDCCCCCCB16F2841666666E60A1A5841333333333E70284100000080121A5841CDCCCCCCB2702841CDCCCCCC021A584133333333A470284166666606F81958419A999999AD7028419A999999EF19584133333333CC7028419A9999F9E619584166666666EF702841CDCCCCACD91958419A999999EB7028419A9999B9D6195841CDCCCCCCD8702841000000E0D4195841CDCCCCCCF8702841CDCCCC4CD019584100000000F0702841333333F3CB195841CDCCCCCCB9702841333333B3C61958419A999999B5702841666666E6B2195841CDCCCCCC9D7028419A9999F9AA195841000000002F712841666666C6A119584133333333F1712841CDCCCCAC991958419A99999975722841000000809719584100000000BE722841CDCCCC8C98195841CDCCCCCCF27228419A9999B99B1958419A9999991D732841CDCCCC6CA2195841333333332A73284166666646A31958413333333343732841333333D3A31958410000000061732841CDCCCCECA21958419A999999BA732841666666C6A0195841CDCCCCCCE47328419A9999F99E1958413333333319742841CDCCCC8C9A195841CDCCCCCC457428419A9999F9961958419A9999997374284133333373911958410000000087742841333333B38E1958416666666692742841666666868D195841666666669A742841333333938C1958419A999999A1742841333333B38B195841CDCCCCCCA7742841000000A08A195841CDCCCCCCAF742841666666E688195841CDCCCCCCB674284100000080871958419A999999BD74284133333353861958419A999999C5742841333333338519584100000000CF742841333333F383195841CDCCCCCCD6742841666666E68219584100000000E1742841333333938119584133333333EB742841333333B38019584133333333F5742841333333138019584100000000FF742841CDCCCC6C7F1958413333333307752841333333D37E1958419A9999990E752841333333137E19584133333333187528419A9999197D195841666666661F752841000000007C1958410000000028752841333333B37A19584166666666307528419A999999791958419A99999938752841666666667819584100000000417528410000004077195841CDCCCCCC4C752841000000E07519584166666666567528419A999999741958416666666661752841666666867319584166666666697528419A9999B972195841CDCCCCCC72752841000000E071195841CDCCCCCC7E752841CDCCCCCC70195841CDCCCCCC8A752841CDCCCCEC6F1958419A99999998752841666666066F1958419A999999A4752841CDCCCC4C6E19584100000000B2752841000000606D19584133333333BF7528419A9999596C19584133333333CB752841CDCCCC2C6B19584166666666D8752841666666E66919584166666666E8752841666666866719584100000000F67528410000002065195841000000000B762841CDCCCCEC611958419A999999157628419A99991960195841CDCCCCCC1D7628419A9999395E19584166666666297628419A9999B95B1958410000000032762841CDCCCC8C59195841333333333A7628419A999919571958419A999999417628419A9999B9541958413333333347762841666666C652195841333333334C762841000000A0501958416666666652762841333333D34E1958410000000057762841CDCCCC0C4D195841000000005C762841666666264B1958419A9999996A76284133333353461958419A9999996A7628416666668645195841333333336B76284166666686441958419A9999996B76284100000060431958419A9999996C7628416666668642195841666666668E762841000000003719584100000000A7762841CDCCCC2C3319584166666666BD7628416666666631195841CDCCCCCCD876284133333333301958413333333326772841000000402F195841666666665A772841666666062E195841333333337D772841000000C02A195841CDCCCCCC39782841666666061F1958419A999999717828419A99997920195841CDCCCCCC827828410000002020195841666666668E78284133333313201958419A99999995782841000000801F195841CDCCCCCC23792841CDCCCC8C2619584166666666CA79284133333313301958419A999999187A28413333333339195841333333334F7A2841000000E0351958419A9999997D7A2841333333B33719584166666666FA7A28419A9999B937195841CDCCCCCC927B2841CDCCCCAC3A19584166666666B77B2841333333D33C19584166666666117C2841333333D33D195841CDCCCCCC457C2841000000E04019584100000000437D2841666666864119584100000000F77D2841CDCCCC6C4019584100000000EB7E2841666666263C195841333333333C7E2841333333B3291958419A999999937C2841333333D3F318584133333333ED7B2841000000A0DF185841CDCCCCCCDF7B2841CDCCCC2CDF1858419A999999D17B284100000040DE185841CDCCCCCCC37B2841000000A0DC1858419A999999B27B28419A999999DA18584133333333907B284100000000D61858419A999999677B28419A999959D118584166666666547B284166666646CE18584133333333467B284133333373CB18584100000000357B284133333353C818584100000000237B2841666666E6C4185841000000000E7B2841000000C0C118584100000000F07A2841CDCCCC2CBE185841CDCCCCCCD47A284100000060BB1858419A999999AB7A284100000040B7185841333333338F7A2841CDCCCCCCB4185841CDCCCCCC6C7A2841666666E6B118584133333333567A28419A9999B9AF18584100000000447A2841CDCCCCCCAD18584133333333377A28416666668678185841CDCCCCCC1C7A28413333333311185841333333337B7A284100000000D817584133333333D07A28419A999939B517584133333333E27A284166666666AD17584100000000017B2841333333F3A417584166666666A57C2841000000804E17584133333333F97C2841666666463A17584166666666167D284100000040301758419A999999127D2841CDCCCC8C1B175841000000002D7D2841666666861C17584166666666417D2841666666461D175841666666668B7D2841CDCCCC6C0417584166666666337E284133333313D3165841000000006C7E2841CDCCCC0C9B16584166666666937E28410000004092165841CDCCCCCCE27E2841CDCCCCEC8B165841CDCCCCCC067F28419A999919801658419A999999527F2841333333536A165841666666664D7F28419A99997963165841000000006F7F2841CDCCCC0C621658419A999999867F2841000000406116584133333333A07F28416666666660165841CDCCCCCCB97F2841333333335F16584166666666C77F2841666666665E1658419A999999D77F2841333333535C1658419A999999E87F28419A99993959165841CDCCCCCCEC7F2841333333535816584133333333FA7F28416666668655165841CDCCCCCC0F8028410000006052165841CDCCCCCC1C80284100000000511658419A9999992A802841CDCCCCCC4F1658416666666636802841CDCCCC6C4F1658419A99999940802841CDCCCCAC4D1658419A999999418028419A9999D94A1658413333333341802841000000804916584166666666408028410000002042165841CDCCCCCC408028419A9999793F1658419A9999994180284100000040381658413333333341802841CDCCCC8C36165841000000003E802841CDCCCC6C3516584166666666388028419A9999B9341658419A9999994E802841000000C029165841CDCCCCCC90802841CDCCCC8C141658419A999999BD802841333333130A16584166666666FA802841CDCCCCACFC1558419A9999990A81284100000020F9155841000000004A812841CDCCCC4CEE1558419A9999994B812841CDCCCC0CDF15584166666666718128419A999919D91558410000000096812841333333D3CD15584100000000BF812841333333D3C1155841000000009B812841333333D3C015584100000000CE812841CDCCCCCCAB15584133333333E081284100000000AB1558416666666648822841CDCCCC8CA61558416666666645822841CDCCCC8CA21558416666666640822841333333939B1558419A99999993822841333333537D155841666666668F822841CDCCCC6C7A15584100000000868228419A999959741558419A999999778228419A9999996C1558413333333369822841CDCCCC2C641558419A999999618228413333331362155841CDCCCCCC5B82284133333353601558419A99999954822841000000605A1558416666666642822841CDCCCCCC2F15584166666666418228419A9999592D155841CDCCCCCC3B8228419A999939201558413333333339822841666666461A15584100000000388228413333337317155841000000003A8228419A9999B90E15584133333333E88228419A99993902155841000000000783284100000000001558419A9999991D83284100000060FE1458413333333335832841CDCCCCACFC145841');
INSERT INTO commune VALUES ('30230', 'Rodilhan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
INSERT INTO commune VALUES ('30350', 'Moulezan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
INSERT INTO commune VALUES ('30870', 'Saint-Come-et-Maruejols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
INSERT INTO commune VALUES ('30540', 'Milhaud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
INSERT INTO commune VALUES ('30230', 'Bouillargues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
INSERT INTO commune VALUES ('30350', 'Montagnac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
INSERT INTO commune VALUES ('30190', 'Montignargues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
INSERT INTO commune VALUES ('30190', 'Sauzet', '30313', '30', '01060000206A08000001000000010300000001000000CC01000033333333C354284133333393E31B5841666666660B5528419A9999F9DA1B5841000000003D5528419A999919D51B58419A99999961552841666666C6D01B58419A999999A0552841CDCCCCCCD71B5841CDCCCCCCB955284166666606D61B584100000000DD5528419A999979D41B5841CDCCCCCCE5552841333333B3D31B58419A999999EB55284166666666D31B5841CDCCCCCC0A562841000000C0D11B5841666666661F5628419A999979D01B5841666666662E56284133333353CF1B5841CDCCCCCC36562841CDCCCCACCE1B5841CDCCCCCC65562841000000E0CC1B5841666666667856284166666646CC1B58419A9999998C562841CDCCCC4CCB1B584166666666AB5628419A999979C91B5841CDCCCCCCD256284133333333C71B584100000000F056284100000040C51B584100000000FE562841CDCCCC4CC41B58419A9999990F572841CDCCCCCCC21B5841CDCCCCCC18572841666666E6C11B58413333333347572841000000A0BD1B5841000000006D57284133333353B91B58410000000090572841CDCCCCECB41B58419A999999BF57284100000080AE1B584100000000DD572841CDCCCC0CAB1B58413333333301582841CDCCCC2CA61B5841CDCCCCCC2C582841000000E09F1B5841CDCCCCCC5D582841000000609A1B5841666666667C5828419A9999B9961B5841666666669058284166666666941B5841CDCCCCCCA158284100000020921B584166666666AE582841CDCCCC6C901B584133333333BB582841333333938E1B584100000000C6582841000000808D1B5841CDCCCCCCD4582841666666268C1B58419A999999E3582841666666A68A1B584133333333F7582841CDCCCC4C881B58419A99999906592841CDCCCCEC851B5841CDCCCCCC1259284166666686831B58413333333321592841666666A6801B5841333333332C592841666666267E1B58419A999999355928419A9999F97B1B5841CDCCCCCC38592841333333537A1B5841333333335C592841333333737A1B5841CDCCCCCC9C5928419A999979761B58419A9999991A5A284166666626691B584133333333285A284166666646671B58419A9999993F5A2841CDCCCC8C631B58419A999999535A2841000000A0601B584133333333655A2841000000405E1B58419A999999795A2841CDCCCC0C5C1B5841333333338D5A2841000000005A1B5841CDCCCCCC9D5A2841333333D3571B58419A999999AB5A284133333373551B584133333333B35A284133333333541B58419A999999C25A284133333373521B5841CDCCCCCCD05A2841CDCCCC2C511B5841CDCCCCCCEF5A28419A9999394F1B58419A999999125B2841CDCCCCCC4C1B5841666666663F5B2841CDCCCC6C491B5841CDCCCCCC4B5B2841666666A6481B584166666666545B28419A999959481B584133333333605B284133333333481B58419A999999775B284133333313481B58419A9999997E5B2841CDCCCC0C4C1B5841666666668A5B2841000000E0531B5841666666669B5B2841CDCCCC4C531B5841CDCCCCCCA95B2841666666E6521B584166666666B75B28419A999939521B5841CDCCCCCCCD5B2841CDCCCC6C501B58419A999999EB5B2841333333934D1B58419A999999FB5B28419A9999994B1B5841000000006F5C2841000000003F1B584166666666805D2841333333D32F1B584133333333635E284166666686281B584166666666EC5E2841CDCCCC6C251B58419A999999A05F2841CDCCCC6C221B5841666666666C642841333333732D1B58419A999999D5642841000000E02E1B58419A999999DF6C2841CDCCCC4C611B584166666666EC6D2841CDCCCCAC681B584166666666676F2841333333B3711B584100000000416F2841000000E05F1B5841CDCCCCCCD96D284166666686C61A58419A999999756D2841666666A6C11A584133333333D46B284166666646AB1A584100000000686A2841000000C0961A58419A999999F3692841CDCCCC4CA21A58419A999999D56928419A999959A21A5841666666662A67284166666666601A5841000000009D662841CDCCCC0C521A584100000000A4642841666666261F1A5841CDCCCCCC4B632841666666C6021A5841333333331163284133333373071A584166666666EA622841333333730A1A584166666666C8622841666666060D1A584166666666AD622841666666460F1A5841666666668D62284166666606121A5841666666666E622841CDCCCC0C151A58419A99999958622841CDCCCC0C171A58416666666645622841CDCCCCEC181A5841CDCCCCCC1F622841CDCCCC0C1D1A5841CDCCCCCCFD612841CDCCCC2C211A584133333333D86128419A9999D9251A58410000000067612841CDCCCC0C1B1A584133333333C660284133333333121A58413333333324602841333333530E1A58413333333322602841333333330F1A5841333333331D6028419A9999B90F1A58416666666617602841666666E60F1A5841CDCCCCCC11602841CDCCCCEC0F1A58419A99999908602841666666C60F1A58419A999999FA5F2841333333730F1A5841CDCCCCCCDD5F2841333333F30E1A584166666666CC5F2841CDCCCCAC0E1A58419A999999AB5F2841CDCCCC4C0E1A58419A999999825F28419A9999190E1A58419A999999685F28419A9999390E1A5841CDCCCCCC535F2841CDCCCC0C0E1A58419A999999445F2841666666460E1A58419A999999355F28419A9999990E1A5841CDCCCCCC245F2841666666E60E1A584133333333135F2841333333330F1A584166666666035F28419A9999590F1A584100000000DB5E28419A9999D90F1A584100000000B75E28419A999959101A58419A9999999E5E284133333373101A584133333333925E2841CDCCCC8C101A58419A9999997A5E2841000000A0101A5841CDCCCCCC6D5E28419A9999B9101A58419A9999995A5E28419A9999D9101A5841666666664C5E2841666666E6101A58419A9999993C5E2841CDCCCCEC101A5841CDCCCCCC2F5E2841CDCCCCEC101A5841666666661E5E2841CDCCCC0C111A584100000000095E284133333333111A584133333333F35D2841CDCCCC6C111A58419A999999E25D2841CDCCCCEC111A584166666666D45D284166666666121A5841CDCCCCCCBD5D284133333353131A584166666666AD5D2841CDCCCC0C141A5841666666668E5D284133333373151A5841666666666E5D2841CDCCCC2C171A58419A9999995F5D2841333333D3171A5841666666664E5D28419A999979181A584166666666335D2841CDCCCCEC1A1A584166666666165D2841666666461D1A5841CDCCCCCC0E5D28419A9999D91D1A58419A999999095D2841CDCCCCAC1D1A584100000000025D2841666666661C1A5841CDCCCCCCCB5C28419A999999131A584133333333B85C2841333333B3101A584133333333B15C284100000020101A584166666666A35C2841CDCCCCAC0F1A584166666666945C2841000000800F1A584133333333815C2841666666860F1A5841CDCCCCCC6E5C2841000000800F1A584166666666545C28419A9999190F1A5841333333331D5C28419A9999990D1A584166666666055C2841333333930C1A584166666666F15B2841000000A00B1A584100000000DD5B28419A9999990A1A584166666666C65B2841CDCCCC4C091A584100000000B05B28419A9999B9071A584133333333A55B2841CDCCCC8C051A584166666666925B284133333353021A5841666666668D5B28419A999999FF195841666666665C59284166666646FC195841CDCCCCCCAF57284133333313FA195841CDCCCCCC985628419A9999F9F5195841CDCCCCCCCA552841333333D3011A584133333333B85528419A999919011A584133333333A35528419A999999FF19584100000000825528419A999979FC195841000000006C552841666666A6FA195841000000005A5528419A999979F9195841333333334455284133333373F8195841000000002D5528419A9999B9F71958419A9999991155284133333313F719584166666666FE542841000000C0F619584166666666E9542841333333B3F61958419A999999D95428419A9999B9F619584166666666D0542841333333B3F619584133333333C454284100000080F619584133333333B95428419A999959F619584166666666AD54284100000060F619584100000000975428419A999999F61958410000000082542841CDCCCCECF61958419A9999996D54284166666646F71958419A9999995A542841CDCCCC8CF719584166666666475428419A9999D9F7195841000000002F5428419A999939F81958419A9999991954284133333393F81958410000000008542841666666E6F8195841CDCCCCCCF953284166666626F919584133333333EF53284166666626F919584100000000DE53284166666606F919584166666666D15328419A9999D9F819584100000000C453284100000080F819584133333333B753284100000000F8195841CDCCCCCCA2532841CDCCCC0CF7195841666666669053284100000020F6195841000000007F532841CDCCCC4CF51958419A9999996D53284133333393F4195841CDCCCCCC5D532841333333D3F31958419A9999994B5328419A9999F9F21958410000000032532841000000E0F11958413333333326532841CDCCCC2CF11958419A9999991A53284100000060F0195841000000000D532841CDCCCC8CEF19584100000000F9522841666666C6EE19584100000000ED522841CDCCCC0CEE19584133333333E35228419A999939EC19584100000000D7522841CDCCCCCCE819584100000000CE522841CDCCCCCCE6195841CDCCCCCCC4522841666666A6E41958419A999999BB5228419A999999E3195841CDCCCCCCAC52284133333353E3195841CDCCCCCCA052284100000040E31958413333333396522841CDCCCCACE3195841333333338E52284133333313E4195841333333338452284166666606E5195841666666667352284100000000E7195841000000006752284100000060E8195841666666666152284133333313E9195841CDCCCCCC59522841666666C6E91958419A9999994C52284100000040EA195841666666663F52284166666686EA1958410000000032522841666666A6EA1958413333333326522841333333B3EA1958419A9999991A522841666666A6EA195841CDCCCCCC0D522841CDCCCC6CEA195841CDCCCCCC005228419A999919EA1958419A999999EF5128419A9999D9E919584166666666E3512841666666C6E91958419A999999D3512841000000A0E91958419A999999BC512841CDCCCC2CE919584133333333AC512841CDCCCCECE81958410000000096512841333333B3E8195841CDCCCCCC895128419A999999E8195841CDCCCCCC7A51284100000080E81958416666666663512841000000A0E8195841CDCCCCCC1550284166666686EA195841CDCCCCCCBA4E2841666666C6F7195841CDCCCCCCA24E28419A9999F9F7195841000000008B4E2841CDCCCC6CF81958419A999999714E284166666606F919584133333333564E2841666666A6F919584133333333364E284100000000FD195841CDCCCCCC204E2841333333D3FD1958419A99999946432841CDCCCC2C6A1A5841333333330D442841CDCCCC0CA21A5841CDCCCCCC17442841666666C6A31A584166666666204428419A999959A61A584100000000284428419A999959AA1A58416666666632442841CDCCCC0CB01A58410000000040442841CDCCCC4CB51A5841CDCCCCCC4D4428419A9999F9B81A58410000000057442841666666C6BB1A584133333333604428419A9999D9BE1A5841333333336344284133333393C11A584100000000684428419A999959C41A58410000000071442841CDCCCC8CC61A58416666666680442841333333F3C81A5841000000008D442841CDCCCC4CCA1A5841CDCCCCCC9144284166666606CC1A5841CDCCCCCC9344284166666606CE1A5841333333339444284166666666D01A5841CDCCCCCC9544284166666626D31A5841CDCCCCCC9A442841CDCCCC4CD51A584133333333A444284133333353D71A584133333333B744284166666666D91A58419A999999C74428419A9999D9DA1A584166666666D64428419A9999F9DC1A584133333333E24428419A9999B9DF1A584166666666E9442841CDCCCC2CE21A584133333333F044284133333333E51A5841CDCCCCCCF8442841000000C0E71A584100000000034528419A999939EA1A5841000000001045284166666686EC1A5841000000002245284166666606EE1A5841000000002F4528419A9999F9EF1A58416666666647452841666666C6F21A5841CDCCCCCCF7452841333333B3FE1A58419A999999324628419A999979041B5841CDCCCCCC6F46284100000060091B5841333333339E462841666666460E1B5841333333330C4728419A999919181B58413333333317472841CDCCCCCC181B5841000000007C472841333333F3211B58419A999999DA472841000000602B1B584100000000004828419A9999F92F1B5841CDCCCCCC1F482841CDCCCCEC331B5841333333338C4828419A9999993E1B584166666666DA48284166666626471B58419A999999E1482841CDCCCCEC471B584166666666EC482841333333D3481B584133333333F248284100000040491B58419A999999F9482841666666A6491B5841CDCCCCCC00492841666666464A1B5841000000000D492841666666064B1B584133333333184928419A9999B94B1B58419A999999264928419A9999B94C1B58419A99999937492841333333D34D1B5841CDCCCCCC41492841333333934E1B5841CDCCCCCC494928419A9999394F1B5841666666664E492841000000E04F1B5841666666665149284133333313501B5841CDCCCCCC554928419A999939501B58419A9999995B492841CDCCCC6C501B58413333333361492841CDCCCCAC501B58419A9999996A4928419A999959511B5841333333337349284133333313521B5841CDCCCCCC79492841333333B3521B58419A9999998349284100000060531B5841000000008D49284100000040541B58413333333397492841CDCCCC2C551B584133333333A9492841000000E0561B5841CDCCCCCCC44928419A999939591B584166666666E7492841CDCCCCEC5B1B5841000000006B4A2841666666E6651B58419A999999654A28419A999959661B5841CDCCCCCC614A284100000020671B5841CDCCCCCC5F4A284100000000681B58419A9999995F4A284166666646691B584166666666614A2841666666666A1B584100000000644A2841000000206B1B584100000000694A2841333333F36B1B5841CDCCCCCC704A2841333333D36C1B584100000000794A28419A9999596E1B5841000000007F4A2841000000406F1B5841CDCCCCCC844A284166666646701B5841CDCCCCCC8A4A2841CDCCCCCC701B584166666666984A2841CDCCCC2C721B584166666666A14A284100000060731B58419A999999A94A28419A999979741B584133333333B24A284100000040751B5841CDCCCCCCB64A2841CDCCCCEC751B5841CDCCCCCCBA4A2841666666C6761B58419A999999BE4A284100000080771B5841CDCCCCCCC14A2841333333F3771B58419A999999C74A284133333333781B5841CDCCCCCCD44A284133333393781B584166666666D94A2841CDCCCCCC781B584100000000E04A284100000000791B5841CDCCCCCCE44A284166666626791B5841CDCCCCCCEB4A2841CDCCCC6C791B584100000000F24A2841CDCCCCAC791B5841CDCCCCCCF74A28419A9999F9791B584100000000FD4A2841333333737A1B584166666666004B2841000000E07A1B584100000000044B2841666666467B1B58419A9999990B4B2841666666867B1B584100000000134B2841666666A67B1B5841000000001B4B2841333333F37B1B58419A999999254B2841CDCCCC2C7C1B5841CDCCCCCC2D4B2841666666267C1B5841CDCCCCCC354B2841666666267C1B5841CDCCCCCC3A4B2841CDCCCC4C7C1B584133333333404B2841333333B37C1B584166666666464B2841666666267D1B58419A999999544B2841333333B37D1B5841CDCCCCCC594B28419A9999D97D1B584166666666614B2841CDCCCC0C7E1B5841CDCCCCCC694B2841CDCCCC6C7E1B58419A9999996F4B28419A9999F97E1B584100000000764B2841666666A67F1B5841666666667B4B284100000080801B584100000000804B284133333313811B58419A999999864B284166666666811B5841666666668C4B28419A9999D9811B5841CDCCCCCC934B284133333373821B58419A9999999A4B284133333333831B58419A9999999E4B2841333333B3831B584133333333A24B2841CDCCCC4C841B584100000000AB4B284166666686851B5841CDCCCCCCB04B28419A999959861B58419A999999B84B284166666686871B584133333333BF4B2841CDCCCC4C881B584100000000C84B284166666646891B584166666666D04B2841CDCCCC2C8A1B584100000000D44B2841000000E08A1B584133333333D64B2841CDCCCC8C8B1B5841CDCCCCCCD94B2841333333338C1B584166666666DF4B2841333333D38C1B58419A999999E54B2841000000608D1B584100000000EB4B2841000000008E1B58419A999999F04B2841CDCCCC0C8F1B584100000000F54B2841CDCCCC4C901B5841CDCCCCCCF94B284166666646911B584166666666FE4B284133333333921B58419A999999044C2841666666A6931B5841CDCCCCCC0C4C28419A999999951B584133333333134C2841666666E6961B58419A999999174C2841666666A6971B584100000000204C284100000040981B584100000000244C28419A999979981B584166666666284C2841CDCCCC0C991B5841666666662C4C2841CDCCCC8C991B584166666666304C28419A9999D9991B58419A999999414D28419A999959B21B584166666666CC4D28419A999939C71B58419A999999E54D284133333353CA1B58419A999999FC4D28419A999959CC1B5841333333330D4E2841CDCCCC6CCD1B58419A999999194E28419A999939CE1B5841333333332A4E284133333373CF1B584133333333364E2841CDCCCCACD01B58419A999999404E284100000000D21B5841666666664C4E2841CDCCCC6CD31B5841CDCCCCCC574E284166666686D41B584100000000694E284166666686D51B584133333333754E2841000000A0D51B584166666666814E2841CDCCCCCCD51B584133333333934E28419A999979D51B584166666666A04E2841CDCCCC0CD51B584166666666B24E28419A999939D51B584100000000C54E2841CDCCCCACD51B584100000000DA4E2841CDCCCC8CD61B584100000000EF4E2841333333F3D71B584166666666C54F2841000000A0D41B584166666666C84F2841CDCCCC2CD51B58419A999999CB4F2841CDCCCC8CD51B584133333333CF4F2841333333B3D51B5841CDCCCCCCD54F2841000000E0D51B584166666666DE4F2841666666E6D51B584166666666E94F2841333333D3D51B584133333333F84F2841666666C6D51B5841CDCCCCCC0E5028419A9999B9D51B5841CDCCCCCC21502841000000A0D51B584166666666375028419A999959D51B5841CDCCCCCC455028419A999919D51B58410000000055502841000000E0D41B58419A9999996450284166666666D41B58413333333373502841CDCCCC0CD41B584166666666825028419A9999F9D31B5841CDCCCCCC90502841666666C6D31B5841CDCCCCCC98502841000000E0D31B58419A999999A150284166666606D41B584166666666A850284100000040D41B5841CDCCCCCCB2502841333333D3D41B584133333333BC502841666666E6D31B58419A999999BF502841000000C0D31B584166666666C550284133333393D31B584100000000CB502841000000A0D31B584100000000D3502841666666A6D31B584166666666EA50284133333333D31B58410000000009512841CDCCCC8CD21B58419A99999940512841000000C0D01B5841666666665A512841666666E6CF1B58419A999999A2512841CDCCCC2CCD1B584166666666DE512841CDCCCCECCB1B584166666666F252284133333373C21B584100000000EF522841CDCCCCECC41B584166666666EC5228419A999999C71B58419A999999EF522841000000C0CB1B5841666666668454284133333353DC1B584133333333C354284133333393E31B5841');
INSERT INTO commune VALUES ('30210', 'Ledenon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
INSERT INTO commune VALUES ('30190', 'La Rouviere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
INSERT INTO commune VALUES ('30730', 'Saint-Mamert-du-Gard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
INSERT INTO commune VALUES ('30730', 'Saint-Bauzely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
INSERT INTO commune VALUES ('30350', 'Domessargues', '30104', '30', '01060000206A080000010000000103000000010000007F010000CDCCCCCC8E2A284133333313131C5841CDCCCCCC652A2841666666A6191C584100000000A72A2841666666C62D1C584100000000BB2A2841333333B33F1C58419A999999EB2A284133333393471C584100000000E82A2841666666064A1C5841CDCCCCCCED2A28419A9999594D1C584100000000F62A28419A9999394F1C5841CDCCCCCCF72A2841333333B3501C584133333333F72A28419A9999B9531C584166666666F92A2841666666A6551C5841CDCCCCCCFD2A28419A9999D9571C584166666666032B2841CDCCCCEC5A1C5841CDCCCCCC0C2B2841CDCCCC2C5F1C5841CDCCCCCC0E2B28419A999919611C5841666666660D2B2841333333D3621C58419A999999092B284166666626641C58419A999999012B2841CDCCCCEC641C584100000000EE2A2841000000C06A1C584133333333E92A2841333333136D1C584166666666F32A284100000000701C58419A999999162B28419A999959741C584133333333282B284166666626781C58419A999999322B2841CDCCCCEC7B1C5841000000002E2B28419A9999397F1C58419A999999232B2841333333B3861C58419A9999990D2B2841000000E08C1C584166666666E62A2841CDCCCC2C971C5841CDCCCCCCD22A2841666666C69C1C584133333333D32A2841666666E6A21C58419A999999E02A2841CDCCCC4CAE1C58419A999999F02A2841CDCCCC0CBC1C584100000000F62A284133333333C21C5841CDCCCCCCF82A284133333333C91C58419A999999E82A28419A999999D91C584100000000E72A2841CDCCCCACE71C5841CDCCCCCCEE2A284166666606EC1C58419A999999FB2A2841CDCCCC4CF11C584166666666032B2841CDCCCCACF51C584133333333FF2A2841CDCCCCCC001D584166666666FA2A284133333353041D5841000000000F2B2841333333530B1D5841CDCCCCCC1B2B28419A999939131D5841666666662E2B2841666666A6141D584166666666482B2841666666A6161D58419A999999842B2841666666E6181D58419A999999A72B2841000000C0191D58419A999999B12B2841666666E61A1D5841CDCCCCCCBB2B28419A9999B91E1D5841CDCCCCCCD72B284166666666251D58419A999999F82B2841CDCCCC0C2A1D584100000000352C284166666606311D5841333333335D2C2841333333F3351D5841CDCCCCCC7B2C2841666666663E1D584100000000862C2841CDCCCCEC411D584133333333C02C2841CDCCCC0C4A1D584166666666CA2C2841000000404D1D5841CDCCCCCCCF2C284166666666531D584166666666D72C28419A999999561D584166666666F32C2841000000205C1D5841CDCCCCCC072D28419A999999641D58419A999999232D2841666666A6681D584166666666A62D284133333393761D58419A999999F12D28419A9999597C1D5841CDCCCCCC372E284133333313801D58419A999999B72E2841000000C0831D58419A999999732F2841000000608F1D5841333333337B302841CDCCCCCCA41D5841CDCCCCCCFE30284133333373AC1D584100000000C732284100000020C51D584166666666D43228419A999919C31D584166666666EA322841666666A6BF1D584133333333F232284166666686BE1D584166666666FC3228419A999979BD1D58419A9999990A3328419A999999BC1D5841666666662633284100000040BB1D58419A99999939332841CDCCCC4CBA1D58419A9999994F33284100000060B91D584166666666643328419A999999B81D58419A9999997133284133333333B81D58419A9999997C332841333333B3B71D5841666666668A332841CDCCCC2CB61D5841CDCCCCCC9033284166666666B41D5841666666669633284133333333B31D5841CDCCCCCC9F33284133333313B21D584166666666AC332841CDCCCCECB01D5841CDCCCCCCB533284100000000B01D584100000000C1332841333333F3AE1D584100000000CB332841CDCCCCECAD1D584166666666D6332841000000C0AC1D584100000000E13328419A999959AB1D584100000000EB332841666666C6A91D58419A999999F533284166666606A81D58419A9999990734284100000020A51D5841CDCCCCCC1134284100000020A31D584166666666193428419A9999F9A11D584166666666243428419A9999B9A01D58410000000034342841666666C69E1D58416666666661342841CDCCCCEC971D58419A9999999234284100000080921D584166666666BB342841CDCCCC2C901D58419A999999E2342841666666268E1D5841CDCCCCCC04352841666666E68A1D58419A9999992735284166666686881D5841CDCCCCCC5E3528419A999959861D5841CDCCCCCC68352841333333B3851D5841333333338635284100000020851D5841CDCCCCCC9035284100000000851D58419A99999909362841666666867D1D5841666666669C362841333333D3761D5841333333338E372841333333D36D1D584100000000B037284133333333601D58419A999999E73728419A9999F9531D5841666666669E38284133333393391D5841CDCCCCCCB73828419A9999F9381D584166666666CB382841000000E0371D5841666666660C3928419A9999D92F1D5841666666664E392841000000A0251D58419A9999996C39284133333313201D58413333333376392841666666E61B1D58416666666680392841666666C6161D5841CDCCCCCC8E392841333333D3151D5841CDCCCCCCEC39284100000000121D584133333333413A2841000000200E1D5841000000008D3A2841333333F30A1D584133333333A43A2841333333F3091D584100000000B43A284166666646091D5841CDCCCCCCE63A284100000060051D584133333333383B2841CDCCCC0CFE1C58419A999999823B284166666686F81C584166666666A93B284166666626F51C584100000000E83B28419A999959ED1C5841CDCCCCCC153C2841666666E6E71C5841000000003C3C2841000000C0E41C584166666666BD3C28419A999939DC1C584166666666C53C2841CDCCCC0CDB1C584166666666F43C284166666626D41C5841CDCCCCCC1F3D284166666686CE1C584100000000513D28419A9999D9C81C5841CDCCCCCC8A3D28419A999979C21C58419A999999AC3D284100000020BF1C584100000000C83D2841666666E6BC1C584166666666D73D2841CDCCCCCCBA1C584133333333E83D284100000020B61C5841CDCCCCCCEF3D284166666686B11C584166666666F23D2841CDCCCC8CAB1C584166666666F13D28419A999959A81C5841CDCCCCCC083E2841333333B3A71C58419A9999991E3E284133333333A71C584100000000313E2841333333B3A61C584133333333593E284133333333A31C5841333333336A3E284166666606A11C5841CDCCCCCC773E2841CDCCCCEC9E1C5841CDCCCCCC8A3E2841333333939D1C58419A9999999F3E28419A9999B99C1C584166666666BF3E2841000000609C1C584100000000EE3E2841000000809C1C5841333333331A3F28419A9999399C1C584166666666273F2841666666C69B1C58419A999999383F2841333333739B1C584133333333543F2841333333539B1C58419A999999793F2841000000009C1C584100000000C03F2841666666469C1C58419A999999DE3F2841CDCCCC0C9C1C58413333333305402841CDCCCC2C9C1C5841666666660C402841CDCCCC6C9C1C58416666666612402841666666C69C1C5841CDCCCCCC18402841000000E09C1C58419A9999991C4028419A9999D99C1C584133333333244028419A9999B99C1C5841666666663B402841666666E69C1C58413333333361402841CDCCCCAC9D1C58419A9999997A402841666666A69D1C58419A999999BE402841000000E09E1C5841CDCCCCCCD6402841000000209F1C58413333333340412841000000205F1C5841CDCCCCCCC44128419A9999D91B1C58413333333344422841CDCCCCCCD51B5841666666665842284133333313CB1B584100000000564228419A999979CA1B58416666666654422841CDCCCCACC91B58416666666653422841CDCCCC8CC81B58413333333353422841CDCCCCCCC71B58413333333354422841666666A6C61B5841333333335642284133333373C41B5841000000005A42284166666666C31B5841333333335D422841CDCCCC8CC21B5841CDCCCCCC62422841666666E6C11B5841666666666642284100000080C11B5841CDCCCCCC69422841CDCCCCECC01B5841333333338642284133333393B21B584100000000F142284100000060761B584100000000A34328419A9999B9861B58419A9999995E442841000000C0941B58419A999999844428419A9999F9831B5841CDCCCCCC12452841666666663D1B5841CDCCCCCC31452841000000C0371B58410000000051452841333333D3271B5841CDCCCCCC5645284133333353201B58419A9999995845284133333333181B5841333333337345284166666666081B5841000000007345284166666686061B5841666666667845284133333393031B5841CDCCCCCC7B45284133333313011B58410000000080452841CDCCCC6CFF1A5841666666668645284166666626FD1A5841CDCCCCCC86452841333333B3FB1A58416666666682452841666666E6F91A5841666666667545284100000000F81A58416666666660452841CDCCCCECF51A5841666666665B452841CDCCCC6CF51A58416666666647452841666666C6F21A5841000000002F4528419A9999F9EF1A5841000000002245284166666606EE1A5841000000001045284166666686EC1A584100000000034528419A999939EA1A5841CDCCCCCCF8442841000000C0E71A584133333333F044284133333333E51A584166666666E9442841CDCCCC2CE21A584133333333E24428419A9999B9DF1A584166666666D64428419A9999F9DC1A58419A999999C74428419A9999D9DA1A584133333333B744284166666666D91A584133333333A444284133333353D71A5841CDCCCCCC9A442841CDCCCC4CD51A5841CDCCCCCC9544284166666626D31A5841333333339444284166666666D01A5841CDCCCCCC9344284166666606CE1A5841CDCCCCCC9144284166666606CC1A5841000000008D442841CDCCCC4CCA1A58416666666680442841333333F3C81A58410000000071442841CDCCCC8CC61A584100000000684428419A999959C41A5841333333336344284133333393C11A584133333333604428419A9999D9BE1A58410000000057442841666666C6BB1A5841CDCCCCCC4D4428419A9999F9B81A58410000000040442841CDCCCC4CB51A58416666666632442841CDCCCC0CB01A584100000000284428419A999959AA1A584166666666204428419A999959A61A5841CDCCCCCC17442841666666C6A31A5841333333330D442841CDCCCC0CA21A58419A99999946432841CDCCCC2C6A1A58419A9999990D43284166666626421A5841CDCCCCCCB9422841000000600F1A5841CDCCCCCC8D42284166666606091A58419A999999A03E28419A999959631A584166666666073D284100000080891A5841CDCCCCCC283C2841333333D39E1A5841CDCCCCCC5B3B284166666646A41A58419A999999433B284166666606A51A584133333333323B284100000000A61A584133333333213B28419A999939A71A584133333333193B28419A9999F9A81A584100000000103B284100000060AA1A584133333333023B2841CDCCCC0CAB1A58419A999999F03A284100000060AB1A5841CDCCCCCCDF3A284100000000AC1A584100000000D13A2841CDCCCC6CAD1A584133333333733A284166666606B01A584133333333463A284100000060AE1A5841CDCCCCCC763928419A999999B91A5841333333336A39284133333393B91A5841333333335F392841CDCCCC8CB91A584133333333573928419A9999D9B91A58419A9999994D39284133333393BA1A5841333333333E39284133333353BB1A5841000000002C392841CDCCCC4CBC1A5841666666661C392841CDCCCCECBC1A5841666666660A392841666666E6BC1A58410000000001392841333333B3BC1A58419A999999E738284166666606BE1A584133333333D938284100000040BE1A5841CDCCCCCCC53828419A9999B9BE1A584133333333B63828419A999959BF1A58419A999999A83828419A999939C01A58419A9999999B382841666666A6C01A58419A9999998D382841333333B3C01A584166666666853828419A999959C11A584133333333703828419A9999F9C21A5841333333335A38284133333353C41A584133333333423828419A999999C51A5841000000003238284133333373C61A58419A9999991C382841000000E0C61A5841333333330A3828419A999979C71A58419A999999FA37284133333313C81A584133333333EB3728419A999939C81A58419A999999DF372841333333D3C81A58419A999999D5372841000000C0C91A58419A999999C837284166666626CB1A584166666666BD37284133333333CB1A58419A999999AC3728419A9999F9CA1A58416666666693372841000000C0CA1A5841000000008737284166666606CB1A5841666666666B372841CDCCCC2CCC1A5841CDCCCCCC4D3728419A999999CD1A5841666666663E37284100000020CE1A5841666666663137284100000040CE1A584133333333253728419A999999CE1A5841333333331B3728419A999959CF1A5841000000000B372841CDCCCC0CD01A58419A99999906372841666666C6CF1A5841CDCCCCCCFF362841333333B3CF1A5841CDCCCCCCF1362841333333B3CF1A584100000000E93628419A9999B9CF1A584100000000E136284166666666CF1A5841CDCCCCCCD8362841CDCCCC0CCF1A5841CDCCCCCCCF36284166666686CE1A584166666666C53628419A999919CE1A58419A999999C036284100000080CD1A58419A999999BC362841333333B3CC1A58419A999999F735284100000060E41A584100000000E835284133333373E71A584100000000EF342841333333B3021B5841000000007534284100000040091B58419A999999C2332841CDCCCCCC111B58419A999999B23328419A999959151B584166666666A5332841CDCCCC4C181B58416666666695332841666666C61B1B5841000000007F332841000000601F1B58419A9999996D3328419A999979221B5841333333335C33284133333373251B58410000000042332841333333D3291B58413333333326332841666666862E1B58413333333305332841333333D3331B5841CDCCCCCCE232284166666646391B584133333333BD322841666666863F1B5841CDCCCCCC96322841333333B3451B58416666666672322841CDCCCCAC4B1B5841666666665F322841666666264F1B5841333333335132284100000000511B58419A9999993E322841CDCCCC4C531B58410000000032322841666666A6541B584100000000213228419A999979561B58410000000003322841333333335A1B58419A999999E7312841666666E65D1B584100000000D73128419A999979601B584133333333CF3128419A9999D9611B584133333333C231284100000040611B584133333333BC312841CDCCCC0C611B584166666666B2312841333333F3601B584133333333A2312841333333F3601B5841000000009131284100000000611B5841000000007731284133333313611B58410000000060312841000000C0601B5841666666664B312841CDCCCC6C601B5841333333333131284100000000601B5841666666661E312841000000A05F1B5841000000000E312841666666265F1B584100000000FD302841333333B35E1B58419A999999E8302841000000605E1B584100000000CC302841000000E05D1B58419A999999B6302841666666665D1B5841CDCCCCCC94302841CDCCCCAC5C1B584133333333763028419A9999795C1B58410000000071302841000000A05C1B5841666666664D302841000000205D1B58419A99999944302841666666865C1B58416666666639302841666666065C1B5841666666662E3028419A9999B95B1B584166666666223028419A9999995B1B5841CDCCCCCC173028419A9999795B1B5841333333330D302841000000405B1B58419A99999902302841CDCCCC0C5B1B584100000000F92F2841000000005B1B5841CDCCCCCCE92F2841666666E65A1B584133333333D72F2841333333335A1B58419A999999DE2E28419A9999F9511B58419A999999DD2B28419A9999D9541B584166666666802A2841666666A6571B584133333333832A284166666686781B58419A999999792A2841333333F38A1B5841CDCCCCCC502A284100000040A71B5841333333334F2A284166666626BF1B584133333333662A2841000000E0F01B584133333333712A28419A9999B9011C58419A999999632A28419A999979071C584100000000652A2841CDCCCCCC0D1C5841333333336A2A2841333333B30F1C584166666666712A2841CDCCCC2C111C5841000000007C2A28419A9999F9111C5841CDCCCCCC8E2A284133333313131C5841');
INSERT INTO commune VALUES ('30510', 'Generac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
INSERT INTO commune VALUES ('30320', 'Marguerittes', '30156', '30', '01060000206A0800000100000001030000000100000014030000000000001DE928419A999939421458413333333305E92841666666C63A14584133333333BCE82841333333132314584166666666B4E82841CDCCCC4C201458413333333397E828419A999979151458416666666691E82841CDCCCC6C131458416666666686E828419A9999590F1458413333333378E82841CDCCCC8C0D145841CDCCCCCC6AE82841666666E60B145841333333336BE828419A99995907145841CDCCCCCC68E82841CDCCCC6C05145841333333335CE82841666666A600145841CDCCCCCC59E8284133333313FF1358413333333354E82841333333F3F71358416666666653E8284133333393F41358410000000053E82841CDCCCCCCE71358413333333357E82841CDCCCC4CD4135841CDCCCCCC5FE828419A999939CC1358419A99999961E82841000000A0C8135841CDCCCCCC5FE8284166666606C31358410000000059E8284166666606BA1358419A99999958E8284133333333B51358419A9999995AE82841666666E6B31358419A9999995EE828419A999959B2135841000000006DE828419A999919AF1358413333333377E8284166666626AC135841CDCCCCCC74E82841000000C0A5135841CDCCCCCC76E82841CDCCCC8C9D1358419A99999972E82841666666A6921358419A99999973E82841666666868C1358419A99999976E82841CDCCCC2C881358413333333379E82841CDCCCC6C831358410000000076E8284100000060661358416666666615EA28419A99995951135841CDCCCCCC26EB284166666686431358419A99999981EB2841333333F33E1358413333333395EB2841333333731A1358413333333395EB2841000000801613584100000000A1EB28419A99999911135841CDCCCCCCABEB2841CDCCCCCC0A13584133333333B4EB2841000000E002135841CDCCCCCCB8EB2841CDCCCCECFA1258419A999999B7EB28419A999939F31258419A999999AAEB2841CDCCCC4CE91258419A9999999AEB2841000000C0E11258410000000094EB28419A999939DA125841CDCCCCCC90EB2841666666E6CF125841666666668DEB284166666646CB125841CDCCCCCC87EB284133333313C61258419A9999998AEB284133333373C012584133333333A7EB284133333333B4125841CDCCCCCCC0EB28419A999919AE12584166666666DCEB284100000080A212584100000000E8EB28419A9999B99D125841CDCCCCCCF2EB2841000000E098125841333333331EEC2841333333B38D1258416666666657EC28419A9999797C125841CDCCCCCC83EC28419A9999D972125841333333339BEC2841CDCCCC0C6D1258419A999999A8EC28416666664669125841CDCCCCCCDCEC2841CDCCCCEC5B125841CDCCCCCCEFEC284100000060561258419A9999990DED284100000060501258413333333323ED2841333333134B1258419A9999993FED28416666662640125841CDCCCCCC41ED284100000080391258410000000048ED28419A999959361258410000000060ED28419A9999392F125841CDCCCCCC7EED284133333393271258413333333389ED28419A9999B9231258419A99999994ED2841333333B3201258413333333396ED28410000004020125841CDCCCCCC9BED2841333333F31C12584100000000A4ED28413333331318125841CDCCCCCCA7ED28419A9999D91512584100000000B5ED2841CDCCCC4C1012584100000000BCED2841333333130E1258419A999999E4ED28419A999919011258419A999999EEED284133333333FC11584100000000F2ED28419A999959FA1158419A99999902EE2841666666A6EB1158413333333310EE28419A9999B9E11158413333333318EE284166666606D7115841333333331CEE2841333333D3D11158416666666620EE2841CDCCCC2CCF1158410000000027EE2841333333B3CB115841CDCCCCCC34EE2841000000A0C21158413333333338EE284166666666C01158416666666643EE2841000000C0B91158410000000051EE2841000000E0B31158419A9999996FEE284133333393A3115841000000007CEE2841000000009E1158419A9999997FEE2841000000009C1158413333333384EE2841666666A697115841000000007FEE28416666662697115841333333337CEE28419A9999D9951158419A9999997CEE2841CDCCCCAC91115841CDCCCCCC80EE2841000000C08A115841CDCCCCCC7EEE2841333333B3881158413333333373EE28419A9999F9831158410000000070EE2841333333B37F1158413333333371EE2841666666667D1158413333333374EE28419A9999597C1158419A99999981EE2841CDCCCCAC72115841CDCCCCCC83EE2841333333736E1158419A99999981EE2841666666A6691158413333333382EE28410000004063115841CDCCCCCC84EE28419A9999B95F1158419A9999998DEE2841333333535B115841666666668FEE2841000000C0581158419A99999993EE2841CDCCCC6C56115841666666669EEE28410000002052115841CDCCCCCCA2EE2841333333734C11584133333333A6EE2841CDCCCCCC4911584133333333ABEE2841000000A0471158419A999999ABEE28410000006045115841CDCCCCCCA8EE2841000000E04011584133333333B2EE284100000000381158419A999999BAEE2841666666063311584100000000CCEE2841000000E02A1158419A999999D1EE2841CDCCCCAC2811584100000000DAEE2841666666262611584100000000EDEE28419A999979221158419A999999F1EE2841333333D3201158419A9999992DEF2841CDCCCC4C2511584166666666A4EF28419A9999D92F11584100000000CEEF2841CDCCCC2C3311584166666666E1EF2841333333D3341158419A999999F1EF28419A9999793611584166666666FBEF28410000004038115841CDCCCCCC15F028419A9999F93B1158410000000024F02841CDCCCC4C3D1158413333333336F02841CDCCCC8C3E115841666666665DF02841CDCCCC8C401158413333333376F028419A9999D9411158419A99999994F02841CDCCCC0C4411584166666666CCF028419A9999394711584100000000DEF0284166666666481158419A999999F6F02841333333734B1158410000000020F128419A9999994F1158410000000030F12841CDCCCC6C511158419A99999993F12841CDCCCCCC5A115841CDCCCCCCD2F12841CDCCCCEC5F11584166666666E0F12841000000806111584133333333EDF12841CDCCCCAC6211584100000000FEF12841CDCCCCEC631158419A9999990FF22841000000205D115841CDCCCCCC13F22841333333535C115841CDCCCCCC57F22841666666663E1158419A99999962F22841CDCCCC0C38115841CDCCCCCC8EF228419A9999D9221158419A99999992F22841000000E0211158419A999999ACF2284133333373221158410000000028F32841CDCCCCCC041158416666666669F32841CDCCCC8CF7105841CDCCCCCC97F3284166666606ED10584100000000E2F32841CDCCCCECDD1058410000000024F42841CDCCCCCCCF105841666666666DF4284133333313C01058416666666685F428419A9999B9B810584166666666AFF428419A9999F9AB10584133333333B5F4284100000020AA1058419A9999992FF52841333333D38410584166666666B1F52841000000205D105841CDCCCCCCDBF528416666664650105841666666662FF62841CDCCCC6C341058410000000079F628419A9999F91B10584100000000A8F62841000000600C10584100000000BAF62841333333330010584100000000CDF6284100000080F30F5841CDCCCCCCDEF62841666666A6E70F584100000000EEF6284166666666DD0F5841CDCCCCCCFFF628419A999999D10F5841CDCCCCCC13F728419A999939C40F5841333333331FF72841666666A6BC0F5841333333332FF72841000000E0B10F58416666666630F7284133333313B10F58419A99999958F72841333333F3AB0F58419A99999961F72841CDCCCCCCAA0F58419A9999992BF8284133333313910F5841CDCCCCCC7BF82841333333538A0F5841666666660DF92841CDCCCCAC820F5841666666660FF92841CDCCCC8C820F584133333333E2FA2841CDCCCC0C6A0F58419A999999ADFB28419A9999595F0F5841CDCCCCCCF7FB2841CDCCCCAC650F5841CDCCCCCC09FC284133333393670F58419A99999916FC284166666626690F5841CDCCCCCC1FFC2841000000806A0F58416666666628FC2841000000406C0F58416666666640FC2841000000E06B0F58413333333371FC28419A999959690F58413333333385FC284166666626680F58419A999999D3FC2841000000E0650F5841666666660EFD284100000060640F5841000000003BFD284166666606630F58419A99999970FD28419A999919610F58419A99999991FD2841333333335F0F5841CDCCCCCCB0FD2841666666E65D0F5841CDCCCCCCE4FD2841000000205C0F5841CDCCCCCC33FE2841666666465A0F58413333333345FE2841666666A6590F58410000000052FE2841333333F3580F5841000000004EFE284100000080540F58410000000011FF284133333373510F58413333333320FF284133333333510F58419A9999992AFF284133333393510F5841333333334CFF2841000000A0500F58410000000056FF284100000080500F5841000000005DFF2841CDCCCC6C500F58413333333368FF284133333393500F5841CDCCCCCC7BFF2841333333B3510F58419A99999981FF28419A999919510F584166666666A4FF2841000000604E0F5841CDCCCCCCBDFF28419A9999F94C0F584133333333F0FF2841333333D34A0F5841000000002900294100000000490F5841CDCCCCCC5A0029419A999999470F584100000000A000294166666686450F5841CDCCCCCCCA002941CDCCCCEC430F584100000000D800294166666646430F58419A999999D80029419A999919600F584166666666DD0029419A999979680F5841CDCCCCCCDE002941333333F36A0F584100000000E10029419A9999596A0F584100000000E70029419A9999596A0F5841000000003A012941333333D36B0F58410000000084012941000000606D0F58410000000099012941000000406D0F5841333333332D02294133333333710F584166666666A202294100000000740F58419A999999A7022941CDCCCCAC740F5841333333331E032941000000E0760F584133333333D6032941333333737A0F5841CDCCCCCC54042941000000007F0F5841CDCCCCCC42062941666666A6900F5841CDCCCCCC950629419A999999930F5841333333336A08294100000040A40F5841666666665A092941666666C6AC0F5841000000007F092941CDCCCC2CAE0F5841333333339709294100000020AF0F584166666666110A29419A9999D9B30F5841CDCCCCCC490B2941666666E6BF0F5841333333339E0B29419A9999B9C20F58419A999999A60B2941333333939E0F5841CDCCCCCCB20B294133333313770F58419A999999B90B2941333333935E0F584100000000BB0B29419A9999D95A0F58419A999999C40B2941333333F3390F5841CDCCCCCCCA0B2941666666262F0F5841CDCCCCCCCB0B2941666666462A0F5841CDCCCCCCC80B29419A999979280F58419A999999C50B2941666666A6260F5841666666668B0B29419A9999190C0F5841CDCCCCCC3B0B294100000020EA0E5841CDCCCCCC090B294100000040D50E584100000000B00A294166666606AE0E5841CDCCCCCC690A29419A9999D98C0E5841666666663C0A2941666666C68E0E5841666666662E0A2941000000E08D0E584133333333CC092941666666868A0E5841CDCCCCCC6D0929419A999999870E5841000000003A09294100000000860E58419A999999AB08294133333313820E58419A99999969082941666666E67F0E5841333333330E082941CDCCCC6C7D0E584133333333F4072941000000E07C0E5841CDCCCCCCED072941000000C07C0E584100000000D0072941333333737B0E5841CDCCCCCCC2072941666666667A0E5841CDCCCCCCB7072941333333937A0E58419A999999A5072941666666E6790E58416666666640072941666666C6750E584166666666CF0629419A9999D9700E58410000000091062941CDCCCCAC6D0E5841CDCCCCCC6B062941333333936B0E5841333333333B062941CDCCCCAC680E5841CDCCCCCC0B0629419A999979650E584133333333F5052941666666A6630E584166666666C2052941CDCCCC8C600E584100000000AD052941000000A05F0E584100000000940529419A9999B95E0E58416666666669052941CDCCCC8C5D0E5841333333332D052941666666A65C0E584133333333DF042941333333B35B0E5841CDCCCCCCAF042941333333D35A0E5841666666668A042941333333F3590E5841333333332204294100000060580E5841CDCCCCCC91032941333333D3560E5841333333331A03294100000020560E58413333333384012941000000E0080E58419A9999994001294100000060FD0D584100000000330129419A9999B9FA0D5841CDCCCCCC2401294100000080F80D5841666666660E01294100000000F40D58419A999999050129419A999959F10D58419A999999F9002941666666E6EE0D5841CDCCCCCCF00029419A999939EC0D584166666666DD0029419A999939E40D584100000000D8002941333333B3E10D58419A999999D300294100000080DE0D5841CDCCCCCCCB00294166666686DC0D584100000000C3002941CDCCCC0CDB0D584166666666B60029419A9999B9D90D5841CDCCCCCCA700294100000080D80D5841333333339700294100000080D70D5841CDCCCCCC730029419A999979D50D5841CDCCCCCC48002941CDCCCCCCD20D5841CDCCCCCC26002941333333F3D00D58413333333368FF2841CDCCCC8CC50D58419A999999F6FE28419A9999B9BE0D5841CDCCCCCC64FE2841CDCCCC8CB50D58419A99999958FE284133333333B40D5841666666664BFE2841CDCCCCCCB20D58419A99999945FE2841CDCCCC2CB20D58416666666622FE2841CDCCCC8CAF0D5841CDCCCCCC11FE2841CDCCCC6CAE0D58416666666600FE284133333393AD0D584133333333F0FD284133333353AC0D584100000000E3FD2841000000A0AB0D5841666666666EFD28419A999999A40D5841000000005CFD284133333333A30D5841CDCCCCCCE1FC2841CDCCCCAC9A0D5841CDCCCCCCD0FC284133333353990D584100000000BDFC284166666606980D58416666666690FC2841666666C6950D5841000000005EFC2841CDCCCC8C920D5841666666662FFC28419A9999998F0D58413333333315FC2841CDCCCC2C8E0D584166666666D5FB2841666666068A0D5841CDCCCCCCB7FB2841CDCCCC6C870D58419A99999996FB28419A999939850D58413333333375FB284100000060830D58419A99999964FB2841000000E0820D5841CDCCCCCC42FB284133333333810D5841000000001FFB284100000020800D58410000000012FB2841000000807F0D58410000000007FB2841000000A07E0D58419A999999D8FA28419A9999997C0D58419A9999997FFA284166666646780D5841666666666DFA2841CDCCCC4C770D58410000000026FA2841000000A0730D58410000000019FA28419A9999D9720D584100000000C5F92841666666066E0D58419A9999995EF9284100000020690D584133333333FFF828419A999979630D58419A999999A1F82841CDCCCC2C5E0D5841CDCCCCCC68F82841666666665B0D5841666666665BF82841333333535A0D58419A99999935F82841000000A0560D584166666666EFF72841CDCCCC0C4F0D58419A999999B7F7284133333313490D58419A9999992AF728419A999919380D5841CDCCCCCC05F7284166666646340D58419A999999BEF62841666666A62D0D58419A9999999AF62841CDCCCC2C2B0D58419A99999987F62841666666262A0D5841333333337EF628419A999999290D5841CDCCCCCC56F62841CDCCCC6C270D58419A99999921F6284133333333240D58410000000039F52841333333F3140D584166666666F5F42841333333F3100D584100000000E3F42841333333B30F0D584166666666D6F428419A9999590E0D5841CDCCCCCCC7F42841CDCCCC8C0F0D58419A99999970F4284166666686080D58419A999999F3F3284133333353000D58416666666671F328419A9999B9F60C58419A99999947F32841CDCCCCECF30C58419A9999992BF32841CDCCCC0CF20C5841CDCCCCCC06F328419A999999EF0C5841CDCCCCCCC0F1284100000000DC0C58419A9999990CF128419A9999B9CE0C5841CDCCCCCCACF02841CDCCCC2CC80C58413333333387F0284166666666C60C5841CDCCCCCC5EF0284166666686C40C58410000000022EF284166666606C90C58419A99999914EF284133333333C90C584100000000A6ED284166666686CE0C58419A999999DDEC2841CDCCCCECD10C584100000000EFEB2841CDCCCCACD50C584100000000ABEB284133333373DD0C5841CDCCCCCC43EA28419A9999F9040D58410000000082E92841CDCCCC4C150D58413333333358E92841333333B31A0D58419A9999994FE92841000000A01B0D58416666666620E92841666666E6200D58413333333394E82841CDCCCCEC300D58419A99999954E8284166666626370D58410000000007E828419A999959330D58419A999999CDE72841000000A02F0D5841000000009AE72841CDCCCCAC2B0D58419A99999961E72841000000C0260D58416666666640E72841CDCCCC8C230D58416666666623E72841CDCCCC6C200D584133333333F1E62841333333931A0D58419A999999DBE62841666666E6170D584133333333CAE6284166666666150D58419A999999A9E5284133333333170D584133333333B1E52841000000601E0D584166666666AFE5284100000060280D5841CDCCCCCCB0E52841333333532F0D5841CDCCCCCCADE5284100000000370D584100000000A8E52841000000C03A0D58413333333398E5284133333353460D5841333333338FE5284133333353510D58410000000089E52841666666E6560D58413333333388E52841000000E0590D58413333333387E52841333333F35A0D58416666666678E52841000000C0600D58419A9999996EE5284100000060650D58419A9999995DE52841666666666B0D58416666666656E528419A9999996E0D5841333333334DE52841000000E0710D58416666666639E5284133333313720D5841000000003FE52841CDCCCC2C730D5841000000003FE5284133333373740D58419A999999FEE428419A9999D98E0D5841CDCCCCCCF4E428419A999939930D584133333333EBE42841CDCCCC8C980D584100000000DBE4284166666626980D5841333333339BE4284133333333970D5841666666666FE42841000000C0960D584166666666F8E32841000000808B0D5841333333336AE3284100000060930D58419A99999940E32841CDCCCCAC950D58416666666646E32841666666E6A10D58419A99999953E32841CDCCCC0CB60D5841333333334CE32841333333F3B70D58413333333349E32841333333B3B90D5841666666663FE32841000000A0C30D58413333333337E3284100000020C80D584100000000F0E22841CDCCCC6CC40D584166666666D3E2284133333313C30D584100000000C1E2284133333373C20D584100000000B0E22841CDCCCCACC10D584166666666A5E22841CDCCCC0CC10D58410000000090E2284100000060BF0D58416666666663E2284166666666BD0D58416666666613E22841000000E0BA0D58416666666605E22841CDCCCCCCBE0D584166666666FEE128419A9999D9C10D584100000000FFE1284133333353C40D58416666666601E2284166666626C60D58410000000001E22841CDCCCC0CC80D584166666666FBE12841CDCCCC8CC90D584166666666EAE128419A999999D00D58419A999999EBE1284133333333D20D5841CDCCCCCCF2E12841CDCCCC0CD60D584166666666F7E128419A9999B9D90D584133333333F7E12841CDCCCCACDB0D584133333333EFE12841CDCCCCECDF0D584166666666EDE12841666666C6E10D584133333333EFE12841666666C6E30D5841CDCCCCCCF4E1284166666626E50D58419A999999F6E1284133333393E60D584133333333F5E128419A999979E70D584166666666F0E1284133333393E80D5841CDCCCCCCE2E12841333333D3E90D584100000000DCE1284166666626EA0D5841CDCCCCCCEAE1284133333313F00D584133333333B0E1284133333333EC0D5841CDCCCCCC7CE12841CDCCCC2CEA0D58410000000068E12841333333B3EF0D58419A9999995FE12841666666C6F00D58419A9999995BE1284133333313F20D58416666666657E12841CDCCCCECF40D58419A99999953E1284100000060F60D5841CDCCCCCC44E1284166666666F90D5841CDCCCCCC3EE12841666666E6FA0D5841CDCCCCCC37E128419A9999D9FE0D5841CDCCCCCC31E12841333333B3000E5841CDCCCCCC21E12841666666A6030E58419A99999912E12841000000A0060E5841CDCCCCCC0DE128419A9999F9070E5841CDCCCCCC0DE12841000000000A0E58410000000006E12841000000C00D0E58419A999999FEE02841CDCCCC0C0F0E584166666666F8E0284166666606110E58419A999999F0E02841333333F3120E58419A999999EAE02841333333F3140E584166666666E7E02841666666C6160E58419A999999D7E02841CDCCCC0C1A0E5841CDCCCCCCD0E028419A9999191B0E584133333333C6E02841CDCCCC2C1C0E58419A999999B7E02841333333731F0E584100000000B1E028419A999959210E5841CDCCCCCCADE028419A999979230E58419A999999A8E0284133333373250E584166666666A6E02841CDCCCC2C270E58419A9999999BE028419A9999392A0E58410000000099E02841000000002C0E58416666666696E028419A999999300E58410000000092E02841333333F3350E5841CDCCCCCC94E0284166666606380E5841CDCCCCCC94E028419A9999D9390E5841CDCCCCCC8AE02841666666463D0E58413333333384E02841000000003F0E58419A99999980E02841666666A6400E58413333333373E028419A9999F9430E58419A99999962E02841000000C0460E58419A9999994FE02841CDCCCC6C490E58419A99999947E02841000000004B0E58416666666634E02841333333B34F0E58416666666631E028419A999979510E58416666666632E0284166666686530E58419A99999937E02841CDCCCCAC560E58419A99999938E0284133333353580E58413333333338E02841333333B35C0E58419A99999936E02841333333B35E0E5841000000002FE02841000000A0620E58413333333327E02841CDCCCC2C6A0E58416666666626E028419A9999D96B0E58410000000028E02841CDCCCCEC6D0E58410000000031E02841333333D3710E58419A99999938E0284133333313780E58416666666637E02841333333137E0E58419A99999941E02841666666A6840E5841333333334BE02841CDCCCC4C8D0E58419A9999994AE02841333333538F0E58413333333345E02841CDCCCCEC920E58416666666645E028419A9999B9940E58413333333347E02841CDCCCCAC960E5841333333334EE0284100000080980E58419A9999995BE02841000000809E0E58416666666661E0284100000040A30E58419A9999995FE0284133333373A60E58410000000062E0284133333333A80E58419A99999962E02841000000C0A90E58410000000066E0284166666646AB0E5841CDCCCCCC64E02841CDCCCCCCAC0E58419A9999995CE02841666666E6AD0E58419A9999994BE02841CDCCCCACAF0E58416666666646E0284100000020B10E58419A99999943E02841666666E6B20E58410000000046E02841000000C0B60E5841CDCCCCCC44E0284100000060B80E5841CDCCCCCC41E028419A9999B9BA0E5841000000003EE02841666666C6BB0E58416666666638E02841CDCCCCCCBF0E58416666666636E02841000000E0C00E58416666666632E02841CDCCCCACC10E5841CDCCCCCC43E028419A9999B9C90E58419A99999948E0284133333393CE0E58416666666646E02841333333D3CF0E5841CDCCCCCC3CE0284166666686D20E58419A99999927E0284133333333D60E58419A99999913E02841CDCCCC0CDF0E5841000000000CE02841CDCCCC6CE10E58413333333305E02841CDCCCCCCE50E584166666666FFDF284133333393E80E584133333333FBDF28419A9999B9EC0E584133333333FBDF2841CDCCCC6CEE0E584166666666FCDF2841CDCCCC4CF00E58413333333303E0284166666626F60E58419A99999901E0284100000040F90E5841CDCCCCCC04E02841CDCCCCECFA0E58413333333305E028419A999939FC0E5841CDCCCCCCF6DF2841000000A0030F584100000000F2DF284166666646080F584166666666E6DF2841666666A60E0F584166666666D7DF284166666666120F58416666666690DF2841CDCCCCCC120F5841333333334ADF28419A9999F9120F58416666666621DF284166666666130F58419A99999984DE28419A9999B9140F5841CDCCCCCC07DE2841000000E0150F5841CDCCCCCC89DD284133333353170F5841CDCCCCCC2DDD2841000000E0180F584133333333E9DC28419A9999991A0F584166666666B6DC28419A9999591C0F584166666666FEDB284133333393230F584100000000EDDB28419A999919240F58419A999999C4DB284166666666250F58416666666687DB2841CDCCCCEC260F58419A99999939DB28419A999979280F584100000000FFDA284100000060290F584133333333E7DA2841333333F3290F584166666666BBDA2841CDCCCC4C2A0F58413333333371DA28419A9999B92B0F5841333333334FDA2841666666462C0F58410000000019DA28419A9999392D0F5841CDCCCCCCF4D9284100000020300F58419A9999993DD928419A9999F93E0F5841CDCCCCCC15D9284100000060420F584100000000FAD82841333333D34E0F5841CDCCCCCC07D92841000000C06C0F58419A999999F6D82841666666C6750F58419A999999E5D828419A9999597C0F5841CDCCCCCCDAD8284166666686800F58419A999999CFD82841666666C6830F5841CDCCCCCCBED82841666666C6880F58419A999999A4D8284166666666900F58416666666677D82841666666869D0F58419A99999970D82841CDCCCC6C9F0F58416666666651D8284100000060A80F58416666666650D828419A9999B9A80F58419A99999940D8284100000040AD0F5841666666662CD8284133333313B30F584166666666FAD7284166666686C00F584166666666F5D728419A9999D9C10F5841CDCCCCCCEBD7284166666666C40F584166666666DAD72841333333F3C80F584100000000B1D72841333333D3D30F5841CDCCCCCC74D72841CDCCCCACE30F58413333333343D728419A9999B9F00F58410000000025D72841000000A0F80F5841CDCCCCCC26D72841666666C6001058419A9999992AD7284100000020131058419A9999992ED7284100000000261058413333333332D72841CDCCCCCC371058413333333334D72841CDCCCCCC411058419A99999936D72841CDCCCCCC4C105841CDCCCCCC38D728413333337357105841666666663BD72841CDCCCC4C681058410000000042D72841000000C0701058413333333349D72841CDCCCC8C72105841CDCCCCCC60D728419A9999D976105841000000007AD728419A9999D97B105841CDCCCCCC97D72841CDCCCC0C801058419A999999BBD72841333333B385105841CDCCCCCCC6D728413333337388105841CDCCCCCCE6D72841666666A68E105841333333330DD828419A9999D993105841CDCCCCCC2FD82841666666C6991058419A9999993AD82841333333D39C1058413333333340D82841000000E09D1058419A99999950D8284166666626A01058416666666664D828419A999959A31058413333333383D82841000000C0A9105841333333339CD8284133333373AE10584133333333A9D82841CDCCCC4CB010584133333333B8D828419A9999F9B110584166666666C6D82841000000E0B210584100000000DCD828419A999999B310584166666666E7D8284166666626B81058419A999999E4D82841000000A0BD1058419A999999E5D82841CDCCCC0CBF10584133333333E2D8284100000020CB10584100000000A3D8284166666626DD105841CDCCCCCC8DD82841CDCCCC2CE31058413333333337D82841CDCCCC6C041158416666666614D82841666666260911584100000000F8D72841666666060D1158419A99999986D72841CDCCCC6C1C115841CDCCCCCC56D72841333333F3221158419A9999996CD72841000000204D1158419A9999996FD72841000000E0521158413333333375D72841CDCCCC2C5D1158410000000078D72841666666E6621158416666666676D72841CDCCCCCC67115841CDCCCCCC7BD72841333333D36A115841CDCCCCCC76D72841333333F36C1158416666666686D72841CDCCCC8C811158419A999999C9D72841666666A69D115841CDCCCCCC0CD82841000000C0B91158413333333312D828419A9999F9BB1158419A99999945D8284133333373D11158410000000069D8284100000040E01158416666666683D828419A999939EB115841CDCCCCCC8AD8284133333353EE1158419A999999A3D82841000000C0F811584166666666BDD8284133333373031258419A999999DFD828419A9999D911125841CDCCCCCC01D928419A999919201258413333333339D928413333335337125841000000003CD92841000000203C125841666666663ED92841333333D33F1258416666666682D92841666666866012584166666666C6D9284100000040811258419A9999990ADA2841333333F3A1125841666666666EDA2841666666E6D112584166666666B8DA28419A999979F5125841CDCCCCCCF0DA2841666666A6101358419A9999998EDB2841CDCCCC6C5C1358410000000098DB2841CDCCCC0C6113584166666666C9DB2841666666C678135841CDCCCCCCC9DB28419A9999597F1358419A999999CADB2841666666A68E13584133333333CBDB28419A9999D99813584166666666C7DB284166666686B813584100000000C5DB2841CDCCCC8CCB13584166666666BDDB284133333373DA13584100000000B6DB2841CDCCCC0CE9135841CDCCCCCCB4DB28419A9999B9EB135841CDCCCCCCC2DB28419A999939EC135841CDCCCCCCD8DB284166666606ED1358416666666693DC284166666626EF13584100000000F7DC284100000060F01358410000000059DE28419A999919FB1358413333333358DE2841333333F3FB1358410000000036DE28419A9999B9021458413333333328DE28410000002006145841666666661EDE2841CDCCCC0C08145841CDCCCCCC13DE284133333393091458419A999999FCDD2841333333330E14584166666666F0DD2841333333131014584133333333EADD28413333335311145841CDCCCCCCE3DD28410000008015145841CDCCCCCCE2DD2841666666461714584100000000E2DD2841333333131E14584166666666D6DD2841000000E02214584100000000D5DD28419A9999D92414584133333333D8DD28419A9999B92B1458419A999999D0DD2841333333333A145841CDCCCCCCCCDD2841666666A63C145841CDCCCCCCBDDD2841333333334114584166666666BADD2841000000604314584133333333BADD2841666666664814584166666666BDDD28419A9999D94B14584100000000BDDD2841CDCCCC0C4F14584166666666BFDD2841CDCCCCAC5114584100000000BFDD2841333333B35314584133333333BDDD2841333333D35514584166666666B8DD284133333393571458419A999999B6DD2841000000605E14584166666666B4DD2841CDCCCC0C6714584133333333B3DD28419A9999B9671458416666666689DD284133333333811458410000000087DD28413333339382145841CDCCCCCC74DD2841666666A68D1458419A9999993ADE284166666686861458413333333345DE2841000000408A1458416666666636DF2841333333D38514584166666666C3DF28419A999939831458410000000034E02841CDCCCC6C85145841CDCCCCCC56E028419A9999798414584166666666E7E028416666666680145841333333339DE128413333333384145841CDCCCCCC75E2284100000000881458410000000082E22841333333B3871458416666666691E228419A9999998714584133333333A1E22841666666C68714584100000000C9E22841333333B388145841CDCCCCCCDAE2284133333333891458419A999999F4E22841333333D389145841333333334EE32841333333938A1458419A99999993E32841333333B38B14584100000000BDE32841000000008D145841000000000BE428413333333390145841CDCCCCCC0EE42841333333738F1458416666666618E42841CDCCCC6C8E145841000000002BE42841666666A68D1458419A99999949E42841CDCCCCEC8C14584100000000B4E428419A9999998B14584100000000DAE42841333333B38A1458416666666643E5284100000080891458413333333391E52841CDCCCC8C8914584166666666BCE52841CDCCCC2C891458419A999999C9E52841CDCCCCAC8814584100000000D6E528419A9999D98814584166666666F8E528419A9999198814584100000000FEE52841666666C6861458416666666600E628419A999979851458416666666605E62841CDCCCC8C7D1458419A99999907E628419A9999797C145841CDCCCCCC09E62841666666C67B145841666666661AE6284166666666781458413333333331E628416666660676145841000000004AE628413333331374145841CDCCCCCC73E628419A9999F96F145841333333338AE62841666666066E14584166666666B0E62841000000C06914584133333333BCE628410000000068145841CDCCCCCCC8E628419A9999996614584100000000E6E628419A9999596314584133333333FFE62841000000E0601458413333333302E728419A999959601458416666666610E72841333333B3601458419A9999991AE72841666666E660145841CDCCCCCC25E72841333333F3601458410000000031E728413333331361145841333333333AE728413333333361145841CDCCCCCC4AE72841CDCCCC8C611458416666666658E72841666666C6611458419A9999995EE728419A9999F9611458419A9999996EE7284100000060621458410000000083E72841666666A6621458413333333385E728419A9999795F145841CDCCCCCC9CE72841000000405D14584133333333BEE72841333333935A145841333333331FE8284166666686511458419A99999940E82841CDCCCCAC4E1458410000000073E82841666666864B14584100000000A8E8284166666626491458419A999999E4E8284100000000461458410000000014E928419A99991943145841000000001DE928419A99993942145841');
INSERT INTO commune VALUES ('30129', 'Manduel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
INSERT INTO commune VALUES ('30320', 'Poulx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
INSERT INTO commune VALUES ('30210', 'Sernhac', '30317', '30', '01060000206A08000001000000010300000001000000FA0000009A9999998E3E2941CDCCCC2CA314584100000000233E29419A9999D99E14584166666666A33C29419A9999598F14584100000000863A2941000000407A1458419A999999EF392941000000407414584100000000DE392941CDCCCC8C731458419A999999D8392941333333937314584100000000CA392941333333B37314584133333333B3392941666666E673145841CDCCCCCCCF37294133333373771458416666666657372941000000807814584166666666103729410000002079145841CDCCCCCCF53629419A9999597914584133333333E03629416666668679145841666666668F3529419A9999597C14584133333333CD342941666666467E14584100000000443429419A9999F97C1458413333333331342941000000A07C14584100000000EC332941666666A67C145841CDCCCCCC81332941000000007C1458410000000040332941333333937B14584166666666EA322941666666A67A145841CDCCCCCC973229419A9999B97914584166666666A231294133333393781458416666666699312941333333137914584133333333273129413333331379145841333333331931294133333313791458419A99999903312941666666067914584166666666C4302941CDCCCCAC7814584166666666DD2F2941000000007714584166666666A22E29413333339374145841333333333C2E2941666666C6731458419A999999202E294133333373731458419A999999EE2D2941666666467314584100000000E62D2941333333137314584133333333D62D2941333333F37214584133333333F42C29416666662671145841CDCCCCCC352C2941CDCCCC8C6F1458419A999999052B2941000000006D14584100000000922A2941333333136C14584100000000AF292941000000406A1458419A999999A2292941666666266A14584133333333F9282941333333D36814584100000000E1272941CDCCCCAC6614584100000000D32729419A9999F96A14584133333333C42729419A9999197214584166666666C0272941333333537514584166666666C1272941666666E678145841CDCCCCCCC4272941666666C67C1458419A9999999C272941333333138A145841000000008B272941CDCCCC6C91145841CDCCCCCC7C2729416666664697145841CDCCCCCC5027294166666626A9145841666666663B2729419A999939B41458419A9999997C26294133333313B91458419A9999994E26294133333313B9145841CDCCCCCC0E2629419A999999B91458419A999999DA25294166666646BA14584166666666A52529419A9999F9BC1458419A99999957252941333333F3BD1458413333333303252941CDCCCC0CBD145841666666669E242941CDCCCCCCBA145841CDCCCCCC79242941666666C6B7145841333333335624294100000000B91458419A9999993A24294100000000BA145841000000003924294166666646BA1458419A9999992C242941CDCCCCACBC14584133333333EB23294100000000B91458419A999999702329419A9999F9B2145841000000007822294133333313A61458419A9999992222294166666626A314584166666666E821294133333373A01458416666666680212941666666E69A145841666666662D2129419A99991996145841CDCCCCCCD7202941CDCCCCCC901458419A99999986202941000000808C1458413333333380202941666666468F1458410000000064202941000000409B1458413333333361202941666666E69D145841333333335A202941CDCCCC4CA0145841666666664E202941CDCCCC4CA5145841000000004C20294100000080A7145841666666664C20294100000020AB1458419A999999472029419A9999F9AC14584166666666492029419A999959B01458419A9999994A20294133333373B2145841333333334C202941666666A6B51458419A9999994E20294166666646BA14584133333333562029419A999999BF145841333333335920294166666686C1145841000000005C2029419A999979C31458410000000063202941000000C0C6145841666666666620294166666646C81458410000000076202941CDCCCC0CCF145841CDCCCCCC8F202941333333D3D81458419A9999999120294100000080DB145841666666668E20294100000000DD145841666666668E2029419A9999F9DD145841666666668F2029419A999959EF1458416666666692202941CDCCCC0CF11458413333333396202941666666E6F3145841CDCCCCCC972029419A999959F9145841CDCCCCCC9A202941333333D3FC1458410000000098202941CDCCCC2CFF1458419A99999980202941333333930B155841000000007D202941666666860D1558413333333379202941CDCCCC2C111558413333333372202941CDCCCC2C1E155841666666667220294100000080221558413333333374202941000000C0261558419A999999782029419A9999592C155841666666660B2029419A9999F9471558419A999999C41F2941666666E6591558419A9999998A1F294133333393681558419A999999731F29419A9999596E155841CDCCCCCCC91E2941666666469915584100000000BA1E2941666666469D15584166666666E81D2941CDCCCC4CD215584133333333091E294133333353D115584133333333CB1E294100000060CF15584100000000F21E29419A9999F9CE15584133333333391F294166666646CE15584166666666D51F294166666646CC155841CDCCCCCC0D20294166666686CB15584133333333B2202941CDCCCC6CC9155841000000008F212941CDCCCC8CC61558419A9999991F222941CDCCCCACC41558413333333399232941666666C6BF1558419A9999991124294133333333BE155841000000003A242941CDCCCCACBD15584133333333CB24294133333333E9155841CDCCCCCC2E25294133333313071658416666666692252941333333F32416584133333333F6252941CDCCCCCC4216584100000000332629419A9999F954165841000000003F262941333333935816584100000000362729410000004074165841000000002D282941CDCCCCEC8F1658410000000077292941CDCCCCACAA16584100000000BF29294133333393B616584100000000C22B2941CDCCCC2C0B17584166666666312C2941CDCCCCCC1D175841333333337B2D29419A99999957175841333333337E2E2941000000C09517584166666666A72E2941666666E6B017584166666666E02E294166666606F317584133333333CE2E29419A9999590118584166666666992E2941666666661418584100000000772E29410000006018185841CDCCCCCC402E29410000006028185841000000002C2E29419A999939291858419A9999991B2E29419A9999192C18584100000000CE2D29419A99995935185841CDCCCCCCBE2D29419A9999F93818584166666666C22D2941CDCCCC0C3B18584166666666162E29419A9999F938185841000000004A2E2941666666463618584166666666612E29410000000035185841666666668E2E2941666666C63118584133333333AE2E2941000000402E18584133333333C02E2941CDCCCC2C2B18584166666666D92E2941CDCCCC2C2618584100000000F82E29419A9999791E1858419A999999112F29413333333317185841CDCCCCCC302F2941000000E00C185841CDCCCCCC342F2941000000A00B1858419A9999994D2F2941000000600D185841CDCCCCCC572F2941666666260D18584133333333672F29419A9999190C1858419A999999892F29419A999979081858419A999999BC2F29410000004002185841666666660230294100000020F9175841CDCCCCCC09302941CDCCCC2CF81758416666666632302941CDCCCC4CF3175841666666664F30294100000040F01758419A9999996130294133333333ED17584133333333A13029419A999959DB17584100000000FF30294133333313BF1758413333333326312941CDCCCCCCB31758419A9999991B322941000000608D175841333333332A322941333333938A17584133333333493229419A9999F9831758419A999999673229419A9999D97D1758410000000073322941333333D37A1758419A999999943229419A9999F96517584100000000F7322941666666664F175841333333331E3329410000006045175841666666663B3329419A9999193A17584133333333CE3529416666662632175841333333338A3B2941000000C02A1758419A999999613B294133333333FF16584100000000243B2941666666C6D01658419A999999233B2941000000E0CE1658419A9999992B3B294133333393CC16584166666666303B294166666606CB16584133333333313B294100000080C91658419A999999313B2941000000E0C616584133333333323B2941CDCCCCECC316584100000000353B2941CDCCCC0CC1165841666666663F3B2941CDCCCCACBB1658419A999999493B294166666626B71658419A9999994C3B294100000000B6165841333333335C3B2941CDCCCCACAD1658419A9999996E3B29419A9999D9A7165841000000007B3B2941333333F3A316584133333333883B2941666666A69F16584166666666953B29419A9999599B16584100000000AF3B29419A9999F99216584100000000C63B2941CDCCCC6C8D1658419A999999CE3B2941CDCCCC0C8B16584100000000CD3B29419A9999398616584166666666CE3B2941333333B38316584133333333D33B2941333333F3801658419A999999D43B2941333333737F16584133333333E23B294166666606771658419A999999E63B29419A9999B97016584166666666EB3B2941333333F36F1658419A999999ED3B29419A9999996F1658419A999999F33B2941666666066D16584100000000F83B2941CDCCCC2C6B1658419A999999053C29413333333363165841CDCCCCCC113C2941333333735D16584100000000213C29419A9999B952165841333333332C3C2941000000004C165841CDCCCCCC2E3C2941000000604A165841CDCCCCCC363C2941333333B345165841CDCCCCCC3B3C2941CDCCCC2C42165841CDCCCCCC3E3C2941666666C63F16584166666666613C29416666662629165841CDCCCCCC6E3C2941000000401F16584100000000743C2941333333731A165841333333337B3C2941000000001716584100000000803C29416666668613165841666666668A3C2941000000C00B1658419A999999C33C294133333333EB15584166666666C53C294133333333E915584166666666C43C2941333333F3E61558419A999999CC3C2941333333D3E115584166666666E03C2941666666E6D71558419A999999E73C29419A999959D215584166666666F43C2941000000A0CA15584100000000F83C294133333313C51558419A999999FB3C2941666666A6C2155841333333333C3D29419A999959961558419A999999983D29419A9999B95815584166666666A23D2941333333F3511558419A999999F63D29419A9999F916155841333333332B3E294166666626EF145841333333334D3E294166666646D51458419A9999998E3E2941CDCCCC2CA3145841');
INSERT INTO commune VALUES ('30870', 'Clarensac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
INSERT INTO commune VALUES ('30980', 'Langlade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
INSERT INTO commune VALUES ('30730', 'Gajan', '30122', '30', '01060000206A080000010000000103000000010000000B0200009A999999C96C2841666666467413584133333333C26C284100000020711358419A999999836C2841000000405613584133333333546C28419A9999D94113584166666666CE6C284133333393171358419A999999F76C284166666626F6125841CDCCCCCC086D284133333313E8125841CDCCCCCCF96C28419A999919E4125841CDCCCCCCD56C284133333393DA1258419A999999B86C28419A9999D9D212584166666666616C2841333333F3BB125841666666664B6C2841333333D3B312584100000000416C28419A9999F9AF12584100000000326C284133333353AA12584133333333296C284100000000A7125841CDCCCCCCFF6B2841CDCCCC6C971258419A999999FC6B28419A9999199712584166666666F66B2841333333D395125841CDCCCCCCE36B2841CDCCCCCC9012584166666666D46B2841666666268D1258419A999999BF6B28419A9999598912584100000000AD6B2841CDCCCCAC851258419A999999966B28416666664682125841333333337F6B2841333333937E125841666666665A6B2841333333737812584100000000376B28416666666672125841CDCCCCCC216A2841000000A03B12584166666666FB6928419A99999933125841CDCCCCCCE3692841000000802C12584166666666B0692841CDCCCC2C1E1258419A9999998A692841333333F3121258413333333380692841000000C00E12584100000000646928416666664609125841000000004E6928410000000005125841333333332969284166666606F8115841CDCCCCCCE96828419A999959C511584133333333D86828419A999939B711584133333333AE682841000000C09511584166666666AA682841333333B39211584100000000A76828419A9999B991115841CDCCCCCC9D6828410000004090115841000000008D682841666666468E11584166666666726828419A9999598B1158419A99999966682841CDCCCCEC89115841666666664D682841333333F386115841CDCCCCCC2D682841333333138311584166666666266828419A99995982115841333333330D682841333333F37F11584100000000DC6728419A9999397B11584100000000CF6728419A9999F9791158419A999999A86728416666664676115841000000008B672841333333D37311584166666666726728416666660672115841666666665D672841CDCCCC6C701158419A9999993D672841000000C06D1158410000000013672841333333536A11584166666666F0662841333333F36611584133333333D5662841CDCCCC8C6411584166666666B06628419A99999961115841CDCCCCCC90662841CDCCCCCC5E115841CDCCCCCC7C662841CDCCCCCC5C115841000000006A662841000000205B115841000000005C662841666666C6591158419A9999995266284133333333591158419A99999941662841CDCCCC6C58115841CDCCCCCC13662841CDCCCC6C5311584166666666B9652841666666864911584133333333AC6528419A9999794C11584133333333A0652841333333734F115841333333339C65284100000060501158419A99999994652841CDCCCC2C521158419A999999826528416666664655115841CDCCCCCC756528419A99993957115841000000006F65284100000040581158413333333359652841CDCCCCCC5A11584166666666496528419A9999B95C115841CDCCCCCC41652841333333B35E11584100000000336528419A9999F9611158413333333324652841666666666511584100000000166528419A999979681158413333333304652841666666E66B11584100000000FA642841000000006F115841CDCCCCCCF9642841333333B37011584133333333F9642841CDCCCCEC7211584133333333FA6428419A9999F9731158419A999999FF64284166666686741158419A999999066528419A99995975115841666666660E652841666666E67611584166666666146528419A9999F9791158416666666616652841666666E67C1158416666666615652841666666A67F11584100000000126528419A99997982115841CDCCCCCC0D652841666666C6841158419A9999990C652841CDCCCC8C87115841000000000C652841666666068B115841CDCCCCCC0E652841000000A08D115841333333330E652841000000A08F115841CDCCCCCC0B652841CDCCCC6C921158413333333307652841CDCCCCEC95115841CDCCCCCC0465284100000040981158413333333301652841333333339B11584133333333FE642841333333739D115841CDCCCCCCF86428419A9999399F11584166666666EF64284133333353A11158419A999999EC64284100000020A311584166666666E56428419A999979A411584133333333DB64284133333373A511584133333333CF642841CDCCCC6CA711584100000000C464284166666686A911584166666666B9642841CDCCCC2CAD11584166666666AC64284166666686B011584133333333A66428419A9999F9B11158419A9999999F642841CDCCCCACB31158410000000091642841000000E0B61158419A999999816428419A9999D9B911584166666666736428419A999919BC115841000000006E642841333333F3BC115841CDCCCCCC5F642841CDCCCCECBE115841000000005064284100000040C01158410000000049642841CDCCCC0CC111584100000000486428419A999999C2115841333333334A642841CDCCCC8CC5115841CDCCCCCC4B6428419A999939C8115841333333334E64284166666626CA115841CDCCCCCC4D642841CDCCCCCCCB115841000000004764284133333353CF1158410000000037642841CDCCCCECD4115841000000002F64284133333373D8115841333333332D642841CDCCCC4CD9115841666666662A64284100000040DB115841CDCCCCCC2B642841000000C0DC115841333333332C6428419A999919DE115841666666662B642841000000E0DE115841333333333664284166666606E3115841666666663B64284133333353E6115841333333333B6428419A999999E81158416666666639642841CDCCCCECEB1158419A999999376428419A999979EE1158419A9999993A64284133333393F0115841CDCCCCCC3D64284166666666F21158419A9999993C6428419A9999D9F4115841000000003A64284100000080F81158416666666635642841666666E6FB115841666666663364284100000040FF1158419A9999993564284133333373021258416666666636642841CDCCCC4C05125841CDCCCCCC346428410000000008125841333333332F6428419A9999190B125841666666662C642841666666060F125841666666662764284133333333131258419A999999246428410000004017125841666666661E642841000000001B125841000000001B642841333333B31E1258413333333319642841666666261F12584133333333156428416666664620125841000000000B642841000000C0201258419A999999FD632841CDCCCCEC2012584133333333E5632841000000002212584100000000CE632841000000C02312584166666666B36328413333339326125841CDCCCCCC9C6328419A9999192A125841333333338E632841333333132D1258419A9999997C632841000000E0301258419A99999968632841000000A03412584133333333596328419A9999D9361258419A99999943632841CDCCCCEC381258413333333321632841CDCCCC2C3C1258419A99999905632841666666463F12584133333333E96228419A9999994312584166666666CE622841CDCCCC6C4912584166666666B3622841000000204E125841CDCCCCCCA062284133333393521258419A99999995622841CDCCCCEC541258419A99999988622841333333D3571258413333333379622841CDCCCCAC5A1258413333333365622841CDCCCCCC5D1258410000000057622841CDCCCCEC5F1258419A999999446228419A9999996112584133333333306228419A9999B96312584166666666176228419A9999B9661258419A99999909622841CDCCCC0C6912584133333333FC6128419A9999D96A12584100000000F1612841333333936B12584166666666D56128419A9999796C12584133333333BF612841000000406D12584100000000A6612841CDCCCC0C6E1258416666666686612841000000E06E125841CDCCCCCC7D612841000000206F12584100000000716128419A9999796F1258413333333363612841333333936E125841000000005F6128419A9999196E125841000000005C612841000000C06D125841666666664D612841333333136D125841666666663C612841000000A06C125841000000002E6128419A9999796C125841333333332B612841333333736C1258419A9999991A6128419A9999596C125841666666660B6128419A9999996C12584133333333FE602841CDCCCCCC6C12584133333333F56028419A9999F96C1258419A999999C3602841000000E06D125841666666666B602841333333736F12584133333333256028410000008070125841CDCCCCCC0460284100000000711258419A999999C95F2841666666067212584166666666B25F28413333337372125841000000004A5F28419A9999197412584166666666EB5E2841666666C675125841000000009F5E2841CDCCCCEC76125841333333336E5E28416666666677125841333333335B5E28419A9999B97712584100000000055E2841000000207912584166666666B05D2841000000E07A12584100000000915D2841000000A07B1258419A9999995D5D2841000000407C12584133333333275D2841333333F37C12584100000000165D2841000000A07D125841666666660C5D2841333333F37D12584100000000045D2841CDCCCC2C7E125841CDCCCCCCF75C2841000000607E125841CDCCCCCCF05C28419A9999597E1258419A999999EA5C2841000000207E125841666666663D5C2841666666468012584166666666C75B28419A9999B9811258419A999999AC5B2841CDCCCC0C821258419A9999998B5B28419A9999998212584166666666515B2841666666A68312584166666666085B2841CDCCCCEC8412584100000000985A2841666666E68612584133333333505A28419A99993988125841CDCCCCCC175A284166666606891258419A999999DF592841000000A08912584133333333A0592841666666468A1258410000000059592841666666668B1258419A99999923592841666666868C12584100000000EE582841CDCCCC6C8D12584133333333CB582841000000008E125841333333339B5828419A9999598E1258416666666688582841666666868E125841333333335F582841333333338F12584166666666295828410000000090125841CDCCCCCC0A582841000000A0901258419A999999FC572841333333D39012584100000000ED572841000000A090125841CDCCCCCCC0572841CDCCCC2C91125841CDCCCCCC8C5728419A9999D991125841333333335557284133333393921258419A9999993C572841000000E092125841000000002E5728419A9999D9921258419A9999991D5728419A9999F99212584133333333F15628410000000094125841CDCCCCCCA9562841CDCCCCEC941258410000000064562841666666E695125841000000002A562841666666C69612584133333333F25528419A9999799712584133333333AF55284133333393981258419A99999958552841666666069A125841CDCCCCCC22552841666666C69A12584100000000ED542841000000809B125841CDCCCCCCD75428419A9999D99B125841CDCCCCCCCB542841000000E09B1258413333333392542841000000409C125841333333336D542841CDCCCCAC9C1258413333333342542841333333339D1258416666666620542841CDCCCCCC9D1258413333333301542841333333739E1258419A999999F6532841666666A69E12584166666666EC532841333333D39E1258419A999999CD532841CDCCCC4C9F125841CDCCCCCCBE532841666666669F12584100000000B2532841333333339F12584133333333A9532841666666E69E1258413333333384532841000000A0A312584166666666505328419A999919AA12584166666666145328419A999979B1125841CDCCCCCCF45228419A999939B512584166666666F05228419A9999B9B512584100000000D4522841333333F3B81258419A999999B652284166666686BC125841CDCCCCCC8C52284133333353C1125841CDCCCCCC6252284166666686C6125841CDCCCCCC3C522841CDCCCC8CCA1258410000000039522841333333F3CA125841333333331C52284166666626CE12584133333333FF5128419A9999B9D112584166666666E1512841333333D3D512584166666666BD51284133333353DB125841CDCCCCCC9D51284100000020E0125841666666668251284100000080E3125841333333336351284166666606E81258410000000043512841CDCCCC0CEC1258413333333328512841CDCCCCECEE125841666666661A51284133333313F0125841CDCCCCCC08512841666666A6F012584133333333FC502841333333D3F012584100000000E6502841333333B3F0125841CDCCCCCCD650284100000080F2125841CDCCCCCCCD502841000000A0F3125841CDCCCCCCC3502841666666E6F412584100000000B1502841333333D3F71258419A999999A15028419A999979FA125841CDCCCCCC935028419A999919FC125841000000008550284166666646001358413333333374502841666666E6041358413333333338502841CDCCCCAC1513584100000000E54F2841CDCCCC6C1F13584133333333CD4F2841CDCCCCCC21135841CDCCCCCC444F2841333333B33013584133333333B84E28410000000040135841000000006D4E2841666666C64813584133333333454E2841000000A04D13584133333333374E28419A9999394F135841000000002B4E28419A9999595013584166666666244E28419A9999995013584100000000114E2841CDCCCCCC5213584133333333FC4D2841CDCCCC2C5513584166666666EA4D2841CDCCCCAC5513584100000000C84D284100000020571358419A9999998E4D2841333333135A13584166666666514D28419A9999D95D13584100000000394D2841CDCCCCAC5E135841000000002D4D2841CDCCCCCC5E1358419A999999244D2841666666C65E1358419A999999184D2841000000005F13584166666666214D2841CDCCCCAC60135841333333333A4D2841CDCCCC4C67135841CDCCCCCC874D2841333333B37813584100000000A24D2841333333137F13584166666666EA4D2841333333B38F135841CDCCCCCC1C4E2841CDCCCCCC9B13584100000000224E2841333333139D135841333333334F4E28419A999999A71358419A999999664E284166666646AD13584100000000874E284166666686B313584133333333B44E284133333353BC13584100000000CA4E284133333353C013584100000000CD4E2841666666E6C013584133333333DF4E284100000040C4135841000000000B4F284133333353CC13584133333333184F28419A999979CE135841000000001F4F284133333373CF13584133333333364F2841333333D3D2135841000000003E4F2841333333F3D3135841666666665E4F284133333373D813584166666666844F284100000060DD13584166666666A84F2841CDCCCC0CE2135841333333333A50284166666626F5135841000000004250284100000020F6135841666666663750284133333393F7135841666666662850284166666626F9135841000000001550284100000060FA1358413333333349502841CDCCCC6C0814584166666666655028419A9999391014584100000000775028419A99999916145841333333337A50284100000080181458419A999999825028419A99991918145841333333338A502841666666A61A145841333333339E5028419A9999B9201458419A999999BC502841666666062814584100000000D5502841CDCCCCAC2D14584133333333EB5028419A999979331458419A999999FD502841333333F3381458419A999999075128419A9999193A1458413333333307512841666666E63A145841000000000E512841333333333D14584100000000265128413333339344145841000000003E512841CDCCCC6C48145841666666665E5128419A9999794F1458419A99999966512841CDCCCC2C511458413333333368512841666666A652145841000000006D512841333333D354145841000000007151284133333393561458410000000075512841000000605814584100000000E851284166666626661458419A999999F651284100000020671458419A999999435228419A9999197014584133333333495228416666662670145841CDCCCCCC4D522841CDCCCC6C701458419A99999957522841CDCCCC8C711458419A99999995522841000000C079145841CDCCCCCC9D522841CDCCCCEC7A14584166666666D3522841CDCCCCAC841458419A999999DC5228419A99995986145841CDCCCCCCE8522841CDCCCC8C881458413333333305532841333333B38D145841000000001D5328416666660692145841CDCCCCCC345328419A999999961458419A99999953532841CDCCCC0C9414584166666666D853284133333353AD1458419A999999095428419A9999F9BF1458413333333340542841333333B3D41458416666666658542841333333B3EB145841666666665C54284100000080EF145841333333336154284166666606F4145841CDCCCCCC71542841CDCCCCEC03155841000000007A542841000000A00B155841CDCCCCCCA1542841000000401F155841CDCCCCCCC0542841666666A62E15584166666666D25428413333335337155841CDCCCCCC05552841333333B350155841CDCCCCCC2A552841333333136315584166666666CD542841333333D36D155841000000004A532841333333739A1558410000000052532841000000209B1558410000000062532841000000409C155841CDCCCCCC745328419A9999999D155841333333338B532841666666C69F15584100000000C053284100000000A51558419A999999F953284133333373AB155841666666660D542841CDCCCCACAD155841CDCCCCCC3854284133333353B215584133333333515428419A9999B9B51558410000000058542841666666C6B61558419A99999964542841CDCCCCCCB8155841666666666D54284100000080BA155841CDCCCCCC98542841000000E0C21558419A999999B554284100000000C815584166666666C154284133333313CA1558419A999999E25428419A9999B9CF15584100000000015528419A9999B9D41558416666666616552841666666A6D9155841CDCCCCCC33552841CDCCCC8CE1155841666666664D55284100000020E71558413333333378552841CDCCCCCCF01558419A999999B7552841CDCCCC2CFE15584166666666E0552841CDCCCCEC0516584166666666EB5528410000000008165841CDCCCCCC1C562841666666A6111658413333333329562841666666C61316584100000000355628416666668615165841000000003C562841CDCCCCEC131658419A999999575628410000008011165841CDCCCCCCB15628419A9999B90916584100000000FD562841333333F3021658410000000017572841CDCCCC4C001658419A99999925572841CDCCCC2CFE15584100000000425728419A999919F91558419A9999995A572841000000C0F41558419A9999995F572841666666E6F3155841CDCCCCCC6B57284166666606F21558410000000075572841CDCCCCACF0155841000000009757284100000020EB15584100000000AC57284100000080E715584100000000BB572841333333B3E5155841CDCCCCCCDA572841CDCCCCCCE315584133333333115828419A999959E115584133333333575828419A9999D9DD1558416666666685582841CDCCCC2CDB155841333333338F582841333333D3DA15584100000000FE5928419A9999B9F015584133333333495A28419A999939F5155841333333331C5B2841333333D301165841000000006D5B2841666666A606165841CDCCCCCC9C5B2841CDCCCCEC0D165841CDCCCCCCA95B2841666666E60F16584100000000C75B2841CDCCCCEC13165841CDCCCCCCD15B284100000060151658419A999999F75B2841666666861A16584133333333CB5C284100000080371658419A999999B55D2841666666C64D16584133333333205E284166666626381658419A9999993D5E2841333333F332165841CDCCCCCC405E28410000004031165841CDCCCCCC6A5E28419A9999192816584133333333D15E2841CDCCCC4C14165841CDCCCCCC105F28419A9999D90716584133333333235F2841333333730316584133333333275F28416666668602165841CDCCCCCC675F28419A9999F9F51558419A999999765F284166666626F315584166666666C85F284166666646E31558416666666639602841CDCCCC4CCC155841CDCCCCCC5160284133333353C7155841CDCCCCCC7160284133333353C1155841666666667560284100000080C015584133333333BB612841333333B3801558419A999999E9612841333333F383155841666666663B622841333333B389155841CDCCCCCC58622841CDCCCCCC8B155841666666666A622841CDCCCC0C8D15584133333333A5622841000000A09115584166666666BD622841666666A693155841CDCCCCCCFB622841333333D3981558419A999999FF6228416666662699155841000000004E632841333333D39F155841333333335C632841CDCCCC0CA1155841666666668B63284133333353A51558416666666629642841000000207C155841666666662F642841333333937A155841CDCCCCCC3A6428419A99999977155841CDCCCCCCC7642841000000E052155841CDCCCCCCD06428419A9999595015584166666666DA642841666666E64D155841CDCCCCCCE7642841666666064B15584133333333F3642841333333B347155841333333330065284166666626441558419A9999990B65284166666646401558416666666619652841CDCCCCCC3C155841CDCCCCCC1F652841CDCCCC0C3B155841CDCCCCCC42662841666666E6F0145841CDCCCCCC65672841CDCCCCCCA6145841CDCCCCCC6A672841000000E0A1145841333333338E672841333333537F1458419A9999999C672841CDCCCC4C711458419A99999997672841000000605F145841CDCCCCCC88672841000000602A1458419A999999E0672841000000C01E1458413333333360682841000000E00D1458419A999999866828419A9999B90814584133333333C9682841333333D3FF13584100000000F26828419A999959FA135841666666662F692841CDCCCC2CF2135841CDCCCCCCE869284133333313FF13584100000000796A28419A9999F90714584166666666AD6A2841CDCCCCEC0214584100000000B56A2841333333330214584100000000DB6A2841CDCCCC8CFE135841CDCCCCCCBE6C28419A9999F9CF135841CDCCCCCCBC6C284166666686BA13584133333333BA6C28419A9999D99F13584100000000B96C2841666666269113584166666666B86C2841666666068C1358419A999999C96C28416666664674135841');
INSERT INTO commune VALUES ('30190', 'Dions', '30102', '30', '01060000206A08000001000000010300000001000000C3020000333333330795284100000000E2135841000000001693284166666626FC1358419A99999946922841333333730014584166666666CC912841000000E005145841000000006D912841000000200A1458413333333312912841666666260E145841CDCCCCCC00912841333333930E14584166666666A5902841666666E610145841666666664D9028410000002013145841666666668D8F28419A9999F91714584100000000288F2841333333F31E1458419A999999198F2841000000002014584133333333BE8E2841666666262614584166666666718E2841333333532B14584100000000E68C2841CDCCCCEC451458419A999999428C28419A9999994E14584100000000C18B2841000000805514584100000000748B28419A99999959145841CDCCCCCC048B2841000000805F14584166666666F78A28419A99993960145841666666665C8A2841333333B368145841666666661E8A28419A9999196C145841CDCCCCCC7A89284133333313751458419A9999991A892841000000607A14584166666666A28828419A9999F980145841000000003E8728416666668694145841CDCCCCCC63862841000000C0A114584100000000D48528419A999979AA1458419A9999998484284133333393D314584166666666B2832841CDCCCC4CED1458419A99999965832841000000C0F61458419A9999995C832841333333D3F71458413333333335832841CDCCCCACFC1458419A9999991D83284100000060FE1458410000000007832841000000000015584133333333E88228419A99993902155841000000003A8228419A9999B90E155841000000003882284133333373171558413333333339822841666666461A155841CDCCCCCC3B8228419A9999392015584166666666418228419A9999592D1558416666666642822841CDCCCCCC2F1558419A99999954822841000000605A155841CDCCCCCC5B82284133333353601558419A9999996182284133333313621558413333333369822841CDCCCC2C641558419A999999778228419A9999996C15584100000000868228419A99995974155841666666668F822841CDCCCC6C7A1558419A99999993822841333333537D1558416666666640822841333333939B1558416666666645822841CDCCCC8CA21558416666666648822841CDCCCC8CA615584133333333E081284100000000AB15584100000000CE812841CDCCCCCCAB155841000000009B812841333333D3C015584100000000BF812841333333D3C11558410000000096812841333333D3CD15584166666666718128419A999919D91558419A9999994B812841CDCCCC0CDF155841000000004A812841CDCCCC4CEE1558419A9999990A81284100000020F915584166666666FA802841CDCCCCACFC1558419A999999BD802841333333130A165841CDCCCCCC90802841CDCCCC8C141658419A9999994E802841000000C02916584166666666388028419A9999B934165841000000003E802841CDCCCC6C351658413333333341802841CDCCCC8C361658419A999999418028410000004038165841CDCCCCCC408028419A9999793F16584166666666408028410000002042165841333333334180284100000080491658419A999999418028419A9999D94A1658419A99999940802841CDCCCCAC4D1658416666666636802841CDCCCC6C4F1658419A9999992A802841CDCCCCCC4F165841CDCCCCCC1C8028410000000051165841CDCCCCCC0F802841000000605216584133333333FA7F28416666668655165841CDCCCCCCEC7F284133333353581658419A999999E87F28419A999939591658419A999999D77F2841333333535C16584166666666C77F2841666666665E165841CDCCCCCCB97F2841333333335F16584133333333A07F284166666666601658419A999999867F28410000004061165841000000006F7F2841CDCCCC0C62165841666666664D7F28419A999979631658419A999999527F2841333333536A165841CDCCCCCC067F28419A99991980165841CDCCCCCCE27E2841CDCCCCEC8B16584166666666937E28410000004092165841000000006C7E2841CDCCCC0C9B16584166666666337E284133333313D3165841666666668B7D2841CDCCCC6C0417584166666666417D2841666666461D175841000000002D7D2841666666861C1758419A999999127D2841CDCCCC8C1B17584166666666167D2841000000403017584133333333F97C2841666666463A17584166666666A57C2841000000804E17584100000000017B2841333333F3A417584133333333E27A284166666666AD17584133333333D07A28419A999939B5175841333333337B7A284100000000D8175841CDCCCCCC1C7A2841333333331118584133333333377A2841666666867818584100000000447A2841CDCCCCCCAD18584133333333567A28419A9999B9AF185841CDCCCCCC6C7A2841666666E6B1185841333333338F7A2841CDCCCCCCB41858419A999999AB7A284100000040B7185841CDCCCCCCD47A284100000060BB18584100000000F07A2841CDCCCC2CBE185841000000000E7B2841000000C0C118584100000000237B2841666666E6C418584100000000357B284133333353C818584133333333467B284133333373CB18584166666666547B284166666646CE1858419A999999677B28419A999959D118584133333333907B284100000000D61858419A999999B27B28419A999999DA185841CDCCCCCCC37B2841000000A0DC1858419A999999D17B284100000040DE185841CDCCCCCCDF7B2841CDCCCC2CDF18584133333333ED7B2841000000A0DF1858419A999999937C2841333333D3F3185841333333333C7E2841333333B32919584100000000EB7E2841666666263C1958419A999999FA812841CDCCCCAC82195841CDCCCCCC278228416666666688195841CDCCCCCC46832841CDCCCC2CBD195841000000008A8328419A999939CA195841333333331784284166666666B8195841CDCCCCCC508528416666664697195841666666661986284133333353821958419A999999108728413333333369195841000000005A8728419A99991960195841333333336B872841333333735D195841000000007C872841333333D35A195841333333339B87284166666666561958419A999999B5872841000000005319584133333333C7872841333333135119584100000000E28728419A9999D94D19584100000000058828413333339349195841CDCCCCCC1E882841000000A046195841CDCCCCCC338828413333337344195841CDCCCCCC44882841666666E6421958419A999999598828410000004041195841000000006A882841000000A03F1958413333333382882841000000E03C195841CDCCCCCC96882841666666C63A19584100000000B4882841CDCCCC6C3819584133333333D7882841CDCCCC6C3519584100000000018928410000008031195841333333331E892841CDCCCC6C2E1958416666666636892841CDCCCC0C2C19584133333333548928419A9999B929195841CDCCCCCC668928416666660628195841CDCCCCCC708928419A9999D9261958416666666679892841000000602519584166666666D38A2841666666060B19584133333333FD8A2841666666460C1958419A9999990A8B2841666666E60A195841CDCCCCCC148B2841666666C60919584100000000238B2841CDCCCC6C08195841333333333C8B2841CDCCCCAC05195841CDCCCCCC458B284166666666041958419A999999518B28419A9999F90219584100000000628B2841666666860019584133333333748B28419A999939FD185841333333337D8B28419A999919FB185841333333338A8B2841CDCCCC4CF9185841CDCCCCCC9A8B2841CDCCCC2CF718584133333333A88B28419A999959F5185841CDCCCCCCB38B2841CDCCCC6CF318584100000000C18B2841CDCCCC6CF118584133333333CE8B2841CDCCCCACEF185841CDCCCCCCD88B2841CDCCCC8CED18584133333333DF8B284133333333EB18584100000000E98B28419A999979E918584166666666F98B2841666666C6E718584133333333148C2841666666A6E5185841666666661F8C28419A999959E5185841000000002A8C2841CDCCCC2CE518584100000000358C284100000000E518584166666666438C284133333373E41858419A9999994D8C2841000000C0E318584166666666588C2841666666A6E218584100000000678C284100000080E118584133333333738C2841CDCCCC2CE01858419A999999808C2841000000E0DE18584133333333898C2841333333B3DD185841666666668D8C284166666626DC185841333333338D8C284100000080DA18584133333333918C28419A999919D91858419A999999998C2841333333B3D71858419A999999A18C2841666666A6D618584166666666A88C28419A999959D518584133333333AD8C284100000040D41858419A999999B48C2841CDCCCCACD21858419A999999BA8C2841CDCCCC0CD118584166666666BD8C2841CDCCCCACCF1858419A999999C18C2841CDCCCCECCD1858419A999999C88C28419A999999CC1858419A999999D48C284133333373CB185841CDCCCCCCDE8C28419A999999CA1858419A999999ED8C2841000000A0C918584133333333F58C28419A9999F9C818584100000000038D284100000000C818584166666666168D2841333333F3C6185841CDCCCCCC208D284100000060C6185841666666662D8D2841CDCCCCACC5185841000000003B8D2841CDCCCCECC4185841666666664C8D2841CDCCCCCCC318584100000000608D2841CDCCCC8CC2185841000000006F8D2841CDCCCC4CC1185841666666667D8D284166666606C018584100000000888D284133333333BF18584166666666908D284100000020BE185841CDCCCCCC978D28419A9999F9BC18584133333333A58D2841000000C0BB18584133333333B18D28419A9999D9BA18584166666666C08D2841666666A6B918584100000000CF8D2841000000A0B818584166666666DC8D2841333333D3B618584166666666E68D2841000000A0B418584166666666EE8D284133333393B218584133333333F68D2841000000A0B018584133333333018E284133333333AE185841CDCCCCCC108E284100000020AA1858419A999999148E284100000040A9185841333333331B8E2841CDCCCCACA718584166666666238E28419A9999B9A518584100000000318E2841333333B3A3185841333333333D8E28419A999999A118584166666666458E2841666666869F185841000000004D8E2841333333739D18584100000000518E2841666666C69B185841333333334F8E28416666668699185841666666664F8E2841333333739718584166666666548E28416666662695185841000000005D8E2841CDCCCC0C9318584166666666668E2841CDCCCCEC90185841666666666F8E2841333333F38E18584166666666778E2841666666C68C18584166666666818E2841666666868918584166666666878E284133333313871858419A9999998E8E2841CDCCCCEC8418584100000000968E28419A999959821858419A999999988E2841000000007F185841000000009B8E2841CDCCCC2C7D1858419A9999999B8E2841000000E07B185841666666669D8E2841CDCCCC8C7A185841000000009F8E28419A9999597918584133333333A18E2841000000607818584133333333A38E2841666666267718584166666666A38E2841000000E0751858419A999999A58E284100000020751858419A999999AB8E2841CDCCCC4C74185841CDCCCCCCB68E2841CDCCCCEC7218584100000000BF8E2841CDCCCCAC7118584100000000C78E2841333333B37018584133333333CE8E2841666666866F18584133333333D58E2841000000E06D1858419A999999DC8E2841CDCCCC8C6C185841CDCCCCCCE48E2841333333736B185841CDCCCCCCEA8E2841666666E66A18584100000000F38E2841000000606A18584166666666F88E2841000000C06918584133333333018F2841CDCCCC8C68185841CDCCCCCC098F28419A9999B967185841CDCCCCCC168F2841CDCCCC8C661858419A9999991D8F2841CDCCCCAC6518584100000000268F2841666666066518584100000000308F2841CDCCCCAC63185841666666663A8F284166666686621858419A999999448F28419A99991961185841333333334B8F28419A9999D95F18584166666666518F2841000000005F185841CDCCCCCC568F2841666666465E185841333333335B8F2841000000005D185841CDCCCCCC608F2841000000205A18584166666666638F284100000000581858419A999999668F2841CDCCCC0C561858419A9999996A8F28419A9999B95418584133333333718F2841333333535318584166666666778F2841CDCCCC8C51185841CDCCCCCC7D8F2841CDCCCC6C4F185841CDCCCCCC868F28419A9999B94B185841CDCCCCCC8A8F28419A9999394A185841CDCCCCCC908F2841666666464818584100000000938F2841666666C64618584166666666968F2841666666E6451858419A999999998F28416666662645185841CDCCCCCC9C8F2841666666C643185841333333339E8F2841CDCCCCCC4218584133333333A28F2841666666C6411858419A999999A78F2841CDCCCCEC4018584133333333B38F2841666666A63E18584133333333BA8F28419A9999393D18584166666666C58F2841666666263B185841CDCCCCCCCE8F2841CDCCCC4C39185841CDCCCCCCD68F2841000000E03718584166666666E18F2841333333133618584100000000E88F2841CDCCCC0C351858419A999999F08F28419A9999F93318584133333333FA8F284100000000331858419A99999902902841CDCCCC2C32185841666666660B9028419A9999993118584166666666159028419A99991931185841333333331D902841000000E030185841CDCCCCCC2A9028416666668630185841333333332E902841CDCCCC0C2E185841CDCCCCCC30902841333333D32B1858419A999999329028413333337329185841000000003490284100000020251858410000000034902841666666A62118584100000000319028419A9999F91C185841666666662D902841666666E6181858416666666628902841000000E014185841CDCCCCCC1B91284133333393E1175841000000002B9128419A999959DE175841666666663091284100000040DC175841000000005291284133333353CF175841666666666691284133333373AA17584166666666579128419A9999799D175841CDCCCCCC57912841333333539C175841666666665B912841CDCCCC0C9A175841000000005C912841000000A098175841666666665E912841666666E6961758410000000061912841333333F39417584100000000629128410000004094175841CDCCCCCC62912841333333D39317584133333333649128419A999979931758419A99999964912841000000E092175841333333336591284133333353921758416666666664912841666666C691175841CDCCCCCC6591284100000060901758419A99999967912841333333F38E175841CDCCCCCC6B912841CDCCCC4C8C175841333333336F9128419A9999598A175841CDCCCCCC709128419A9999F987175841333333337291284100000060861758410000000075912841333333B3841758410000000078912841000000C0831758419A9999997A912841000000E082175841CDCCCCCC7F9128419A9999598217584133333333859128410000002082175841CDCCCCCC909128419A999979811758410000000095912841666666068117584166666666969128410000008080175841CDCCCCCC97912841000000E07F175841CDCCCCCC989128419A9999997E175841CDCCCCCC99912841CDCCCCCC7D1758410000000099912841000000807C175841CDCCCCCC97912841CDCCCC8C7B1758410000000095912841CDCCCCAC7A1758410000000090912841333333B379175841666666668D9128416666660679175841CDCCCCCC85912841CDCCCC6C78175841333333338F91284166666666781758419A99999999912841333333337817584133333333A0912841CDCCCC0C78175841CDCCCCCCA3912841666666A67617584100000000A99128416666666674175841CDCCCCCCAC91284133333313721758419A999999AF912841CDCCCC8C6F17584100000000B29128419A9999D96B17584166666666B4912841666666E66817584133333333B6912841333333B36517584100000000B89128419A9999F96217584100000000BA912841000000006017584133333333BC912841666666665C175841CDCCCCCCBE912841000000805917584166666666C0912841000000005717584133333333C2912841333333335417584100000000C3912841000000005217584166666666C4912841000000604F1758419A999999C6912841666666264D17584166666666C8912841333333734A17584100000000C99128413333339348175841CDCCCCCCCA912841CDCCCC4C45175841CDCCCCCCCB912841666666464317584133333333CC912841333333734117584166666666CD912841CDCCCCEC3F175841CDCCCCCCCE912841333333F33D17584100000000D1912841666666863B17584166666666D191284166666606391758419A999999D1912841666666C63817584166666666D2912841666666E63517584133333333D3912841000000A03317584166666666D4912841000000803117584100000000D7912841CDCCCC6C2E17584133333333D7912841333333D32C1758419A999999D6912841333333B32B17584133333333D59128419A9999192A1758419A999999CF9128419A999959281758419A999999CB912841333333132717584100000000CA9128410000004025175841CDCCCCCCC6912841000000A02317584133333333BD9128419A9999D9201758419A999999B1912841000000801D1758419A999999A4912841000000601917584166666666989128419A999939151758419A9999998A9128410000004010175841CDCCCCCC7E9128419A9999F90B175841000000007A912841333333D309175841CDCCCCCC749128410000004008175841333333336E912841CDCCCCAC05175841CDCCCCCC65912841333333F301175841000000005E9128419A9999B9FE16584133333333589128419A999939FB1658419A99999950912841CDCCCC6CF7165841CDCCCCCC4A91284166666686F4165841000000004A91284133333333F3165841CDCCCCCC4A912841CDCCCC4CF2165841CDCCCCCC4E912841CDCCCC2CF11658419A9999990F912841CDCCCC8CE716584100000000F9902841333333D3E5165841CDCCCCCCCC902841CDCCCC6CDF16584100000000B690284133333353DA16584166666666AF90284100000080D6165841CDCCCCCCA79028419A9999B9D216584100000000A0902841333333F3CF165841666666668E902841000000A0CC165841333333338E90284100000020CA165841000000009390284133333353C61658413333333399902841CDCCCC6CC4165841000000009990284100000060C2165841666666669190284100000060C11658419A99999974902841666666C6BF165841000000004F90284100000060BE165841CDCCCCCC2F902841333333F3BD16584133333333FF8F2841CDCCCC2CBF16584166666666D28F284100000020C1165841CDCCCCCC968F28419A999999C616584166666666808F2841666666A6C7165841CDCCCCCC5E8F28419A9999F9C716584166666666308F284100000040C616584100000000208F284166666686C4165841CDCCCCCC108F28419A999999C016584166666666F68E2841CDCCCCACBC16584133333333E28E284100000080BA16584133333333AC8E284100000080B7165841666666668A8E284133333313B6165841CDCCCCCC8B8E284133333313A116584100000000A68E2841333333939116584166666666B18E2841000000607E16584166666666918E2841000000207B1658419A9999998B8E2841CDCCCC6C6F16584100000000668E28419A9999795E16584100000000678E28419A9999995D16584133333333668E28419A9999395C16584166666666668E2841000000405B165841CDCCCCCC668E2841666666665A16584133333333668E28419A9999795916584166666666638E28416666666658165841000000005F8E2841666666C656165841333333335C8E28419A9999F954165841CDCCCCCC5A8E28419A9999B9531658419A999999578E2841333333335216584100000000568E2841000000E0501658419A999999558E2841000000A04F165841CDCCCCCC558E2841CDCCCC6C4C1658419A999999558E2841333333334C1658419A999999578E2841CDCCCC0C4A16584100000000598E28419A9999B948165841000000005A8E2841CDCCCCCC471658419A999999568E2841666666663E1658419A999999488E2841000000802E16584100000000428E28410000008027165841CDCCCCCC3C8E284100000040251658419A999999388E2841333333931A16584100000000278E2841333333F3EC15584133333333228E2841CDCCCCACE015584166666666A08E28419A999979C515584133333333EA8E284133333393B5155841CDCCCCCC498F2841666666E6A0155841CDCCCCCC648F2841333333139B15584166666666978F2841666666269015584100000000B28F2841CDCCCC6C8A155841666666665C9128419A9999B96F155841000000006A9128419A9999D96E1558419A999999A9922841333333D35A155841CDCCCCCCD5922841CDCCCC0C581558419A9999990693284100000000551558419A99999902932841000000805315584100000000FA922841333333735115584133333333FA9228419A9999794F155841CDCCCCCC009328419A9999594E1558419A9999990A9328419A9999594D1558413333333315932841CDCCCC6C4C1558419A99999923932841000000A04A1558419A999999239328410000006049155841CDCCCCCC219328419A9999D947155841000000002293284166666666461558416666666625932841000000E044155841000000002D932841666666064415584133333333399328419A9999D943155841CDCCCCCC439328416666664643155841CDCCCCCC4E932841CDCCCC2C431558410000000059932841666666C642155841000000005A9328410000008042155841666666665C932841000000E041155841000000005B932841333333F33F1558419A99999950932841000000A03D155841666666664A9328419A9999993B155841666666664A932841333333F3391558419A99999955932841CDCCCC6C381558413333333357932841CDCCCC6C371558410000000050932841CDCCCC0C36155841CDCCCCCC3E9328419A9999393415584166666666269328419A9999D93115584100000000189328419A999919311558419A9999990E9328419A999999301558419A99999902932841333333B32F15584133333333F4922841CDCCCC4C2E15584166666666EA922841CDCCCC6C2D15584166666666DC922841666666A62C15584100000000D2922841666666062D155841CDCCCCCCC8922841000000C02C15584166666666C4922841000000C02B15584100000000B7922841CDCCCCCC2B15584133333333AD922841333333F32A15584166666666A8922841000000E029155841333333339C922841CDCCCC4C29155841666666669092284133333393281558419A9999998A922841CDCCCC4C27155841333333338A922841333333F3251558419A99999981922841CDCCCCCC24155841CDCCCCCC7A9228416666666624155841666666667D922841CDCCCC4C2315584100000000869228419A999959221558413333333390922841CDCCCC8C21155841666666669B9228419A9999B9201558419A999999AB922841CDCCCC2C201558419A999999B79228419A9999D91F1558419A999999C6922841000000401F155841CDCCCCCCD2922841CDCCCC8C1E1558419A999999DB922841000000A01D15584100000000E39228419A9999191C15584133333333E7922841333333131B1558419A999999EC9228410000000019155841CDCCCCCCF2922841CDCCCC0C1715584100000000F8922841333333931415584133333333F9922841333333F3111558419A999999F8922841CDCCCC0C1015584133333333F09228419A9999390D15584133333333DC922841333333530915584100000000D79228419A9999790815584166666666D0922841CDCCCCEC0715584133333333C0922841333333F30315584100000000B5922841666666E60115584166666666B0922841000000C0FF14584133333333B29228419A9999D9FD145841CDCCCCCCB89228419A999959FB14584100000000C192284166666646F81458419A999999C39228419A999939F614584100000000C192284133333353F41458419A999999B3922841000000E0F014584100000000A792284133333393ED14584166666666A2922841000000A0EB1458419A999999A3922841666666C6E9145841CDCCCCCCA9922841333333F3E714584133333333AF922841CDCCCCCCE6145841CDCCCCCCB992284133333333E51458419A999999CD92284133333313E314584133333333DE92284100000080E214584100000000F092284166666686E214584100000000FA922841000000C0E21458413333333315932841CDCCCC0CE4145841000000001893284133333333E3145841000000001C93284133333333E21458410000000023932841CDCCCC0CE21458419A9999992A932841CDCCCC8CE1145841CDCCCCCC2D93284133333353E0145841000000002A93284133333373DF145841CDCCCCCC2E93284133333313DF1458419A9999992B932841666666E6DD14584100000000309328419A9999D9DC145841CDCCCCCC2C9328419A999939DC145841CDCCCCCC24932841CDCCCCACD81458419A999999229328419A999959D61458419A9999992493284133333313D1145841333333332C932841CDCCCC8CCE145841666666663293284133333333CD1458419A9999993F932841666666C6CC1458413333333349932841666666C6CC1458419A99999954932841333333F3CD145841CDCCCCCC5F93284166666666CF145841000000007E932841CDCCCC0CD21458419A9999998E9328419A999959D3145841333333339E932841CDCCCCCCD314584100000000B39328419A9999B9D31458419A999999C293284100000040D314584100000000D5932841666666E6D114584133333333EC93284166666626CF1458419A999999F7932841333333B3CC145841CDCCCCCC019428419A9999B9CA145841CDCCCCCC2894284100000080C51458413333333349942841000000A0C114584133333333709428419A9999D9BC145841CDCCCCCC7E94284133333373BA1458413333333384942841CDCCCCACB81458410000000087942841000000C0B6145841666666668994284166666646B5145841333333338D9428419A9999D9B2145841CDCCCCCC8E942841333333D3B0145841CDCCCCCC8F94284166666646AE145841000000008F942841CDCCCC6CAC14584166666666929428419A999979AB1458413333333399942841CDCCCC2CAA14584100000000A79428419A9999D9A9145841CDCCCCCCAE9428419A999979A9145841CDCCCCCCB6942841666666E6A81458419A999999C19428419A999939A81458419A999999C7942841CDCCCC8CA71458419A999999CC94284100000000A714584100000000D7942841CDCCCC4CA614584133333333E294284100000040A514584100000000EA94284100000000A41458419A999999F194284166666686A214584133333333F99428419A999999A01458410000000000952841333333539E145841CDCCCCCC05952841666666C69C145841000000000C952841CDCCCC4C9B145841000000000E952841000000A0991458410000000010952841333333939814584133333333199528419A99999996145841CDCCCCCC25952841000000E093145841000000002E9528419A999999911458416666666632952841000000808F1458419A99999934952841000000808D145841CDCCCCCC36952841666666468A145841CDCCCCCC38952841666666C685145841333333333A952841CDCCCC4C84145841666666663B952841666666C6821458419A99999937952841666666E680145841333333332B9528419A9999F97D145841CDCCCCCC20952841333333937C145841333333331C9528419A9999597B14584133333333199528416666664679145841CDCCCCCC17952841000000A07514584133333333189528416666668673145841000000001B9528419A99999971145841333333331C9528419A9999B96F145841333333331E9528419A9999596D1458416666666620952841666666A66B1458419A99999921952841000000A06914584133333333229528419A9999996814584166666666289528413333333367145841666666662D9528416666664666145841CDCCCCCC329528419A9999396514584133333333399528416666660664145841CDCCCCCC3F9528416666662663145841CDCCCCCC43952841CDCCCC6C611458416666666643952841333333135F1458413333333342952841666666A65D1458419A9999993A952841666666665C1458419A99999931952841000000005A145841333333332C952841666666C6571458413333333327952841333333F355145841666666662295284133333393531458416666666620952841CDCCCC6C51145841CDCCCCCC1F952841666666664F1458413333333325952841000000C04D145841333333332B952841333333534C145841666666662D952841666666C64A1458419A9999992F9528413333335349145841666666663395284100000020481458410000000035952841333333B3451458416666666632952841333333B343145841333333333695284100000060421458416666666633952841333333F340145841666666662A952841666666863F1458413333333327952841000000003E145841CDCCCCCC2A9528419A9999793C145841CDCCCCCC2D952841CDCCCC6C3B145841000000002F952841666666E63914584133333333319528419A9999F93714584100000000309528419A99995935145841CDCCCCCC2E952841CDCCCC2C34145841666666662B952841333333F3321458419A9999992995284166666626311458413333333327952841000000802F145841CDCCCCCC21952841CDCCCCEC2D1458416666666619952841333333F32B1458413333333312952841333333D32A145841CDCCCCCC0A952841666666062A145841CDCCCCCC0595284133333373291458416666666605952841CDCCCC0C28145841CDCCCCCCFF9428419A99999926145841CDCCCCCCF99428419A9999D92414584133333333FB9428419A9999D9211458419A999999FB942841666666862014584133333333FB942841666666661D14584166666666FA942841333333B31B14584166666666FA942841CDCCCC0C1A1458419A999999F9942841333333931714584166666666F99428419A999959151458419A999999FA942841333333731314584166666666FA942841666666061214584133333333F9942841333333F30F1458419A999999FD9428413333335301145841333333330795284100000000E2135841');
INSERT INTO commune VALUES ('30730', 'Fons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
INSERT INTO commune VALUES ('30129', 'Redessan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
INSERT INTO commune VALUES ('07200', 'Fons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

INSERT INTO adresse VALUES ('30189_3055_00001', '1 Rue Faraday', '30000', 'Nimes', '01010000206A0800008FC2F5A8EE9D284100000020650C5841');
INSERT INTO adresse VALUES ('30039_0157_00031', '31 Rue de la Tapie', '30320', 'Bezouce', '01010000206A0800003D0AD7A31E012941D7A370FD51125841');
INSERT INTO adresse VALUES ('30317_0055_00004', '4 Grand Rue', '30210', 'Sernhac', '01010000206A08000052B81E05812A294114AE4701B3155841');
INSERT INTO adresse VALUES ('30122_0041_00039', '39 Grand Rue', '30730', 'Gajan', '01010000206A080000EC51B89E7657284114AE4751B5135841');
INSERT INTO adresse VALUES ('30258_0022_00001_bis', '1 bis Rue Antoine Pages', '30800', 'Saint-Gilles', '01010000206A080000A4703D0A09E62841CDCCCCBC27FD5741');
INSERT INTO adresse VALUES ('30258_0023_00005', '5 Impasse des Andalous', '30800', 'Saint-Gilles', '01010000206A08000066666666B8E72841D7A3701DDB005841');
INSERT INTO adresse VALUES ('30258_b117_00005', '5 Chemin de Nimes Sud', '30800', 'Saint-Gilles', '01010000206A080000AE47E17ACADF284185EB51C873FD5741');
INSERT INTO adresse VALUES ('30258_0101_00006', '6 Rue Bellevue', '30800', 'Saint-Gilles', '01010000206A08000052B81E0537DE284133333333A5FB5741');
INSERT INTO adresse VALUES ('30258_0600_01198', '1198 Route des Iscles', '30800', 'Saint-Gilles', '01010000206A080000C3F5285C40ED2841295C8FF27EFA5741');
INSERT INTO adresse VALUES ('30258_0100_00007', '7 Impasse Bibette', '30800', 'Saint-Gilles', '01010000206A080000295C8FC26FE32841295C8F8254FC5741');
INSERT INTO adresse VALUES ('30258_0216_00002', '2 Traverse des Cigales', '30800', 'Saint-Gilles', '01010000206A080000AE47E1FA09E72841B81E855BA4FC5741');
INSERT INTO adresse VALUES ('30258_1207_00027', '27 Rue de Saint-pierre', '30800', 'Saint-Gilles', '01010000206A080000CDCCCCCCABE5284148E17AE433FD5741');
INSERT INTO adresse VALUES ('30258_0040_00014', '14 Rue Ancienne Poste', '30800', 'Saint-Gilles', '01010000206A080000000000003DE328410000008043FC5741');
INSERT INTO adresse VALUES ('30258_0461_00013_b', '13 b Rue de la Fontaine Gillienne', '30800', 'Saint-Gilles', '01010000206A0800003D0AD723F6DF28418FC2F5C8DAFB5741');
INSERT INTO adresse VALUES ('30258_0190_00002', '2 Rue du Chateau', '30800', 'Saint-Gilles', '01010000206A080000C3F528DC81E42841CDCCCC6C33FC5741');
INSERT INTO adresse VALUES ('30258_0006_00003', '3 Impasse de l''Aglandaou', '30800', 'Saint-Gilles', '01010000206A080000A4703D8A70DA2841333333E338FC5741');
INSERT INTO adresse VALUES ('30258_0933_00017', '17 Rue Plein Soleil', '30800', 'Saint-Gilles', '01010000206A08000048E17A94BEDF2841D7A3708D12FD5741');
INSERT INTO adresse VALUES ('30258_0090_04492', '4492 Route de Beaucaire', '30800', 'Saint-Gilles', '01010000206A080000713D0A5771EE2841CDCCCC9CC2FE5741');
INSERT INTO adresse VALUES ('30258_1157_00002', '2 Impasse la Rocaille', '30800', 'Saint-Gilles', '01010000206A0800006666666610DE2841CDCCCCBC0FFC5741');
INSERT INTO adresse VALUES ('30258_0870_00019', '19 Rue du Panier', '30800', 'Saint-Gilles', '01010000206A080000C3F528DCE3E32841A4703DCAEEFB5741');
INSERT INTO adresse VALUES ('30258_0172_00005', '5 Rue des Champs', '30800', 'Saint-Gilles', '01010000206A080000A4703D0A9FDC284185EB51986DFB5741');
INSERT INTO adresse VALUES ('30258_0215_00021', '21 Rue des Cigales', '30800', 'Saint-Gilles', '01010000206A080000B81E85EBB9E72841D7A370CDCDFC5741');
INSERT INTO adresse VALUES ('30258_0800_00011', '11 Rue Mirabeau', '30800', 'Saint-Gilles', '01010000206A0800008FC2F5A83FE22841EC51B8FE1FFC5741');
INSERT INTO adresse VALUES ('30258_0761_00005', '5 Rue du Marquis de Baroncelli', '30800', 'Saint-Gilles', '01010000206A080000A4703D0A13E2284148E17AD4E6FC5741');
INSERT INTO adresse VALUES ('30258_0280_00009', '9 Rue Doree', '30800', 'Saint-Gilles', '01010000206A080000F6285C0F98E328411F85EB81EEFB5741');
INSERT INTO adresse VALUES ('30258_0425_00015', '15 Rue Antoine de Saint-exupery', '30800', 'Saint-Gilles', '01010000206A080000D7A370BD1BDF28418FC2F59838FE5741');
INSERT INTO adresse VALUES ('30258_0101_00010', '10 Rue Bellevue', '30800', 'Saint-Gilles', '01010000206A080000F6285C0F56DE2841A4703D4A8DFB5741');
INSERT INTO adresse VALUES ('30258_0171_00036', '36 Rue de la Camomille', '30800', 'Saint-Gilles', '01010000206A08000052B81E8543D82841000000A0C7FB5741');
INSERT INTO adresse VALUES ('30258_0480_00029', '29 Avenue Francois Griffeuille', '30800', 'Saint-Gilles', '01010000206A0800000AD7A3F027E32841AE47E1EA99FB5741');
INSERT INTO adresse VALUES ('30258_0882_00030', '30 Rue du Pays d''Oc', '30800', 'Saint-Gilles', '01010000206A080000CDCCCCCC33D828410000008001FC5741');
INSERT INTO adresse VALUES ('30258_0571_00005_bis', '5 bis Rue de l''Hermitage', '30800', 'Saint-Gilles', '01010000206A0800005C8FC2F509E12841C3F528DC64FD5741');
INSERT INTO adresse VALUES ('30258_0065_00003', '3 Rue Baptiste Marcet', '30800', 'Saint-Gilles', '01010000206A0800006666666659DF2841E17A149E0EFC5741');
INSERT INTO adresse VALUES ('30258_0246_00062_e', '62 e Chemin Coupo Santo', '30800', 'Saint-Gilles', '01010000206A0800005C8FC2F561DF28411F85EBC1BCFC5741');
INSERT INTO adresse VALUES ('30258_0175_00042', '42 Avenue de Camargue', '30800', 'Saint-Gilles', '01010000206A0800007B14AE47E9D5284152B81EB5A1FB5741');
INSERT INTO adresse VALUES ('30258_0200_00009', '9 Traverse du Chateau', '30800', 'Saint-Gilles', '01010000206A08000048E17A94F6E328419A9999D967FC5741');
INSERT INTO adresse VALUES ('30258_0208_00035', '35 Rue du Chemin des Courses', '30800', 'Saint-Gilles', '01010000206A0800005C8FC2F579DD2841D7A3707D25FC5741');
INSERT INTO adresse VALUES ('30258_1189_00011', '11 Avenue Sabatot', '30800', 'Saint-Gilles', '01010000206A080000D7A370BD62E428411F85EB01F0FC5741');
INSERT INTO adresse VALUES ('30258_0686_00017', '17 Rue Labracat', '30800', 'Saint-Gilles', '01010000206A0800005C8FC2750CE028416666666687FC5741');
INSERT INTO adresse VALUES ('30258_0860_00016', '16 Rue de la Paix', '30800', 'Saint-Gilles', '01010000206A0800007B14AEC715E328415C8FC28543FC5741');
INSERT INTO adresse VALUES ('30258_1189_00008', '8 Avenue Sabatot', '30800', 'Saint-Gilles', '01010000206A0800003D0AD7A39BE42841A4703D6AF1FC5741');
INSERT INTO adresse VALUES ('30258_0101_00046', '46 Rue Bellevue', '30800', 'Saint-Gilles', '01010000206A080000D7A3703DCADF28418FC2F518CAFB5741');
INSERT INTO adresse VALUES ('30258_1254_00006', '6 Rue des Sarments', '30800', 'Saint-Gilles', '01010000206A080000AE47E17A0CD62841CDCCCC9CD6FB5741');
INSERT INTO adresse VALUES ('30258_0970_00110', '110 Rue Porte de la Blanque', '30800', 'Saint-Gilles', '01010000206A080000C3F528DCE0E22841EC51B8FE5BFC5741');
INSERT INTO adresse VALUES ('30258_0933_00010', '10 Rue Plein Soleil', '30800', 'Saint-Gilles', '01010000206A080000A4703D0A0EE02841000000201EFD5741');
INSERT INTO adresse VALUES ('30258_1207_00006', '6 Rue de Saint-pierre', '30800', 'Saint-Gilles', '01010000206A08000014AE47E1D1E52841CDCCCCCC13FD5741');
INSERT INTO adresse VALUES ('30258_0844_03324', '3324 Chemin d''Espeyran Cc N 9', '30800', 'Saint-Gilles', '01010000206A08000048E17A140AD42841CDCCCC2C4CF85741');
INSERT INTO adresse VALUES ('30258_0740_00002', '2 Rue Maison Romane', '30800', 'Saint-Gilles', '01010000206A08000014AE47E19CE22841C3F5283C1FFC5741');
INSERT INTO adresse VALUES ('30258_0187_00978', '978 Chemin de Charenton', '30800', 'Saint-Gilles', '01010000206A080000F6285C0F96E92841E17A140E93FE5741');
INSERT INTO adresse VALUES ('30258_0900_00001', '1 Avenue Pierre Subleyras', '30800', 'Saint-Gilles', '01010000206A0800000000000093E12841E17A145E8DFC5741');
INSERT INTO adresse VALUES ('30258_0601_00009_quater', '9 quater Impasse de la Gare', '30800', 'Saint-Gilles', '01010000206A08000085EB51B81FE02841000000F095FB5741');
INSERT INTO adresse VALUES ('30258_0729_00042', '42 Rue des Lusitaniens', '30800', 'Saint-Gilles', '01010000206A080000E17A14AEA4E62841000000D014015841');
INSERT INTO adresse VALUES ('30258_0441_00002', '2 Rue Francois Fabre', '30800', 'Saint-Gilles', '01010000206A08000014AE47610ADB2841A4703D5A6EFB5741');
INSERT INTO adresse VALUES ('30258_0460_00003', '3 Chemin de la Fontaine Gillienne', '30800', 'Saint-Gilles', '01010000206A080000295C8FC2D7E02841666666D6B7FB5741');
INSERT INTO adresse VALUES ('30258_0750_00003', '3 Rue Marceau', '30800', 'Saint-Gilles', '01010000206A0800009A9999999DE42841A4703D1A3AFC5741');
INSERT INTO adresse VALUES ('30036_0050_00007', '7 Rue de la Coquille', '30620', 'Bernis', '01010000206A0800001F85EBD1AC852841713D0A678B055841');
INSERT INTO adresse VALUES ('30036_0065_00036', '36 Grand Rue', '30620', 'Bernis', '01010000206A0800001F85EB5155852841713D0AC781055841');
INSERT INTO adresse VALUES ('30036_0097_00004', '4 Rue du Marquis de Baroncelli', '30620', 'Bernis', '01010000206A08000048E17A14768928411F85EBA195055841');
INSERT INTO adresse VALUES ('30036_0029_00011', '11 Rue Carriere Mejeanne', '30620', 'Bernis', '01010000206A080000AE47E1FACA84284185EB51A8D0055841');
INSERT INTO adresse VALUES ('30036_0287_00022', '22 Rue de la Condamine', '30620', 'Bernis', '01010000206A080000A4703D8A1C8928417B14AE078E055841');
INSERT INTO adresse VALUES ('30036_0048_00011', '11 Impasse des Cypres', '30620', 'Bernis', '01010000206A080000D7A3703D3785284185EB5178F4055841');
INSERT INTO adresse VALUES ('30036_0287_00007', '7 Rue de la Condamine', '30620', 'Bernis', '01010000206A080000F6285C8FAC882841F6285C2F7E055841');
INSERT INTO adresse VALUES ('30036_0110_00007', '7 Route d''Uchaud', '30620', 'Bernis', '01010000206A0800005C8FC2753E8428413333338375055841');
INSERT INTO adresse VALUES ('30036_0081_00017', '17 Route Nationale 113', '30620', 'Bernis', '01010000206A08000085EB51B8AC87284100000090C7065841');
INSERT INTO adresse VALUES ('30036_0033_00012', '12 Chemin de Carriere de Barrian', '30620', 'Bernis', '01010000206A080000713D0AD7F78528413D0AD743E6035841');
INSERT INTO adresse VALUES ('30036_0025_00006', '6 Route de Camargue', '30620', 'Bernis', '01010000206A0800008FC2F5A82E87284100000080A6055841');
INSERT INTO adresse VALUES ('30036_0081_00005', '5 Route Nationale 113', '30620', 'Bernis', '01010000206A080000713D0A579F8A284185EB513838075841');
INSERT INTO adresse VALUES ('30036_0082_00048', '48 Route de Nimes', '30620', 'Bernis', '01010000206A080000F6285C8F1288284148E17A248C065841');
INSERT INTO adresse VALUES ('30036_0083_00013', '13 Rue du Murier', '30620', 'Bernis', '01010000206A0800000AD7A3F0F187284166666686D7055841');
INSERT INTO adresse VALUES ('30036_0010_00019', '19 Boulevard Alexandre Ducros', '30620', 'Bernis', '01010000206A080000C3F5285C28852841000000E071055841');
INSERT INTO adresse VALUES ('30036_ghnuqw_00006', '6 Rue Creux de Mantes', '30620', 'Bernis', '01010000206A0800008FC2F5A804862841295C8F224D065841');
INSERT INTO adresse VALUES ('30036_0035_00016_bis', '16 bis Boulevard Charles Mourier', '30620', 'Bernis', '01010000206A080000713D0AD78186284100000010A0055841');
INSERT INTO adresse VALUES ('30036_0112_00004_bis', '4 bis Impasse du Mas des Pins', '30620', 'Bernis', '01010000206A0800005C8FC2F531842841E17A146E37065841');
INSERT INTO adresse VALUES ('30036_0082_00028', '28 Route de Nimes', '30620', 'Bernis', '01010000206A0800005C8FC2F57F8728419A9999A959065841');
INSERT INTO adresse VALUES ('30036_0004_00005', '5 Impasse de l''Aiguillerie', '30620', 'Bernis', '01010000206A080000D7A370BDFE872841A4703DFA9C055841');
INSERT INTO adresse VALUES ('30036_0081_00044_b', '44 b Route Nationale 113', '30620', 'Bernis', '01010000206A080000E17A142EDA832841AE47E1BA48065841');
INSERT INTO adresse VALUES ('30036_0065_00014', '14 Grand Rue', '30620', 'Bernis', '01010000206A080000AE47E1FA2B8628415C8FC2C58E055841');
INSERT INTO adresse VALUES ('30036_0115_00017_ter', '17 ter Avenue de la Vaunage', '30620', 'Bernis', '01010000206A080000C3F528DCBE8428418FC2F5F84D065841');
INSERT INTO adresse VALUES ('30036_0104_00006', '6 Rue du Tambour', '30620', 'Bernis', '01010000206A0800007B14AEC7D28528410AD7A3705F055841');
INSERT INTO adresse VALUES ('30036_0020_00014', '14 Rue Basse', '30620', 'Bernis', '01010000206A080000C3F5285C78872841000000D090055841');
INSERT INTO adresse VALUES ('30036_0010_00005', '5 Boulevard Alexandre Ducros', '30620', 'Bernis', '01010000206A080000A4703D8A4E862841E17A140E69055841');
INSERT INTO adresse VALUES ('30036_0088_00008', '8 Rue de la Portelle', '30620', 'Bernis', '01010000206A0800007B14AEC7FE8428411F85EBF1A5055841');
INSERT INTO adresse VALUES ('30036_0036_00003', '3 Impasse des Chasselas', '30620', 'Bernis', '01010000206A0800005C8FC27551882841295C8F1284065841');
INSERT INTO adresse VALUES ('30036_0090_00004', '4 Chemin de la Prairie', '30620', 'Bernis', '01010000206A0800000AD7A3F0A884284114AE47016E055841');
INSERT INTO adresse VALUES ('30036_0045_00004_bis', '4 bis Rue de la Chicanette', '30620', 'Bernis', '01010000206A08000014AE47E1478728415C8FC23583055841');
INSERT INTO adresse VALUES ('30036_0025_00013', '13 Route de Camargue', '30620', 'Bernis', '01010000206A08000048E17A94BF8728417B14AE6799055841');
INSERT INTO adresse VALUES ('30036_0110_00002', '2 Route d''Uchaud', '30620', 'Bernis', '01010000206A08000085EB51B80585284148E17A247E055841');
INSERT INTO adresse VALUES ('30036_0271_00018', '18 Rue des Bouscatiers', '30620', 'Bernis', '01010000206A08000048E17A94CC8228410AD7A3B001065841');
INSERT INTO adresse VALUES ('30036_0123_00030', '30 chemin des rochelles', '30620', 'Bernis', '01010000206A080000295C8FC21292284133333383CB055841');
INSERT INTO adresse VALUES ('30036_0030_00001', '1 Rue des Casernes', '30620', 'Bernis', '01010000206A080000B81E856BFD8428410AD7A35071055841');
INSERT INTO adresse VALUES ('30036_0113_00005', '5 Rue de la Vallongue', '30620', 'Bernis', '01010000206A080000EC51B89E4086284114AE474144065841');
INSERT INTO adresse VALUES ('30036_0076_00012', '12 Route de Langlade', '30620', 'Bernis', '01010000206A0800005C8FC2F5CF7928417B14AE17CC075841');
INSERT INTO adresse VALUES ('30036_0040_00002_bis', '2 bis Place du Chateau', '30620', 'Bernis', '01010000206A0800000AD7A3706B86284148E17AF484055841');
INSERT INTO adresse VALUES ('30036_0108_00001_a', '1 a Impasse Saint-leonard', '30620', 'Bernis', '01010000206A080000295C8FC2F6862841295C8F229F055841');
INSERT INTO adresse VALUES ('30036_0050_00003', '3 Rue de la Coquille', '30620', 'Bernis', '01010000206A0800005C8FC275BD85284114AE47A18D055841');
INSERT INTO adresse VALUES ('30036_0083_00005', '5 Rue du Murier', '30620', 'Bernis', '01010000206A0800008FC2F5A80B88284133333393D0055841');
INSERT INTO adresse VALUES ('30036_0074_00010_a', '10 a Rue du Lavoir', '30620', 'Bernis', '01010000206A0800000000000023862841A4703D5AC2055841');
INSERT INTO adresse VALUES ('30036_0010_00013_bis', '13 bis Boulevard Alexandre Ducros', '30620', 'Bernis', '01010000206A080000333333336085284152B81EF565055841');
INSERT INTO adresse VALUES ('30036_0099_00008', '8 Impasse de la Plaine', '30620', 'Bernis', '01010000206A080000D7A370BD50842841713D0A6758055841');
INSERT INTO adresse VALUES ('30036_0125_00004_bis', '4 bis Impasse du Lavoir', '30620', 'Bernis', '01010000206A080000295C8F4214862841B81E85BBAC055841');
INSERT INTO adresse VALUES ('30036_0033_00011', '11 Chemin de Carriere de Barrian', '30620', 'Bernis', '01010000206A080000D7A370BD0F862841333333E324045841');
INSERT INTO adresse VALUES ('30036_0020_00013_bis', '13 bis Rue Basse', '30620', 'Bernis', '01010000206A080000295C8FC2A3872841F6285C1F94055841');
INSERT INTO adresse VALUES ('30036_0083_00015', '15 Rue du Murier', '30620', 'Bernis', '01010000206A0800007B14AEC70C8828415C8FC205D8055841');
INSERT INTO adresse VALUES ('30036_0055_00012', '12 Rue du Four', '30620', 'Bernis', '01010000206A080000333333331E8628417B14AE677A055841');
INSERT INTO adresse VALUES ('30036_0064_00004', '4 Rue Fanfonne Guillerme', '30620', 'Bernis', '01010000206A080000295C8F4264882841A4703D6AB5055841');
INSERT INTO adresse VALUES ('30228_0001_00151', '151 Impasse des Anciennes Carrieres', '30190', 'Sainte-Anastasie', '01010000206A080000D7A370BDF49C28413D0AD7D352185841');
INSERT INTO adresse VALUES ('30228_0006_00173', '173 Rue du Bel Air', '30190', 'Sainte-Anastasie', '01010000206A08000014AE476124992841C3F528CC15185841');
INSERT INTO adresse VALUES ('30228_0022_00063', '63 Avenue des Marronniers', '30190', 'Sainte-Anastasie', '01010000206A080000666666662B9E284114AE4701D7185841');
INSERT INTO adresse VALUES ('30228_a075_00010', '10 Lotissement les Oliviers', '30190', 'Sainte-Anastasie', '01010000206A080000CDCCCC4C299E28413D0AD7931A185841');
INSERT INTO adresse VALUES ('30228_0022_00473_bis', '473 bis Avenue des Marronniers', '30190', 'Sainte-Anastasie', '01010000206A080000AE47E17ADAA0284152B81E0512195841');
INSERT INTO adresse VALUES ('30228_0044_00022', '22 Chemin du Rieu', '30190', 'Sainte-Anastasie', '01010000206A080000EC51B89E89A02841C3F528FC07195841');
INSERT INTO adresse VALUES ('30228_a075_00005', '5 Lotissement les Oliviers', '30190', 'Sainte-Anastasie', '01010000206A080000AE47E1FAB29E28410AD7A3C00A185841');
INSERT INTO adresse VALUES ('30228_kdljy0_00004', '4 Rue de la Garrigue', '30190', 'Sainte-Anastasie', '01010000206A0800005C8FC2F5B19A284133333303F5175841');
INSERT INTO adresse VALUES ('30228_0028_00037', '37 Impasse du Jeu de Boules', '30190', 'Sainte-Anastasie', '01010000206A080000CDCCCCCC249F284152B81E65EC185841');
INSERT INTO adresse VALUES ('30228_0021_00378', '378 Avenue du Marel', '30190', 'Sainte-Anastasie', '01010000206A08000014AE4761B4982841713D0A8777185841');
INSERT INTO adresse VALUES ('30228_0020_00047', '47 Rue du Marellas', '30190', 'Sainte-Anastasie', '01010000206A08000052B81E05719A284100000020EE175841');
INSERT INTO adresse VALUES ('30228_0044_00091', '91 Chemin du Rieu', '30190', 'Sainte-Anastasie', '01010000206A08000014AE47E175A0284148E17AA419195841');
INSERT INTO adresse VALUES ('30228_0093_00015', '15 Avenue des Sept', '30190', 'Sainte-Anastasie', '01010000206A08000085EB51B8EE99284148E17A140A185841');
INSERT INTO adresse VALUES ('30228_0006_00093', '93 Rue du Bel Air', '30190', 'Sainte-Anastasie', '01010000206A0800009A99991926992841AE47E16A29185841');
INSERT INTO adresse VALUES ('30228_ajurpl_00700', '700 Rue des Meyrannes', '30190', 'Sainte-Anastasie', '01010000206A080000713D0AD7039F28411F85EB01AA185841');
INSERT INTO adresse VALUES ('30228_0138_00065', '65 Chemin de la Martre', '30190', 'Sainte-Anastasie', '01010000206A080000E17A14AEB7AE284100000090E4185841');
INSERT INTO adresse VALUES ('30228_0025_00015', '15 Avenue du 19 Mars 1962', '30190', 'Sainte-Anastasie', '01010000206A0800009A9999190B9E2841D7A370BDCE185841');
INSERT INTO adresse VALUES ('30228_0006_00159', '159 Rue du Bel Air', '30190', 'Sainte-Anastasie', '01010000206A080000713D0AD7189928410AD7A33019185841');
INSERT INTO adresse VALUES ('30228_ajurpl_00642', '642 Rue des Meyrannes', '30190', 'Sainte-Anastasie', '01010000206A080000295C8FC2A59E2841A4703D7AAE185841');
INSERT INTO adresse VALUES ('30228_0062_00011', '11 Rue du Four', '30190', 'Sainte-Anastasie', '01010000206A0800007B14AEC795A0284166666656E9185841');
INSERT INTO adresse VALUES ('30228_it47wt_00010', '10 Lotissement du Castellas', '30190', 'Sainte-Anastasie', '01010000206A0800009A9999996D9E28413D0AD7232C185841');
INSERT INTO adresse VALUES ('30228_0028_00056', '56 Impasse du Jeu de Boules', '30190', 'Sainte-Anastasie', '01010000206A0800009A999919199F28419A999949F2185841');
INSERT INTO adresse VALUES ('30228_0143_00093', '93 Chemin Departemental 418', '30190', 'Sainte-Anastasie', '01010000206A0800005C8FC275279A2841B81E859B6F185841');
INSERT INTO adresse VALUES ('30228_0011_00085', '85 Chemin Camp Rosier', '30190', 'Sainte-Anastasie', '01010000206A08000048E17A1471AB284114AE4741A7185841');
INSERT INTO adresse VALUES ('30228_0005_00003', '3 Rue du Banc Troue', '30190', 'Sainte-Anastasie', '01010000206A080000713D0AD7189A2841B81E85DBF1175841');
INSERT INTO adresse VALUES ('30228_tyesdu_00003', '3 Les Oliviers', '30190', 'Sainte-Anastasie', '01010000206A080000CDCCCC4C059F28417B14AED70D185841');
INSERT INTO adresse VALUES ('30228_0135_00052', '52 Impasse des Cigales', '30190', 'Sainte-Anastasie', '01010000206A080000EC51B81ED69E28411F85EBE19E185841');
INSERT INTO adresse VALUES ('30228_0107_00159', '159 Impasse Xavier Sigalon', '30190', 'Sainte-Anastasie', '01010000206A080000D7A370BD8C9B284114AE47C1B0185841');
INSERT INTO adresse VALUES ('30228_it47wt_00002', '2 Lotissement du Castellas', '30190', 'Sainte-Anastasie', '01010000206A0800008FC2F5A81C9E284148E17A542D185841');
INSERT INTO adresse VALUES ('30228_0150_00013', '13 Rue du Docteur Jacques Belguise', '30190', 'Sainte-Anastasie', '01010000206A08000048E17A94769F28418FC2F538B4185841');
INSERT INTO adresse VALUES ('30228_0067_00017', '17 Chemin de la Croix Rouge', '30190', 'Sainte-Anastasie', '01010000206A0800006666666649AE2841295C8F12D6185841');
INSERT INTO adresse VALUES ('30228_0085_00137', '137 Rue de la Paix, Russan', '30190', 'Sainte-Anastasie', '01010000206A08000085EB51B8BB9828411F85EB2108185841');
INSERT INTO adresse VALUES ('30228_0033_00016', '16 Rue de la Paix, Aubarne', '30190', 'Sainte-Anastasie', '01010000206A080000F6285C0F12A0284148E17AA4E3185841');
INSERT INTO adresse VALUES ('30228_0074_00081', '81 Rue du Gour du Loup', '30190', 'Sainte-Anastasie', '01010000206A08000014AE47617AA1284166666656B3185841');
INSERT INTO adresse VALUES ('30228_0017_00217', '217 Rue de l''Hotel de Ville', '30190', 'Sainte-Anastasie', '01010000206A0800009A999999499A2841EC51B88E36185841');
INSERT INTO adresse VALUES ('30228_0135_00021', '21 Impasse des Cigales', '30190', 'Sainte-Anastasie', '01010000206A080000CDCCCC4C979E28413D0AD7A3A2185841');
INSERT INTO adresse VALUES ('30228_0088_00061', '61 Impasse du Pradet', '30190', 'Sainte-Anastasie', '01010000206A0800003D0AD7A3FBA128417B14AE97E6185841');
INSERT INTO adresse VALUES ('30228_0141_00290', '290 Chemin de Russan a Aubarne', '30190', 'Sainte-Anastasie', '01010000206A080000B81E856B05A02841A4703D1A97185841');
INSERT INTO adresse VALUES ('30228_0150_00017', '17 Rue du Docteur Jacques Belguise', '30190', 'Sainte-Anastasie', '01010000206A08000085EB51B82A9F28418FC2F508B7185841');
INSERT INTO adresse VALUES ('30228_0026_00027', '27 Rue du Moulin a Vent', '30190', 'Sainte-Anastasie', '01010000206A0800005C8FC275E19A2841D7A370DD0A185841');
INSERT INTO adresse VALUES ('30228_7f4td9_00018', '18 Les Eugnes', '30190', 'Sainte-Anastasie', '01010000206A080000F6285C8F0E96284148E17AF4AC185841');
INSERT INTO adresse VALUES ('30228_0107_00130', '130 Impasse Xavier Sigalon', '30190', 'Sainte-Anastasie', '01010000206A080000CDCCCC4C699B2841B81E85CBB8185841');
INSERT INTO adresse VALUES ('30228_ajurpl_00193', '193 Rue des Meyrannes', '30190', 'Sainte-Anastasie', '01010000206A08000052B81E857C9C2841666666C66D185841');
INSERT INTO adresse VALUES ('30228_0008_00280_a', '280 a Rue du Castellas', '30190', 'Sainte-Anastasie', '01010000206A0800003D0AD7232F9C28419A9999992A185841');
INSERT INTO adresse VALUES ('30228_0111_00064', '64 Chemin des Amandiers', '30190', 'Sainte-Anastasie', '01010000206A080000295C8FC2539F2841713D0AA7BE185841');
INSERT INTO adresse VALUES ('30228_0061_00094', '94 Place de la Fontaine', '30190', 'Sainte-Anastasie', '01010000206A0800000AD7A3F0069A28415C8FC275F9175841');
INSERT INTO adresse VALUES ('30228_0103_00003', '3 Place du Calvaire', '30190', 'Sainte-Anastasie', '01010000206A0800001F85EBD1C2AC2841EC51B80E98185841');
INSERT INTO adresse VALUES ('30228_0042_00070', '70 Rue du Reservoir, Russan', '30190', 'Sainte-Anastasie', '01010000206A080000C3F528DCAE9A28418FC2F538D6175841');
INSERT INTO adresse VALUES ('30228_0021_00272', '272 Avenue du Marel', '30190', 'Sainte-Anastasie', '01010000206A08000014AE47E136992841666666B664185841');
INSERT INTO adresse VALUES ('30228_0010_00132', '132 Rue du Calvaire', '30190', 'Sainte-Anastasie', '01010000206A0800007B14AEC72EAD2841C3F5284CC4185841');
INSERT INTO adresse VALUES ('30075_0137_00006', '6 Rue des Pastourelles', '30820', 'Caveirac', '01010000206A080000F6285C0FD77828419A9999F9EF0B5841');
INSERT INTO adresse VALUES ('30075_0057_00250', '250 Chemin des Dixmes', '30820', 'Caveirac', '01010000206A08000048E17A9459892841AE47E1FA280E5841');
INSERT INTO adresse VALUES ('30075_0061_00116', '116 Chemin des Ecureuils', '30820', 'Caveirac', '01010000206A080000A4703D8A897E2841EC51B8FE1A0B5841');
INSERT INTO adresse VALUES ('30075_a005_00001', '1 Lotissement le Caganson', '30820', 'Caveirac', '01010000206A08000014AE47E1717528410AD7A3906A0B5841');
INSERT INTO adresse VALUES ('30075_0123_00001_a', '1 a Chemin de Massip', '30820', 'Caveirac', '01010000206A08000052B81E85257A2841666666F6190C5841');
INSERT INTO adresse VALUES ('30075_0194_00711', '711 Chemin de Vermaciel', '30820', 'Caveirac', '01010000206A08000052B81E05028028419A9999695B0B5841');
INSERT INTO adresse VALUES ('30075_0049_00010', '10 Avenue du Chemin Neuf', '30820', 'Caveirac', '01010000206A080000000000009E75284100000070FC0B5841');
INSERT INTO adresse VALUES ('30075_0007_00409', '409 Chemin des Alisiers', '30820', 'Caveirac', '01010000206A080000B81E856B6A7D2841D7A3701D2B0B5841');
INSERT INTO adresse VALUES ('30075_0115_00138', '138 Montee du Levant', '30820', 'Caveirac', '01010000206A080000295C8F42417428413D0AD713730C5841');
INSERT INTO adresse VALUES ('30075_0049_00031', '31 Avenue du Chemin Neuf', '30820', 'Caveirac', '01010000206A0800003D0AD7A3A77628410AD7A320DC0B5841');
INSERT INTO adresse VALUES ('30075_0179_00004', '4 Rue du Temple', '30820', 'Caveirac', '01010000206A080000C3F528DC32762841E17A142EF60B5841');
INSERT INTO adresse VALUES ('30075_0049_00034', '34 Avenue du Chemin Neuf', '30820', 'Caveirac', '01010000206A080000AE47E1FA407628417B14AE17E60B5841');
INSERT INTO adresse VALUES ('30075_0118_00333', '333 Chemin du Mas de Mourgues', '30820', 'Caveirac', '01010000206A08000014AE47E12E8428413D0AD7231E0E5841');
INSERT INTO adresse VALUES ('30075_0072_00019', '19 Rue Fanfonne Guillerme', '30820', 'Caveirac', '01010000206A080000EC51B89E25722841EC51B8AE390C5841');
INSERT INTO adresse VALUES ('30075_0072_00016', '16 Rue Fanfonne Guillerme', '30820', 'Caveirac', '01010000206A080000F6285C0FB9732841000000101F0C5841');
INSERT INTO adresse VALUES ('30075_0166_00002', '2 Impasse des Sophoras', '30820', 'Caveirac', '01010000206A080000713D0A578677284152B81EB5C50B5841');
INSERT INTO adresse VALUES ('30075_0082_00004', '4 Rue Font d''Aran', '30820', 'Caveirac', '01010000206A080000A4703D0AAE772841A4703D8A610B5841');
INSERT INTO adresse VALUES ('30075_a062_00017', '17 Lotissement le Village', '30820', 'Caveirac', '01010000206A080000D7A370BD0C7828410AD7A340C40B5841');
INSERT INTO adresse VALUES ('30075_0037_00327', '327 Chemin de la Cascade Est', '30820', 'Caveirac', '01010000206A080000A4703D8A78752841333333E3600C5841');
INSERT INTO adresse VALUES ('30075_0061_00540_bis', '540 bis Chemin des Ecureuils', '30820', 'Caveirac', '01010000206A080000666666667B8028418FC2F5184B0B5841');
INSERT INTO adresse VALUES ('30075_0194_00621', '621 Chemin de Vermaciel', '30820', 'Caveirac', '01010000206A0800008FC2F5A89E7F28410AD7A320580B5841');
INSERT INTO adresse VALUES ('30075_0056_00006', '6 Rue des Cinsaults', '30820', 'Caveirac', '01010000206A080000295C8FC2A77B2841713D0A57F40B5841');
INSERT INTO adresse VALUES ('30075_0114_00111', '111 Chemin des Lentisques', '30820', 'Caveirac', '01010000206A0800009A9999999F792841EC51B8AE0B0B5841');
INSERT INTO adresse VALUES ('30075_tmjv4t_00006', '6 le Caganson', '30820', 'Caveirac', '01010000206A080000B81E85EB58752841713D0A67690B5841');
INSERT INTO adresse VALUES ('30075_0001_00007', '7 Chemin des Acacias', '30820', 'Caveirac', '01010000206A080000AE47E1FAEB772841F6285C7F420C5841');
INSERT INTO adresse VALUES ('30075_0135_00012', '12 Rue des Orfevres', '30820', 'Caveirac', '01010000206A080000B81E856BD1742841A4703DEAEE0B5841');
INSERT INTO adresse VALUES ('30075_0073_00003', '3 Rue de la Farigoulette', '30820', 'Caveirac', '01010000206A080000E17A14AE2A772841CDCCCC9C500C5841');
INSERT INTO adresse VALUES ('30075_0061_00185', '185 Chemin des Ecureuils', '30820', 'Caveirac', '01010000206A080000713D0AD7617F28418FC2F568310B5841');
INSERT INTO adresse VALUES ('30075_a035_00011', '11 Lotissement le Paranove', '30820', 'Caveirac', '01010000206A080000B81E856B99782841000000B06E0C5841');
INSERT INTO adresse VALUES ('30075_0164_00001', '1 Chemin du Semaphore', '30820', 'Caveirac', '01010000206A0800009A9999990F7A28415C8FC275E40B5841');
INSERT INTO adresse VALUES ('30075_0026_00195', '195 Chemin du Bois de Gantier', '30820', 'Caveirac', '01010000206A0800005C8FC275B97E2841E17A145E810B5841');
INSERT INTO adresse VALUES ('30075_0126_00002', '2 Chemin de la Micrause', '30820', 'Caveirac', '01010000206A080000D7A370BD3E79284114AE47C1350C5841');
INSERT INTO adresse VALUES ('30075_0016_00130_a', '130 a Chemin de l''Aspic', '30820', 'Caveirac', '01010000206A080000C3F5285CA17A28418FC2F5684D0B5841');
INSERT INTO adresse VALUES ('30075_0211_00190', '190 Anneau de Fourier', '30820', 'Caveirac', '01010000206A0800009A999999EA742841F6285CDF500B5841');
INSERT INTO adresse VALUES ('30075_0110_00015', '15 rue de la lampisterie', '30820', 'Caveirac', '01010000206A0800009A999919317A2841F6285C6FC20B5841');
INSERT INTO adresse VALUES ('30075_0211_00007', '7 Anneau de Fourier', '30820', 'Caveirac', '01010000206A0800001F85EB51277528417B14AE37590B5841');
INSERT INTO adresse VALUES ('30075_0061_00313', '313 Chemin des Ecureuils', '30820', 'Caveirac', '01010000206A0800005C8FC2F5A57F28411F85EB21310B5841');
INSERT INTO adresse VALUES ('30075_0057_00500', '500 Chemin des Dixmes', '30820', 'Caveirac', '01010000206A080000D7A370BD97872841A4703D2A130E5841');
INSERT INTO adresse VALUES ('30075_0143_00004', '4 Impasse du Pressoir', '30820', 'Caveirac', '01010000206A08000014AE47612E78284152B81E85D40B5841');
INSERT INTO adresse VALUES ('30075_0049_00042', '42 Avenue du Chemin Neuf', '30820', 'Caveirac', '01010000206A080000A4703D0A64762841B81E850BD20B5841');
INSERT INTO adresse VALUES ('30075_0060_00030', '30 Rue des Ecoles', '30820', 'Caveirac', '01010000206A0800007B14AEC710752841000000D0D40B5841');
INSERT INTO adresse VALUES ('30075_0035_00222', '222 Chemin de la Cascade', '30820', 'Caveirac', '01010000206A080000B81E85EBF6742841EC51B82E5B0C5841');
INSERT INTO adresse VALUES ('30075_0145_00056', '56 Chemin de Peyreloubes', '30820', 'Caveirac', '01010000206A080000000000000D6B2841CDCCCCFC3F0F5841');
INSERT INTO adresse VALUES ('30075_0144_00015', '15 Rue de la Pepiniere', '30820', 'Caveirac', '01010000206A080000F6285C0FDB742841AE47E11AF90B5841');
INSERT INTO adresse VALUES ('30075_0173_00008', '8 Chemin de la Sarriette', '30820', 'Caveirac', '01010000206A08000048E17A94CE7A2841E17A146E640C5841');
INSERT INTO adresse VALUES ('30075_0094_00003', '3 Chemin des Genevriers', '30820', 'Caveirac', '01010000206A0800005C8FC27558792841333333E3420B5841');
INSERT INTO adresse VALUES ('30075_0051_00280', '280 Route de Clarensac', '30820', 'Caveirac', '01010000206A0800007B14AEC702712841CDCCCC1C560C5841');
INSERT INTO adresse VALUES ('30075_0150_00012', '12 Impasse du Puits', '30820', 'Caveirac', '01010000206A0800009A999919B3752841D7A370DDEB0B5841');
INSERT INTO adresse VALUES ('30075_0190_00036', '36 Chemin de Vacquerolles', '30820', 'Caveirac', '01010000206A08000014AE4761747B2841A4703D7A430C5841');
INSERT INTO adresse VALUES ('30075_0107_00231', '231 Chemin de la Juniperaie', '30820', 'Caveirac', '01010000206A080000713D0A57207C2841C3F5286C280B5841');
INSERT INTO adresse VALUES ('30189_3876_00075', '75 Impasse Grieg', '30000', 'Nimes', '01010000206A08000052B81E0594A72841B81E851B4E0C5841');
INSERT INTO adresse VALUES ('30189_6290_00325_b', '325 b Traverse du Pissadou', '30000', 'Nimes', '01010000206A08000085EB51388F912841B81E85DBAC0D5841');
INSERT INTO adresse VALUES ('30189_6803_00159', '159 Impasse des Rameaux', '30000', 'Nimes', '01010000206A08000052B81E859AB12841D7A3705D6D0E5841');
INSERT INTO adresse VALUES ('30189_4176_00100', '100 Impasse de l''Horizon', '30000', 'Nimes', '01010000206A0800000AD7A3F05EAA2841EC51B8FE45115841');
INSERT INTO adresse VALUES ('30189_0315_00189_c', '189 c Rue des Anciens Combattants d''AFN', '30000', 'Nimes', '01010000206A0800009A99991930BF2841CDCCCC2C5C0C5841');
INSERT INTO adresse VALUES ('30189_2330_01073', '1073 Route de Courbessac', '30000', 'Nimes', '01010000206A080000F6285C8FE8CA2841CDCCCC7C3F0F5841');
INSERT INTO adresse VALUES ('30189_1580_00004', '4 Rue de la Casernette', '30000', 'Nimes', '01010000206A080000C3F5285C2AB02841C3F5289CD10C5841');
INSERT INTO adresse VALUES ('30189_0170_00095_b', '95 b Route d''Ales', '30000', 'Nimes', '01010000206A08000066666666C6A92841EC51B83EDA0E5841');
INSERT INTO adresse VALUES ('30189_6820_00001', '1 Rue Rangueil', '30000', 'Nimes', '01010000206A080000E17A142E3DB4284185EB5138CA0D5841');
INSERT INTO adresse VALUES ('30189_4230_00015', '15 Rue de l''Hotel Dieu', '30000', 'Nimes', '01010000206A0800000AD7A3F0BCB02841D7A370FDFC0C5841');
INSERT INTO adresse VALUES ('30189_6015_00066', '66 Impasse de la Pastourette', '30000', 'Nimes', '01010000206A080000AE47E1FA3FAB284185EB51F846105841');
INSERT INTO adresse VALUES ('30189_7410_00109', '109 Route de Sauve', '30000', 'Nimes', '01010000206A0800008FC2F528C1A1284152B81E45560D5841');
INSERT INTO adresse VALUES ('30189_4910_00002_b', '2 b Rue des Lys', '30000', 'Nimes', '01010000206A08000052B81E0599AF28413D0AD7A3470B5841');
INSERT INTO adresse VALUES ('30189_6831_00013', '13 Rue Raoul Lhermet', '30000', 'Nimes', '01010000206A08000085EB513850B6284148E17A14960B5841');
INSERT INTO adresse VALUES ('30189_3171_00013', '13 Impasse des Ferronniers', '30000', 'Nimes', '01010000206A080000EC51B81E3F9A284133333373E40F5841');
INSERT INTO adresse VALUES ('30189_2620_00007', '7 Rue Docteur Roux', '30000', 'Nimes', '01010000206A080000AE47E1FA39C028411F85EBA1650D5841');
INSERT INTO adresse VALUES ('30189_2952_00834', '834 Chemin d''Engance', '30000', 'Nimes', '01010000206A0800003D0AD7A3E9B42841A4703D4A69115841');
INSERT INTO adresse VALUES ('30189_2265_00002', '2 Impasse Copernic', '30000', 'Nimes', '01010000206A080000A4703D0A19A02841D7A3701D470C5841');
INSERT INTO adresse VALUES ('30189_6210_00001', '1 Rue Pierre Curie', '30000', 'Nimes', '01010000206A080000713D0A5758BC2841CDCCCC8C6E0D5841');
INSERT INTO adresse VALUES ('30189_1080_00005', '5 Rue Bigot', '30000', 'Nimes', '01010000206A08000048E17A14E3B12841E17A143E210D5841');
INSERT INTO adresse VALUES ('30189_7080_00973', '973 Chemin de Russan', '30000', 'Nimes', '01010000206A080000666666669CB22841AE47E10A7B0F5841');
INSERT INTO adresse VALUES ('30189_1970_00126', '126 Rue du Clapas', '30000', 'Nimes', '01010000206A080000D7A3703DD99F2841AE47E19A3A0B5841');
INSERT INTO adresse VALUES ('30189_7660_00033_b', '33 b Boulevard Talabot', '30000', 'Nimes', '01010000206A080000A4703D8A94BA28415C8FC235730D5841');
INSERT INTO adresse VALUES ('30189_5540_00008', '8 Rue Montaury', '30000', 'Nimes', '01010000206A0800009A9999194CAB284148E17A44170D5841');
INSERT INTO adresse VALUES ('30189_7y8g1b_00045', '45 Rue du Milan', '30000', 'Nimes', '01010000206A080000295C8FC2F4962841333333338E0B5841');
INSERT INTO adresse VALUES ('30189_0731_00075', '75 Impasse de l''Avocette', '30000', 'Nimes', '01010000206A080000A4703D8A0B972841333333F3430B5841');
INSERT INTO adresse VALUES ('30189_4100_00006', '6 Rue Henri Fabre', '30000', 'Nimes', '01010000206A0800003333333378B8284148E17A64830C5841');
INSERT INTO adresse VALUES ('30189_6050_00021', '21 Rue Paul Painleve', '30000', 'Nimes', '01010000206A080000AE47E1FAABBC28411F85EB71470D5841');
INSERT INTO adresse VALUES ('30189_6900_00071_a', '71 a Rue de la Republique', '30000', 'Nimes', '01010000206A080000666666E6ADB02841B81E85FB850C5841');
INSERT INTO adresse VALUES ('30189_3301_00007', '7 Avenue Franklin Roosevelt', '30000', 'Nimes', '01010000206A0800001F85EBD1FBAA2841F6285C1F790D5841');
INSERT INTO adresse VALUES ('30189_6577_00382', '382 Chemin de la Prefecture', '30000', 'Nimes', '01010000206A0800005C8FC275F499284152B81E85FB0F5841');
INSERT INTO adresse VALUES ('30189_6280_00264', '264 Chemin du Pissadou', '30000', 'Nimes', '01010000206A08000000000080FE932841CDCCCC4CE30D5841');
INSERT INTO adresse VALUES ('30189_1796_00001', '1 Rue Charles Montesquieu', '30000', 'Nimes', '01010000206A080000CDCCCC4CA9C82841AE47E10A930F5841');
INSERT INTO adresse VALUES ('30189_4120_00075', '75 Rue Henri Revoil', '30000', 'Nimes', '01010000206A0800000000008024AC284133333303EB0B5841');
INSERT INTO adresse VALUES ('30189_4550_00009', '9 Rue Joseph d''Arbaud', '30000', 'Nimes', '01010000206A080000A4703D0ABA9D2841EC51B83E6A0D5841');
INSERT INTO adresse VALUES ('30189_1448_00245', '245 Impasse des Camelias', '30000', 'Nimes', '01010000206A080000C3F5285C639A28417B14AE77B80C5841');
INSERT INTO adresse VALUES ('30189_3672_00072', '72 Impasse des Genevriers', '30000', 'Nimes', '01010000206A080000295C8F4218B128413D0AD763AB105841');
INSERT INTO adresse VALUES ('30189_6237_00037', '37 Rue Pierre Demoulin', '30000', 'Nimes', '01010000206A080000CDCCCCCCBC9028417B14AE17300E5841');
INSERT INTO adresse VALUES ('30189_6988_00072', '72 Chemin des Rondes', '30000', 'Nimes', '01010000206A080000EC51B81EE3B32841333333431D115841');
INSERT INTO adresse VALUES ('30189_4264_00148_a', '148 a Impasse des Ibis', '30000', 'Nimes', '01010000206A08000052B81E05F39A2841713D0A378C0E5841');
INSERT INTO adresse VALUES ('30189_3170_00036_a', '36 a Rue Florian', '30000', 'Nimes', '01010000206A080000C3F528DCA9AC284152B81EB5110D5841');
INSERT INTO adresse VALUES ('30189_4910_00017', '17 Rue des Lys', '30000', 'Nimes', '01010000206A080000CDCCCCCCDAAF284133333313200B5841');
INSERT INTO adresse VALUES ('30189_1630_00007', '7 Boulevard Chabaud Latour', '30000', 'Nimes', '01010000206A0800008FC2F52829B82841AE47E19A920E5841');
INSERT INTO adresse VALUES ('30189_7305_00223', '223 Rue Sainte-Genevieve', '30000', 'Nimes', '01010000206A080000666666E655B62841295C8F223B0C5841');
INSERT INTO adresse VALUES ('30189_3069_00242', '242 Chemin du Felibre Pomeirac', '30000', 'Nimes', '01010000206A080000B81E85EB61B9284185EB512814105841');
INSERT INTO adresse VALUES ('30189_8411_00194', '194 Rue de la Chrysalide', '30000', 'Nimes', '01010000206A080000713D0AD7BC8D2841295C8FE2A20C5841');
INSERT INTO adresse VALUES ('30189_4431_00238', '238 Cours Jean Monnet', '30000', 'Nimes', '01010000206A0800005C8FC2755BAC28417B14AEE70C0B5841');
INSERT INTO adresse VALUES ('30189_0225_00003', '3 Impasse d''Alicante', '30000', 'Nimes', '01010000206A0800003D0AD7238BBE2841EC51B83EF30C5841');
INSERT INTO adresse VALUES ('30189_3875_00143', '143 Rue Grieg', '30000', 'Nimes', '01010000206A080000F6285C8F35A8284152B81E35670C5841');
INSERT INTO adresse VALUES ('30255_0033_00014', '14 Rue des Canebieres', '30190', 'Saint-Genies-de-Malgoires', '01010000206A08000048E17A940A562841D7A3709D3C195841');
INSERT INTO adresse VALUES ('30255_0156_00008', '8 Chemin du Sel', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000713D0AD712522841B81E85ABA3185841');
INSERT INTO adresse VALUES ('30255_0040_00020', '20 Rue Centrale', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800000AD7A3703358284185EB51880C195841');
INSERT INTO adresse VALUES ('30255_0112_00005', '5 Impasse Jacques Prevert', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800008FC2F5A8245B2841B81E85FBFA185841');
INSERT INTO adresse VALUES ('30255_4t6345_00012_a', '12 a Les Boulevards', '30190', 'Saint-Genies-de-Malgoires', '01010000206A08000085EB51386B5728410AD7A300ED185841');
INSERT INTO adresse VALUES ('30255_0080_00003', '3 Rue de l''Eglise', '30190', 'Saint-Genies-de-Malgoires', '01010000206A08000014AE47E124582841EC51B80E08195841');
INSERT INTO adresse VALUES ('30255_0090_00006', '6 Rue du Fort', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000EC51B89ED057284185EB51C8F6185841');
INSERT INTO adresse VALUES ('30255_0190_00001_b', '1 b Rue Berlioz', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000EC51B89E105428413D0AD7E320195841');
INSERT INTO adresse VALUES ('30255_0142_00016', '16 Chemin du Parc', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000333333B3915A284114AE474104195841');
INSERT INTO adresse VALUES ('30255_0107_00011', '11 Rue Jacqueline Auriol', '30190', 'Saint-Genies-de-Malgoires', '01010000206A08000052B81E0571572841D7A3709DAF185841');
INSERT INTO adresse VALUES ('30255_0006_00004', '4 Impasse Andre Chamson', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000713D0A576351284100000050C0185841');
INSERT INTO adresse VALUES ('30255_0185_00006', '6 Rue Victor Hugo', '30190', 'Saint-Genies-de-Malgoires', '01010000206A08000052B81E851B562841000000308A195841');
INSERT INTO adresse VALUES ('30255_0475_00004', '4 Rue Voltaire', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000B81E85EB985A2841295C8FC2C9185841');
INSERT INTO adresse VALUES ('30255_0033_00005', '5 Rue des Canebieres', '30190', 'Saint-Genies-de-Malgoires', '01010000206A08000085EB51B800552841AE47E19A42195841');
INSERT INTO adresse VALUES ('30255_4t6345_00005', '5 Les Boulevards', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800007B14AEC7515728419A999909F4185841');
INSERT INTO adresse VALUES ('30255_0125_00006', '6 Rue des Marchands', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800005C8FC2F570572841E17A14FE16195841');
INSERT INTO adresse VALUES ('30255_0143_00004_b', '4 b Impasse Pierre et Marie Curie', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000CDCCCCCC7A552841CDCCCCFC84195841');
INSERT INTO adresse VALUES ('30255_0092_00010', '10 Chemin de Gajan', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800003D0AD72388582841E17A14FEDC185841');
INSERT INTO adresse VALUES ('30255_0024_00006', '6 Impasse Bernadette Lafont', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000EC51B81EBB5428419A9999A981185841');
INSERT INTO adresse VALUES ('30255_0124_00006', '6 Rue Marcel Cerdan', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000A4703D8A4F56284185EB51F89D185841');
INSERT INTO adresse VALUES ('30255_0159_00001_bis', '1 bis Chemin de Tavillan', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000E17A142E60542841A4703D7AF2185841');
INSERT INTO adresse VALUES ('30255_8khm5s_00005', '5 Majouraud', '30190', 'Saint-Genies-de-Malgoires', '01010000206A08000000000080E65128410AD7A380A6185841');
INSERT INTO adresse VALUES ('30255_0095_00040', '40 Avenue de la Gare', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000295C8F421F572841EC51B8BE9B195841');
INSERT INTO adresse VALUES ('30255_0147_00016', '16 Chemin des Pierres', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000A4703D8A885328419A9999B9C9185841');
INSERT INTO adresse VALUES ('30255_0408_00011', '11 Impasse du Sel', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800000AD7A3700D522841EC51B86E26195841');
INSERT INTO adresse VALUES ('30255_0092_00045', '45 Chemin de Gajan', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800000AD7A3F0EE582841E17A149E6B185841');
INSERT INTO adresse VALUES ('30255_0092_00001', '1 Chemin de Gajan', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800000AD7A3F088582841295C8F62EB185841');
INSERT INTO adresse VALUES ('30255_0142_00012', '12 Chemin du Parc', '30190', 'Saint-Genies-de-Malgoires', '01010000206A08000052B81E05085A2841C3F5288C0C195841');
INSERT INTO adresse VALUES ('30255_0033_00028_bis', '28 bis Rue des Canebieres', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800000AD7A3F09E522841D7A3704D65195841');
INSERT INTO adresse VALUES ('30255_0090_00004', '4 Rue du Fort', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800000AD7A3F0E6572841C3F528CCF6185841');
INSERT INTO adresse VALUES ('30255_0107_00001', '1 Rue Jacqueline Auriol', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000713D0AD7F7562841D7A3703DA3185841');
INSERT INTO adresse VALUES ('30255_0111_00013', '13 Rue Jean Mermoz', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000A4703D0A525728417B14AE379D185841');
INSERT INTO adresse VALUES ('30255_0088_00002', '2 Chemin des Fontaines', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800005C8FC275D45228410AD7A3B0E5185841');
INSERT INTO adresse VALUES ('30255_0165_00012_bis', '12 bis Rue de la Terrasse', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000E17A14AEBB5828410000002004195841');
INSERT INTO adresse VALUES ('30255_0143_00004', '4 Impasse Pierre et Marie Curie', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800005C8FC2F58D552841CDCCCC0C7A195841');
INSERT INTO adresse VALUES ('30255_0005_00001', '1 Place de l''Ancien Temple', '30190', 'Saint-Genies-de-Malgoires', '01010000206A08000000000000B3582841A4703D2A04195841');
INSERT INTO adresse VALUES ('30255_0040_00011', '11 Rue Centrale', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800009A9999992158284114AE47F10D195841');
INSERT INTO adresse VALUES ('30255_0086_00020', '20 Rue de Ferisson', '30190', 'Saint-Genies-de-Malgoires', '01010000206A08000052B81E05885A28419A99993967195841');
INSERT INTO adresse VALUES ('30255_0087_00006', '6 Rue Alexandre Fleming', '30190', 'Saint-Genies-de-Malgoires', '01010000206A08000000000000F95C2841E17A140EF9185841');
INSERT INTO adresse VALUES ('30255_0040_00001', '1 Rue Centrale', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800007B14AEC7205828411F85EBA1FF185841');
INSERT INTO adresse VALUES ('30255_0156_00005', '5 Chemin du Sel', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000333333B3DD52284100000010B7185841');
INSERT INTO adresse VALUES ('30255_0055_00006', '6 Rue du Chateau', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800003D0AD7A3835728419A9999A9F8185841');
INSERT INTO adresse VALUES ('30255_0091_00005', '5 Rue Frederic Mistral', '30190', 'Saint-Genies-de-Malgoires', '01010000206A08000052B81E85A45B284114AE477167195841');
INSERT INTO adresse VALUES ('30255_0035_00002_bis', '2 bis Rue de la Carrierette', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000D7A370BDF55828411F85EB91FB185841');
INSERT INTO adresse VALUES ('30255_4t6345_00025', '25 Les Boulevards', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000EC51B89E175828418FC2F578ED185841');
INSERT INTO adresse VALUES ('30255_0092_00011', '11 Chemin de Gajan', '30190', 'Saint-Genies-de-Malgoires', '01010000206A080000A4703D8AAB5828410AD7A340C6185841');
INSERT INTO adresse VALUES ('30255_0170_00001', '1 Rue de la Tournelle', '30190', 'Saint-Genies-de-Malgoires', '01010000206A08000014AE476162572841D7A370BD09195841');
INSERT INTO adresse VALUES ('30255_0125_00013_bis', '13 bis Rue des Marchands', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800009A999919F3572841E17A14FE1C195841');
INSERT INTO adresse VALUES ('30255_0030_00019', '19 Rue des Brun', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800008FC2F5A865582841D7A3703D13195841');
INSERT INTO adresse VALUES ('30255_0147_00015_bis', '15 bis Chemin des Pierres', '30190', 'Saint-Genies-de-Malgoires', '01010000206A0800000AD7A3F005512841D7A3707DA5185841');
INSERT INTO adresse VALUES ('30039_0027_00015', '15 Rue du Cavadou', '30320', 'Bezouce', '01010000206A080000C3F5285C670529413D0AD7F3FE125841');
INSERT INTO adresse VALUES ('30039_0030_00113', '113 Rue du Chateau d''Eau', '30320', 'Bezouce', '01010000206A0800003D0AD723360429411F85EBA1BD125841');
INSERT INTO adresse VALUES ('30039_0120_00195', '195 Rue des Pins', '30320', 'Bezouce', '01010000206A080000D7A3703D6E0429410AD7A37078125841');
INSERT INTO adresse VALUES ('30039_0150_00103_b', '103 b Chemin de Sernhac', '30320', 'Bezouce', '01010000206A0800009A999999C105294185EB51F88E125841');
INSERT INTO adresse VALUES ('30039_0100_00001_b', '1 b Rue Mistral', '30320', 'Bezouce', '01010000206A08000048E17A145F052941B81E852B62125841');
INSERT INTO adresse VALUES ('30039_0125_00002', '2 Rue de Provence', '30320', 'Bezouce', '01010000206A080000713D0AD781042941713D0A073F125841');
INSERT INTO adresse VALUES ('30039_0005_00002', '2 Rue Alphonse Daudet', '30320', 'Bezouce', '01010000206A080000E17A14AE940429419A99991942125841');
INSERT INTO adresse VALUES ('30039_0067_00002', '2 Rue de la Garrigue', '30320', 'Bezouce', '01010000206A080000AE47E17ABD0329419A9999C918135841');
INSERT INTO adresse VALUES ('30039_0150_00025_bis', '25 bis Chemin de Sernhac', '30320', 'Bezouce', '01010000206A08000014AE47612B052941E17A144E7C125841');
INSERT INTO adresse VALUES ('30039_gbat80_00004_bis', '4 bis Rue Francois 1er', '30320', 'Bezouce', '01010000206A080000295C8F4225042941CDCCCC2C54125841');
INSERT INTO adresse VALUES ('30039_0106_00005', '5 Rue de la Noria', '30320', 'Bezouce', '01010000206A0800009A999999A00829413D0AD7A360125841');
INSERT INTO adresse VALUES ('30039_0154_00014', '14 Rue des Sophoras', '30320', 'Bezouce', '01010000206A080000C3F5285CF805294114AE47714C125841');
INSERT INTO adresse VALUES ('30039_0105_00080', '80 N Rte Nationale', '30320', 'Bezouce', '01010000206A0800008FC2F528A4022941D7A3707D54125841');
INSERT INTO adresse VALUES ('30039_0105_00002', '2 N Rte Nationale', '30320', 'Bezouce', '01010000206A080000333333B35D052941295C8F428C125841');
INSERT INTO adresse VALUES ('30039_0105_00069', '69 N Rte Nationale', '30320', 'Bezouce', '01010000206A0800003D0AD7A33D012941B81E85EB3D125841');
INSERT INTO adresse VALUES ('30039_0150_00549', '549 Chemin de Sernhac', '30320', 'Bezouce', '01010000206A080000B81E856B22092941295C8F62AB125841');
INSERT INTO adresse VALUES ('30039_ezgerx_00006', '6 rue des chenes verts', '30320', 'Bezouce', '01010000206A080000AE47E1FAAC00294152B81E65D3125841');
INSERT INTO adresse VALUES ('30039_0098_00392', '392 Chemin de Marguerittes', '30320', 'Bezouce', '01010000206A0800000AD7A370580129413D0AD7A315125841');
INSERT INTO adresse VALUES ('30039_0057_00024', '24 Rue du Four a Chaux', '30320', 'Bezouce', '01010000206A0800009A99999910012941295C8F72FE125841');
INSERT INTO adresse VALUES ('30039_0157_00005_bis', '5 bis Rue de la Tapie', '30320', 'Bezouce', '01010000206A0800001F85EB51D4FF2841E17A147E50125841');
INSERT INTO adresse VALUES ('30039_0045_00003', '3 Rue de la Croix du Sang', '30320', 'Bezouce', '01010000206A0800000AD7A3F0EF0429419A9999093A125841');
INSERT INTO adresse VALUES ('30039_0147_00320_b', '320 b Chemin de Saint-bonnet', '30320', 'Bezouce', '01010000206A080000C3F528DCDE082941C3F5282CB5125841');
INSERT INTO adresse VALUES ('30039_0011_00005', '5 Rue de la Safraniere', '30320', 'Bezouce', '01010000206A08000052B81E0582FF2841333333A363125841');
INSERT INTO adresse VALUES ('30039_0024_00056', '56 Rue de la Bergerie', '30320', 'Bezouce', '01010000206A0800001F85EBD12B0229419A9999697B125841');
INSERT INTO adresse VALUES ('30039_0096_00012', '12 Rue du Marche aux Boeufs', '30320', 'Bezouce', '01010000206A0800009A999999FC012941295C8F52CE125841');
INSERT INTO adresse VALUES ('30039_lnm7e1_00057', '57 Route Nationale', '30320', 'Bezouce', '01010000206A080000713D0A5777022941295C8FE24F125841');
INSERT INTO adresse VALUES ('30039_0142_00022', '22 Rue des Rocailles', '30320', 'Bezouce', '01010000206A08000052B81E85A9022941A4703D6A19135841');
INSERT INTO adresse VALUES ('30039_0105_00007', '7 N Rte Nationale', '30320', 'Bezouce', '01010000206A080000EC51B81E5F04294152B81EB56B125841');
INSERT INTO adresse VALUES ('30039_0107_00002', '2 Impasse de l''Oliveraie', '30320', 'Bezouce', '01010000206A080000EC51B89E6F012941F6285C6F62125841');
INSERT INTO adresse VALUES ('30039_0014_00001', '1 Rue de l''Aqueduc', '30320', 'Bezouce', '01010000206A0800008FC2F52837082941333333C387125841');
INSERT INTO adresse VALUES ('30039_0150_00487', '487 Chemin de Sernhac', '30320', 'Bezouce', '01010000206A0800000AD7A3F0DE082941A4703DEA95125841');
INSERT INTO adresse VALUES ('30039_0020_00020', '20 Rue de la Bastide', '30320', 'Bezouce', '01010000206A08000048E17A94D70229410AD7A3208C125841');
INSERT INTO adresse VALUES ('30039_0106_00013', '13 Rue de la Noria', '30320', 'Bezouce', '01010000206A08000014AE47E19A0929411F85EB5167125841');
INSERT INTO adresse VALUES ('30039_0147_00180', '180 Chemin de Saint-bonnet', '30320', 'Bezouce', '01010000206A080000EC51B89EED072941E17A142EAB125841');
INSERT INTO adresse VALUES ('30039_lnm7e1_00056', '56 Route Nationale', '30320', 'Bezouce', '01010000206A080000D7A3703D580329410AD7A34063125841');
INSERT INTO adresse VALUES ('30039_0090_00040', '40 Avenue de la Madone', '30320', 'Bezouce', '01010000206A0800007B14AEC76C042941295C8F3231125841');
INSERT INTO adresse VALUES ('30039_lnm7e1_00062', '62 Route Nationale', '30320', 'Bezouce', '01010000206A080000295C8F422F0329410AD7A3E05D125841');
INSERT INTO adresse VALUES ('30039_a050_00013', '13 Lotissement le Moulin d''Auleadrey', '30320', 'Bezouce', '01010000206A0800001F85EB513502294114AE47D162125841');
INSERT INTO adresse VALUES ('30039_0157_00004', '4 Rue de la Tapie', '30320', 'Bezouce', '01010000206A080000713D0AD7170029413D0AD77340125841');
INSERT INTO adresse VALUES ('30039_0096_00014', '14 Rue du Marche aux Boeufs', '30320', 'Bezouce', '01010000206A08000085EB5138D301294148E17AA4CC125841');
INSERT INTO adresse VALUES ('30039_0159_00005', '5 Rue du Grand Valat', '30320', 'Bezouce', '01010000206A08000000000000E20A29413333331382125841');
INSERT INTO adresse VALUES ('30039_0157_00011', '11 Rue de la Tapie', '30320', 'Bezouce', '01010000206A080000713D0AD743002941F6285CCF50125841');
INSERT INTO adresse VALUES ('30039_0015_00003', '3 Rue de l''Aspic', '30320', 'Bezouce', '01010000206A08000052B81E05FE03294185EB518868125841');
INSERT INTO adresse VALUES ('30039_lnm7e1_00088_bis', '88 bis Route Nationale', '30320', 'Bezouce', '01010000206A0800000AD7A3706E022941D7A3705D51125841');
INSERT INTO adresse VALUES ('30039_0157_00021', '21 Rue de la Tapie', '30320', 'Bezouce', '01010000206A08000033333333A2002941EC51B8CE4D125841');
INSERT INTO adresse VALUES ('30039_0105_00075', '75 N Rte Nationale', '30320', 'Bezouce', '01010000206A080000AE47E17A5C00294114AE47312C125841');
INSERT INTO adresse VALUES ('30039_lnm7e1_00025', '25 Route Nationale', '30320', 'Bezouce', '01010000206A080000333333B3870329410AD7A30062125841');
INSERT INTO adresse VALUES ('30039_0105_00041', '41 N Rte Nationale', '30320', 'Bezouce', '01010000206A08000000000080060329417B14AE0759125841');
INSERT INTO adresse VALUES ('30039_0070_00009_bis', '9 bis Grand Rue', '30320', 'Bezouce', '01010000206A080000295C8FC28D042941EC51B89E5B125841');
INSERT INTO adresse VALUES ('30057_0071_00056', '56 Rue du General de Gaulle', '30210', 'Cabrieres', '01010000206A0800003D0AD723F2F828410AD7A380D7145841');
INSERT INTO adresse VALUES ('30057_0090_00315_c', '315 c Route de Poulx', '30210', 'Cabrieres', '01010000206A0800006666666675F52841AE47E1CA5F155841');
INSERT INTO adresse VALUES ('30057_0130_00100', '100 Chemin des Vayets', '30210', 'Cabrieres', '01010000206A0800008FC2F528AFF52841000000301B155841');
INSERT INTO adresse VALUES ('30057_0088_00217', '217 Rue Marcel Pagnol', '30210', 'Cabrieres', '01010000206A080000A4703D8AC5FA2841F6285C3F9F145841');
INSERT INTO adresse VALUES ('30057_0097_00049', '49 Rue de la Republique', '30210', 'Cabrieres', '01010000206A0800008FC2F5285BF8284114AE47D1D5145841');
INSERT INTO adresse VALUES ('30057_0055_00043', '43 Place de la Croix des Missions', '30210', 'Cabrieres', '01010000206A080000D7A370BD41F928417B14AE77DA145841');
INSERT INTO adresse VALUES ('30057_0054_00425', '425 Chemin des Vignes Clauses', '30210', 'Cabrieres', '01010000206A0800005C8FC275BFEA284152B81E35D9145841');
INSERT INTO adresse VALUES ('30057_0084_00586', '586 Route de Nimes', '30210', 'Cabrieres', '01010000206A080000E17A14AE4AF92841EC51B85E47145841');
INSERT INTO adresse VALUES ('30057_0084_01368', '1368 Route de Nimes', '30210', 'Cabrieres', '01010000206A080000CDCCCCCCC3F92841EC51B84E87145841');
INSERT INTO adresse VALUES ('30057_0058_00012', '12 Rue des Cystes', '30210', 'Cabrieres', '01010000206A08000014AE476143F3284152B81EF5DA145841');
INSERT INTO adresse VALUES ('30057_0069_00617', '617 Rue Frederic Mistral', '30210', 'Cabrieres', '01010000206A0800007B14AE4763F1284133333303F4135841');
INSERT INTO adresse VALUES ('30057_0024_00073', '73 Chemin de la Boissiere', '30210', 'Cabrieres', '01010000206A080000CDCCCCCCF5F52841B81E851B2F155841');
INSERT INTO adresse VALUES ('30057_0004_00119', '119 Chemin des Aires', '30210', 'Cabrieres', '01010000206A080000D7A370BD3FFA2841A4703DAABA145841');
INSERT INTO adresse VALUES ('30057_0073_00014', '14 Impasse des Grives', '30210', 'Cabrieres', '01010000206A080000EC51B89E5FF62841666666A607155841');
INSERT INTO adresse VALUES ('30057_0084_00055', '55 Route de Nimes', '30210', 'Cabrieres', '01010000206A080000F6285C8FC3F92841713D0AC787145841');
INSERT INTO adresse VALUES ('30057_0135_00135', '135 Chemin du Debat', '30210', 'Cabrieres', '01010000206A080000AE47E17A14EB284133333393FF135841');
INSERT INTO adresse VALUES ('30057_0035_00312', '312 Chemin de la Boucarude', '30210', 'Cabrieres', '01010000206A080000E17A14AE6EF52841B81E85CBC2145841');
INSERT INTO adresse VALUES ('30057_0084_00266_bis', '266 bis Route de Nimes', '30210', 'Cabrieres', '01010000206A080000F6285C8FC3F92841713D0AC787145841');
INSERT INTO adresse VALUES ('30057_0133_00130', '130 Rue des Pins', '30210', 'Cabrieres', '01010000206A0800000AD7A3707EF3284185EB5128FF145841');
INSERT INTO adresse VALUES ('30057_ff0q4s_01090', '1090 La Plantade', '30210', 'Cabrieres', '01010000206A080000E17A14AE2CFF2841F6285CCF6A135841');
INSERT INTO adresse VALUES ('30057_0091_00229', '229 Chemin des Planels', '30210', 'Cabrieres', '01010000206A080000D7A370BD5DFC2841A4703DBA0A155841');
INSERT INTO adresse VALUES ('30057_0088_00225', '225 Rue Marcel Pagnol', '30210', 'Cabrieres', '01010000206A0800003D0AD7A3CFFA284148E17AC495145841');
INSERT INTO adresse VALUES ('30057_0016_00176', '176 Chemin de Caveroque', '30210', 'Cabrieres', '01010000206A08000085EB51B8DEF42841AE47E17A11155841');
INSERT INTO adresse VALUES ('30057_0035_00150', '150 Chemin de la Boucarude', '30210', 'Cabrieres', '01010000206A080000713D0A57CEF628417B14AE07C8145841');
INSERT INTO adresse VALUES ('30057_0038_00038', '38 Rue du Cardinal de Cabrieres', '30210', 'Cabrieres', '01010000206A080000295C8F4278F928411F85EBD1E2145841');
INSERT INTO adresse VALUES ('30057_0016_00219', '219 Chemin de Caveroque', '30210', 'Cabrieres', '01010000206A08000066666666BAF428410AD7A300FE145841');
INSERT INTO adresse VALUES ('30057_0079_00010', '10 Chemin du Moulin a Vent', '30210', 'Cabrieres', '01010000206A080000C3F5285CC9F82841295C8F52CA145841');
INSERT INTO adresse VALUES ('30057_0079_00074', '74 Chemin du Moulin a Vent', '30210', 'Cabrieres', '01010000206A080000CDCCCCCC59F928410000008075145841');
INSERT INTO adresse VALUES ('30057_0133_00087', '87 Rue des Pins', '30210', 'Cabrieres', '01010000206A080000E17A142EA2F3284148E17A04F4145841');
INSERT INTO adresse VALUES ('30057_0088_00235', '235 Rue Marcel Pagnol', '30210', 'Cabrieres', '01010000206A080000F6285C8F94FA2841000000B09A145841');
INSERT INTO adresse VALUES ('30057_0004_00159', '159 Chemin des Aires', '30210', 'Cabrieres', '01010000206A0800000AD7A3F016FA2841D7A3702DB4145841');
INSERT INTO adresse VALUES ('30057_0012_00213', '213 Rue des Arbousiers', '30210', 'Cabrieres', '01010000206A0800007B14AEC7B5F3284100000040DD145841');
INSERT INTO adresse VALUES ('30057_0017_00046', '46 Montee de la Barrique', '30210', 'Cabrieres', '01010000206A080000C3F5285CDEF7284100000090F2145841');
INSERT INTO adresse VALUES ('30057_0078_00151_ter', '151 ter Chemin du Mourtisson', '30210', 'Cabrieres', '01010000206A0800000000000001F728410AD7A3C0AB145841');
INSERT INTO adresse VALUES ('30057_w38jwu_00227', '227 La Boucarude', '30210', 'Cabrieres', '01010000206A080000A4703D0A9CEB2841B81E85AB92145841');
INSERT INTO adresse VALUES ('30057_0069_00109', '109 Rue Frederic Mistral', '30210', 'Cabrieres', '01010000206A0800005C8FC275A2F728413D0AD743A1145841');
INSERT INTO adresse VALUES ('30057_0097_00075', '75 Rue de la Republique', '30210', 'Cabrieres', '01010000206A080000AE47E1FA3FF828417B14AE87CE145841');
INSERT INTO adresse VALUES ('30057_0130_00154', '154 Chemin des Vayets', '30210', 'Cabrieres', '01010000206A080000AE47E1FA92F52841B81E85FB13155841');
INSERT INTO adresse VALUES ('30057_0067_00105', '105 Chemin de la Font des Pigeons', '30210', 'Cabrieres', '01010000206A0800008FC2F5A8ACF72841E17A142E21155841');
INSERT INTO adresse VALUES ('30057_0093_00071', '